/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.StandardDirectoryValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public final class ReportDialog
extends StandardDialog {
    private static final String ONLY_HTML_FORMAT = "(Only applicable for HTML format)";
    private static final String METRIC_LEVEL = "metricLevel";
    private static final String METRIC_VALUE_MAX_COUNT = "metricValueMaxRowCount";
    private static final String SPLIT_BY_REPORT = "splitByReport";
    private final List<IMetricLevel> m_availableMetricLevels;
    private final List<IMetricLevel> m_selectedLevels = new ArrayList<IMetricLevel>();
    private final List<IMetricLevel> m_standardMetricLevels;
    private IReport.Format m_selectedReportFormat = IReport.Format.HTML;
    private List<String> m_persistedMetricLevels;
    private TFile m_directory;
    private ValidatingPathWidget m_validatingPathWidget;
    private TableViewer m_tableViewer;
    private ValidatingTextWidget m_validatingMaxRowCountText;
    private int m_currentMetricValueMaxCount;
    private final int m_defaultMaxRowCount;
    private boolean m_splitByModule;
    private Button m_checkSplitByModule;

    public ReportDialog(Shell parentShell, TFile systemDirectory, List<IMetricLevel> availableMetricLevels, List<IMetricLevel> standardMetricLevels, int defaultMaxRowCount) {
        super(parentShell, "Create Report");
        assert (systemDirectory != null) : "Parameter 'systemDirectory' of method 'ReportDialog' must not be null";
        assert (availableMetricLevels != null) : "Parameter 'availableMetricLevels' of method 'ReportDialog' must not be null";
        assert (standardMetricLevels != null) : "Parameter 'standardMetricLevels' of method 'ReportDialog' must not be null";
        String location = WorkbenchRegistry.getInstance().getProvider().getLocation("ExportReport");
        this.m_directory = location != null ? new TFile(location) : systemDirectory;
        this.m_availableMetricLevels = availableMetricLevels;
        this.m_standardMetricLevels = standardMetricLevels;
        this.m_defaultMaxRowCount = defaultMaxRowCount;
    }

    protected void fillDialogArea(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        Label labelDirectory = new Label(composite, 0);
        labelDirectory.setText("Output directory:");
        labelDirectory.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_validatingPathWidget = new ValidatingPathWidget(composite, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                ReportDialog.this.m_directory = input;
                ReportDialog.this.validate();
            }
        }, (IPathValidator)new StandardDirectoryValidator(StandardDirectoryValidator.Permission.READ_WRITE), 3, this.m_directory, true);
        GridData layoutData = new GridData(4, 0x1000000, true, false, 3, 1);
        layoutData.widthHint = 500;
        this.m_validatingPathWidget.setLayoutData((Object)layoutData);
        Label labelReportFormat = new Label(composite, 0);
        labelReportFormat.setText("Report format:");
        labelReportFormat.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        final Button htmlFormat = new Button(composite, 16);
        htmlFormat.setText(IReport.Format.HTML.name());
        htmlFormat.setSelection(true);
        final Button xmlFormat = new Button(composite, 16);
        xmlFormat.setText(IReport.Format.XML.name());
        SelectionAdapter formatListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (htmlFormat.getSelection()) {
                    ReportDialog.this.m_selectedReportFormat = IReport.Format.HTML;
                } else {
                    if (!$assertionsDisabled && !xmlFormat.getSelection()) {
                        throw new AssertionError((Object)"XML format must be selected");
                    }
                    ReportDialog.this.m_selectedReportFormat = IReport.Format.XML;
                }
                ReportDialog.this.m_validatingMaxRowCountText.setEnabled(ReportDialog.this.m_selectedReportFormat == IReport.Format.HTML);
                ReportDialog.this.m_checkSplitByModule.setEnabled(ReportDialog.this.m_selectedReportFormat == IReport.Format.HTML);
            }
        };
        htmlFormat.addSelectionListener((SelectionListener)formatListener);
        xmlFormat.addSelectionListener((SelectionListener)formatListener);
        SwtUtility.createFillerForGridLayoutCell((Composite)composite);
        Label labelMaxCount = new Label(composite, 0);
        labelMaxCount.setText("Max. number values/metric: ");
        labelMaxCount.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.m_validatingMaxRowCountText = new ValidatingTextWidget(composite, new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput != null) {
                    try {
                        int port = Integer.parseInt(newInput);
                        if (port <= 0) {
                            result.addError("Must be a positive number");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        result.addError("Not a valid number");
                    }
                }
                return result;
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String text, boolean inputModified) {
                if (text != null) {
                    try {
                        ReportDialog.this.m_currentMetricValueMaxCount = Integer.parseInt(text);
                    }
                    catch (NumberFormatException nfe) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)ExceptionUtility.collectFirstAndLast((Throwable)nfe));
                        }
                    }
                } else {
                    ReportDialog.this.m_currentMetricValueMaxCount = -1;
                }
                ReportDialog.this.validate();
            }
        });
        GridData layoutData2 = new GridData(4, 0x1000000, false, false, 2, 1);
        this.m_validatingMaxRowCountText.setLayoutData((Object)layoutData2);
        Label explanation = new Label(composite, 0);
        explanation.setText(ONLY_HTML_FORMAT);
        explanation.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        Label splitByModuleLabel = new Label(composite, 0);
        splitByModuleLabel.setText("Split report per Module:");
        splitByModuleLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_checkSplitByModule = new Button(composite, 32);
        this.m_checkSplitByModule.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportDialog.this.m_splitByModule = ReportDialog.this.m_checkSplitByModule.getSelection();
            }
        });
        this.m_checkSplitByModule.setLayoutData((Object)new GridData(1, 128, true, false, 2, 1));
        Label explanationSplit = new Label(composite, 0);
        explanationSplit.setText(ONLY_HTML_FORMAT);
        explanationSplit.setLayoutData((Object)new GridData(1, 128, true, false));
        Label metricLevels = new Label(composite, 0);
        metricLevels.setLayoutData((Object)new GridData(1, 128, true, false, 4, 1));
        metricLevels.setText(StringUtility.LINE_SEPARATOR + "Specify the levels for which metric values are written." + StringUtility.LINE_SEPARATOR + "NOTE: Generating the report for all levels might take some time for large systems." + StringUtility.LINE_SEPARATOR + "For HTML report creation, provide a sensible value for values/metric. Otherwise your browser might have problems rendering.");
        this.m_tableViewer = new TableViewer(composite, 68354);
        this.m_tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.m_tableViewer.getTable().setHeaderVisible(true);
        TableViewerColumn levelColumn = new TableViewerColumn(this.m_tableViewer, 0);
        levelColumn.getColumn().setResizable(true);
        levelColumn.getColumn().setText("Metric Level");
        levelColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!$assertionsDisabled && !(element instanceof IMetricLevel)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + element.getClass().getName()));
                }
                IMetricLevel level = (IMetricLevel)element;
                return level.getPresentationName();
            }
        });
        TableViewerColumn checkColumn = new TableViewerColumn(this.m_tableViewer, 0x1000000);
        checkColumn.getColumn().setResizable(false);
        checkColumn.getColumn().setText("Include");
        checkColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                if (!$assertionsDisabled && cell == null) {
                    throw new AssertionError((Object)"Parameter 'cell' of method 'update' must not be null");
                }
                if (!($assertionsDisabled || cell.getElement() != null && cell.getElement() instanceof IMetricLevel)) {
                    throw new AssertionError((Object)("Unexpected class in method 'update': " + String.valueOf(cell.getElement())));
                }
                IMetricLevel metricLevel = (IMetricLevel)cell.getElement();
                if (ReportDialog.this.m_selectedLevels.contains(metricLevel)) {
                    cell.setImage(UiResourceManager.getInstance().getImage("CheckBoxChecked"));
                } else {
                    cell.setImage(UiResourceManager.getInstance().getImage("CheckBoxUnchecked"));
                }
            }
        });
        this.m_tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.m_tableViewer.setInput(this.m_availableMetricLevels);
        checkColumn.getColumn().pack();
        levelColumn.getColumn().pack();
        this.m_tableViewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent event) {
                int key = event.keyCode;
                if (key == 32) {
                    ReportDialog.this.updateMetricLevelTable((EventObject)event);
                }
            }
        });
        this.m_tableViewer.getTable().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent event) {
                ReportDialog.this.updateMetricLevelTable((EventObject)event);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.m_tableViewer, (int)2);
        SwtUtility.packAllColumnsAndRightAlignLast((TableViewer)this.m_tableViewer);
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false, 4, 1));
        buttonComposite.setLayout((Layout)new FillLayout());
        Button selectAll = new Button(buttonComposite, 8);
        selectAll.setText("Select All");
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportDialog.this.m_selectedLevels.clear();
                ReportDialog.this.m_selectedLevels.addAll(ReportDialog.this.m_availableMetricLevels);
                ReportDialog.this.updateMetricLevelTable();
            }
        });
        Button deselectAll = new Button(buttonComposite, 8);
        deselectAll.setText("Deselect All");
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportDialog.this.m_selectedLevels.clear();
                ReportDialog.this.updateMetricLevelTable();
            }
        });
    }

    private void updateMetricLevelTable(EventObject event) {
        assert (event != null) : "Parameter 'event' of method 'updateToBeSaved' must not be null";
        Object source = event.getSource();
        assert (source != null && source instanceof Table) : "Unexpected class in method 'mouseDown': " + String.valueOf(source);
        Table table = (Table)source;
        StructuredSelection selection = new StructuredSelection((Object[])table.getSelection());
        if (!selection.isEmpty()) {
            Object firstElement = selection.getFirstElement();
            assert (firstElement instanceof TableItem) : "Unexpected class in method 'selectionChanged': " + String.valueOf(firstElement.getClass());
            TableItem item = (TableItem)firstElement;
            assert (item.getData() != null && item.getData() instanceof IMetricLevel) : "Unexpected class in method 'mouseDown': " + String.valueOf(item.getData());
            IMetricLevel metricLevel = (IMetricLevel)item.getData();
            if (this.m_selectedLevels.contains(metricLevel)) {
                this.m_selectedLevels.remove(metricLevel);
            } else {
                this.m_selectedLevels.add(metricLevel);
            }
        }
        this.updateMetricLevelTable();
    }

    private void updateMetricLevelTable() {
        this.m_tableViewer.getTable().setRedraw(false);
        this.m_tableViewer.refresh();
        this.m_tableViewer.getTable().setRedraw(true);
    }

    protected void applyData() {
        IEclipsePreferences preferences = this.getPreferences("com.hello2morrow.sonargraph.standalone");
        this.m_persistedMetricLevels = PreferencesUtility.get((String)METRIC_LEVEL, (IEclipsePreferences)preferences);
        if (this.m_persistedMetricLevels.size() > 0) {
            for (IMetricLevel level : this.m_availableMetricLevels) {
                for (String next : this.m_persistedMetricLevels) {
                    if (!level.getStandardName().equals(next)) continue;
                    this.m_selectedLevels.add(level);
                }
            }
        } else {
            this.m_selectedLevels.addAll(this.m_standardMetricLevels);
        }
        this.updateMetricLevelTable();
        this.m_currentMetricValueMaxCount = preferences.getInt(this.getDialogId().getId() + "_metricValueMaxRowCount", this.m_defaultMaxRowCount);
        if (this.m_currentMetricValueMaxCount <= 0) {
            this.m_currentMetricValueMaxCount = this.m_defaultMaxRowCount;
        }
        this.m_validatingMaxRowCountText.setEnabled(false);
        this.m_validatingMaxRowCountText.setText(Integer.toString(this.m_currentMetricValueMaxCount));
        this.m_validatingMaxRowCountText.setEnabled(true);
        this.m_splitByModule = preferences.getBoolean(SPLIT_BY_REPORT, false);
        this.m_checkSplitByModule.setSelection(this.m_splitByModule);
        this.validate();
    }

    private void validate() {
        this.getButton(0).setEnabled(this.hasValidData());
    }

    protected IEclipsePreferences saveData() {
        List toBePersisted = this.m_selectedLevels.stream().map(level -> level.getStandardName()).collect(Collectors.toList());
        IEclipsePreferences preferences = this.getPreferences("com.hello2morrow.sonargraph.standalone");
        PreferencesUtility.put((String)METRIC_LEVEL, toBePersisted, (IEclipsePreferences)preferences);
        if (this.m_currentMetricValueMaxCount > 0) {
            preferences.putInt(this.getDialogId().getId() + "_metricValueMaxRowCount", this.m_currentMetricValueMaxCount);
        }
        preferences.putBoolean(SPLIT_BY_REPORT, this.m_splitByModule);
        WorkbenchRegistry.getInstance().getProvider().setLocation("ExportReport", this.m_directory == null ? null : this.m_directory.getAbsolutePath());
        return preferences;
    }

    protected int getNumberOfColumns() {
        return 4;
    }

    public boolean hasValidData() {
        return this.m_directory != null && this.m_currentMetricValueMaxCount > 0;
    }

    public List<IMetricLevel> getSelectedMetricLevels() {
        return this.m_selectedLevels;
    }

    public TFile getReportDirectory() {
        return this.m_directory;
    }

    public int getMaxRowCountPerMetric() {
        return this.m_currentMetricValueMaxCount;
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.CREATE_REPORT_DIALOG;
    }

    public IReport.Format getSelectedReportFormat() {
        return this.m_selectedReportFormat;
    }

    public boolean getSplitByModule() {
        return this.m_splitByModule;
    }
}

