/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.PortValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.httpclient.model.ServerInfo;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.HttpConnectionCheckComposite;
import com.hello2morrow.sonargraph.ui.swt.base.IProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class ProxySettingsComposite
extends Composite {
    private final IListener m_listener;
    private final IProxySettingsProvider m_proxySettingsProvider;
    private final boolean m_runsInWorkbench;
    private final ValidatingTextWidget m_port;
    private final ValidatingTextWidget m_host;
    private final ValidatingTextWidget m_userName;
    private final ValidatingTextWidget m_password;
    private ProxySettings m_initialProxySettings;
    private ProxySettings m_currentProxySettings;
    private HttpConnectionCheckComposite m_connectionCheckComposite;
    private boolean m_hostIsValid;
    private boolean m_portIsValid;

    public ProxySettingsComposite(Composite parent, IListener listener, IProxySettingsProvider proxySettingsProvider, boolean runsInWorkbench) {
        super(parent, 0);
        assert (listener != null) : "Parameter 'listener' of method 'ProxySettingsComposite' must not be null";
        assert (proxySettingsProvider != null) : "Parameter 'proxySettingsProvider' of method 'ProxySettingsComposite' must not be null";
        this.m_proxySettingsProvider = proxySettingsProvider;
        this.m_runsInWorkbench = runsInWorkbench;
        this.m_initialProxySettings = proxySettingsProvider.getProxySettings(true);
        this.m_currentProxySettings = this.m_initialProxySettings.copy();
        this.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)2, (boolean)false));
        Label textLabel = new Label((Composite)this, 131072);
        textLabel.setText("Host/IP Address: ");
        this.m_host = new ValidatingTextWidget((Composite)this, new ITextValidator(){

            public ValidationResult isValid(String initialInput, String newInput) {
                if (!$assertionsDisabled && newInput == null) {
                    throw new AssertionError((Object)"Parameter 'newInput' of method 'isValid' must not be null");
                }
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)initialInput, (String)newInput));
                if (!newInput.isEmpty() && (newInput.toLowerCase().startsWith("http://".toLowerCase()) || newInput.toLowerCase().startsWith("https://".toLowerCase()))) {
                    result.addError("Specify without protocol ('http://' or 'https://')");
                }
                return result;
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                if (input != null) {
                    ProxySettingsComposite.this.m_currentProxySettings.setHost(input.trim());
                    ProxySettingsComposite.this.m_hostIsValid = true;
                } else {
                    ProxySettingsComposite.this.m_hostIsValid = false;
                }
                ProxySettingsComposite.this.notifyAboutModification();
            }
        });
        this.m_host.setLayoutData((Object)new GridData(4, 0, true, false));
        Label portFieldLabel = new Label((Composite)this, 131072);
        portFieldLabel.setText("Port: ");
        this.m_port = new ValidatingTextWidget((Composite)this, (ITextValidator)new PortValidator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String text, boolean inputModified) {
                if (text != null) {
                    try {
                        int port = Integer.parseInt(text.trim());
                        ProxySettingsComposite.this.m_currentProxySettings.setPort(port);
                        ProxySettingsComposite.this.m_portIsValid = true;
                    }
                    catch (NumberFormatException nfe) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)ExceptionUtility.collectFirstAndLast((Throwable)nfe));
                        }
                    }
                } else {
                    ProxySettingsComposite.this.m_portIsValid = false;
                }
                ProxySettingsComposite.this.notifyAboutModification();
            }
        });
        this.m_port.setLayoutData((Object)new GridData(4, 0, true, false));
        Label textFieldUserNameLabel = new Label((Composite)this, 131072);
        textFieldUserNameLabel.setText("User (Optional): ");
        this.m_userName = new ValidatingTextWidget((Composite)this, new ITextValidator(){

            public ValidationResult isValid(String initialInput, String newInput) {
                return new ValidationResult(!StringUtility.areEqual((String)initialInput, (String)newInput));
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                if (!$assertionsDisabled && input == null) {
                    throw new AssertionError((Object)"Parameter 'input' of method 'setText' must not be null");
                }
                ProxySettingsComposite.this.m_currentProxySettings.setUserName(input);
                ProxySettingsComposite.this.notifyAboutModification();
            }
        });
        this.m_userName.setLayoutData((Object)new GridData(4, 0, true, false));
        Label textFieldPasswordLabel = new Label((Composite)this, 131072);
        textFieldPasswordLabel.setText("Password (Optional): ");
        this.m_password = new ValidatingTextWidget((Composite)this, new ITextValidator(){

            public ValidationResult isValid(String initialInput, String newInput) {
                return new ValidationResult(!StringUtility.areEqual((String)initialInput, (String)newInput));
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                if (!$assertionsDisabled && input == null) {
                    throw new AssertionError((Object)"Parameter 'input' of method 'setText' must not be null");
                }
                ProxySettingsComposite.this.m_currentProxySettings.setPassword(input);
                ProxySettingsComposite.this.notifyAboutModification();
            }
        }, null, 0x400000);
        this.m_password.setLayoutData((Object)new GridData(4, 0, true, false));
        Label label = new Label((Composite)this, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label.setVisible(false);
        label = new Label((Composite)this, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label.setVisible(false);
        HttpConnectionCheckComposite.IInfoProvider infoProvider = new HttpConnectionCheckComposite.IInfoProvider(){

            @Override
            public List<String> getUrls() {
                return ServerInfo.CONNECTION_CHECK_URLS;
            }

            @Override
            public String getExpectedResonse() {
                return "OK\n";
            }

            @Override
            public ProxySettings getProxy() {
                return ProxySettingsComposite.this.m_currentProxySettings;
            }

            @Override
            public boolean isActive() {
                return ProxySettingsComposite.this.m_runsInWorkbench ? WorkbenchRegistry.isRunning() : true;
            }

            @Override
            public void setChecking(boolean isChecking) {
                ProxySettingsComposite.this.m_port.setEnabled(!isChecking);
                ProxySettingsComposite.this.m_host.setEnabled(!isChecking);
                ProxySettingsComposite.this.m_userName.setEnabled(!isChecking);
                ProxySettingsComposite.this.m_password.setEnabled(!isChecking);
            }

            @Override
            public String getTestConnectionButtonLabel() {
                return "Test Connection Via Proxy";
            }
        };
        this.m_connectionCheckComposite = new HttpConnectionCheckComposite(this, infoProvider);
        this.m_connectionCheckComposite.setLayoutData(new GridData(4, 4, true, true, 2, 2));
        this.m_listener = listener;
        this.applyCurrentProxySettingsToWidgets();
    }

    public boolean hasValidData() {
        return this.m_hostIsValid && this.m_portIsValid;
    }

    private void notifyAboutModification() {
        this.m_connectionCheckComposite.enableTestConnectionButton(this.m_currentProxySettings != null && this.m_currentProxySettings.isValid() && this.hasValidData());
        this.m_listener.inputModified(this.hasValidData(), !this.m_initialProxySettings.equals((Object)this.m_currentProxySettings));
    }

    private void applyCurrentProxySettingsToWidgets() {
        this.m_host.setText(this.m_currentProxySettings.getHost());
        this.m_port.setText(Integer.toString(this.m_currentProxySettings.getPort()));
        this.m_userName.setText(this.m_currentProxySettings.getUserName());
        this.m_password.setText(this.m_currentProxySettings.getPassword());
        this.m_connectionCheckComposite.enableTestConnectionButton(this.m_currentProxySettings.isValid());
    }

    public void storeSettings() {
        if (!this.m_connectionCheckComposite.isChecking()) {
            this.m_proxySettingsProvider.store(this.m_currentProxySettings.getHost(), this.m_currentProxySettings.getPort(), this.m_currentProxySettings.getUserName(), this.m_currentProxySettings.getPassword());
            this.m_initialProxySettings = this.m_currentProxySettings.copy();
            this.m_host.setText(this.m_currentProxySettings.getHost());
        }
    }

    public boolean resetToDefaultsPossible() {
        return !this.m_currentProxySettings.inResetState();
    }

    public void resetToDefaults() {
        if (!this.m_connectionCheckComposite.isChecking()) {
            this.m_connectionCheckComposite.reset();
            this.m_currentProxySettings = new ProxySettings();
            this.applyCurrentProxySettingsToWidgets();
        }
    }

    public void reset() {
        if (!this.m_connectionCheckComposite.isChecking()) {
            this.m_connectionCheckComposite.reset();
            this.m_currentProxySettings = this.m_initialProxySettings.copy();
            this.applyCurrentProxySettingsToWidgets();
        }
    }

    public static interface IListener {
        public void inputModified(boolean var1, boolean var2);
    }
}

