/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class NameAndDescriptionWizardPage
extends StandardWizardPage {
    private final String m_nameFieldLabel;
    private String m_currentName;
    private String m_currentDescription;
    private final boolean m_showDescriptionWidget;
    private boolean m_hasValidData;
    private boolean m_descriptionModified;
    private boolean m_nameModified;
    private final ITextValidator m_nameValidator;
    private ValidatingTextWidget m_validatingNameTextWidget;
    private ValidatingTextWidget m_validatingDescriptionTextWidget;

    public NameAndDescriptionWizardPage(String pageName, String title, String nameFieldLabel, ITextValidator nameValidator, String name, String description) {
        super(pageName, title);
        assert (nameValidator != null) : "Parameter 'nameValidator' of method 'NameAndDescriptionWizardPage' must not be null";
        this.m_nameValidator = nameValidator;
        this.m_nameFieldLabel = nameFieldLabel;
        this.m_currentName = name;
        this.m_currentDescription = description;
        this.m_showDescriptionWidget = description != null;
    }

    public void setEnabled(boolean enable) {
        this.m_validatingNameTextWidget.setEnabled(enable);
        if (this.m_validatingDescriptionTextWidget != null) {
            this.m_validatingDescriptionTextWidget.setEnabled(enable);
        }
    }

    protected void elementNameModified(String name) {
    }

    protected void descriptionModified(String name) {
    }

    protected void addWidgetsToDialogAreaBefore(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'addWidgetsToDialogAreaBefore' must not be null";
    }

    protected void addWidgetsToDialogAreaAfter(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'addWidgetsToDialogArea' must not be null";
    }

    protected final void createContent(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'createContent' must not be null";
        this.addWidgetsToDialogAreaBefore(composite);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(this.m_nameFieldLabel);
        nameLabel.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.m_validatingNameTextWidget = new ValidatingTextWidget(composite, this.m_nameValidator, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String text, boolean inputModified) {
                NameAndDescriptionWizardPage.this.m_currentName = text;
                NameAndDescriptionWizardPage.this.m_nameModified = inputModified;
                NameAndDescriptionWizardPage.this.elementNameModified(NameAndDescriptionWizardPage.this.m_currentName);
                NameAndDescriptionWizardPage.this.validate();
            }
        }, this.m_currentName, 0);
        this.m_validatingNameTextWidget.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        if (this.m_currentDescription != null) {
            Label descriptionLabel = new Label(composite, 0);
            descriptionLabel.setText("Description:");
            descriptionLabel.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
            this.m_validatingDescriptionTextWidget = new ValidatingTextWidget(composite, new ITextValidator(){

                public ValidationResult isValid(String currentInput, String newInput) {
                    return new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                }
            }, new ValidatingTextOrComboWidget.IConsumer(){

                public void setText(ValidatingTextOrComboWidget source, String text, boolean inputModified) {
                    NameAndDescriptionWizardPage.this.m_currentDescription = text;
                    NameAndDescriptionWizardPage.this.m_descriptionModified = inputModified;
                    NameAndDescriptionWizardPage.this.descriptionModified(NameAndDescriptionWizardPage.this.m_currentDescription);
                    NameAndDescriptionWizardPage.this.validate();
                }
            }, this.m_currentDescription, 0);
            this.m_validatingDescriptionTextWidget.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        }
        this.addWidgetsToDialogAreaAfter(composite);
        this.m_validatingNameTextWidget.setFocus();
    }

    protected final ValidatingTextWidget getNameTextWidget() {
        assert (this.m_validatingNameTextWidget != null) : "'m_validatingNameTextWidget' of method 'getNameTextWidget' must not be null";
        return this.m_validatingNameTextWidget;
    }

    public final void setVisible(boolean visible) {
        if (visible) {
            this.validate();
        }
        super.setVisible(visible);
        this.m_validatingNameTextWidget.setFocus();
    }

    protected final void validate() {
        this.m_hasValidData = this.hasBeenDisposed() ? false : this.m_currentName != null && !this.m_currentName.isEmpty() && this.m_nameValidator.isValid(this.m_currentName, this.m_currentName).isSuccess() && (!this.m_showDescriptionWidget || this.m_currentDescription != null);
        this.updatePageCompletion(this.m_hasValidData);
    }

    protected void updatePageCompletion(boolean hasValidData) {
        this.setPageComplete(hasValidData);
    }

    protected final int getNumberOfColumns() {
        return 3;
    }

    public boolean isDescriptionModified() {
        return this.m_descriptionModified;
    }

    public boolean isNameModified() {
        return this.m_nameModified;
    }

    public String getElementName() {
        return this.m_currentName;
    }

    public String getElementDescription() {
        return this.m_currentDescription;
    }
}

