/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architectureview;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.ConnectionScheme;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.SourceViewWidget;

public final class ArchitectureFileViewIssueVisitor
extends NamedElementVisitor
implements ArchitectureElement.IVisitor,
ConnectionScheme.IVisitor,
FilePath.IVisitor {
    private final SourceViewWidget m_sourceViewWidget;

    public ArchitectureFileViewIssueVisitor(SourceViewWidget sourceViewWidget) {
        assert (sourceViewWidget != null) : "Parameter 'sourceViewWidget' of method 'SourceViewIssueVisitor' must not be null";
        this.m_sourceViewWidget = sourceViewWidget;
    }

    public void visitArchitectureElementWithIssues(NamedElement element) {
        assert (element != null && (element instanceof ArchitectureElement || element instanceof ConnectionScheme || element instanceof ArchitectureFile)) : "Unexpected class in method 'visitArchitectureElementWithIssues': " + String.valueOf(element);
        for (Issue issue : element.getIssues()) {
            if (issue.isIgnored()) {
                return;
            }
            String imageResourceName = issue.getImageResourceName() + "Annotation";
            String description = issue.getDescription();
            this.m_sourceViewWidget.addMarker(issue.getLineNumber(), issue.getProvider().getPresentationName(), issue.getPresentationName(false), description, imageResourceName);
        }
        this.visitChildrenOf(element);
    }

    public void visitConnectionScheme(ConnectionScheme element) {
        this.visitArchitectureElementWithIssues((NamedElement)element);
    }

    public void visitArchitectureElement(ArchitectureElement element) {
        this.visitArchitectureElementWithIssues((NamedElement)element);
    }

    public void visitFilePath(FilePath element) {
        this.visitArchitectureElementWithIssues((NamedElement)element);
    }

    public void visitChildrenOf(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
        for (NamedElement next : element.getChildren()) {
            if (!(next instanceof ArchitectureElement) && !(next instanceof ConnectionScheme)) continue;
            next.accept((NamedElement.INamedElementVisitor)this);
        }
    }
}

