/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewArtifactNameValidator;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNameOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.PartialAlternativeInfo;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArtifactComposite;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArtifactFilterPage;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.DraggableAssignableTargetTreeNode;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.IArchitecturalViewSettingsProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDescriptionWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

final class SingleArtifactPage
extends NameAndDescriptionWizardPage
implements DraggableAssignableTargetTreeNode.INameProvider,
ArtifactComposite.IConsumer,
IArchitecturalViewSettingsProvider {
    static final String NAME = CoreDialogId.ARCHITECTURAL_VIEW_SINGLE_ARTIFACT.getStandardName();
    private static final String EDITED = "<edited>";
    private static final String NEW = "<new>";
    private final ArchitecturalViewArtifactNameValidator m_nameValidator;
    private final ExplorationViewRepresentation m_representation;
    private final ArtifactNameOperation m_operation;
    private final PartialAlternativeInfo m_partialAlternativeInfo;
    private final Set<ArtifactNode> m_ignoreSubTree;
    private final ArtifactNode m_toBeEdited;
    private ArtifactComposite m_artifactComposite;
    private ArtifactFilterPage m_filterPage;

    private static String createDefaultName(ArtifactNode toBeEdited, ArtifactNameOperation operation, String name) {
        assert (name != null) : "Parameter 'name' of method 'createDefaultName' must not be null";
        if (operation != null) {
            return operation.getArtifactName();
        }
        if (toBeEdited != null) {
            return toBeEdited.getShortName();
        }
        return name;
    }

    SingleArtifactPage(ArchitecturalViewArtifactNameValidator nameValidator, ArtifactNameOperation operation, String name, Set<ArtifactNode> ignoreSubTree, PartialAlternativeInfo partialAlternativeInfo, ExplorationViewRepresentation representation) {
        super(NAME, "New Artifact", "Name", (ITextValidator)nameValidator, SingleArtifactPage.createDefaultName(null, operation, name), null);
        assert (nameValidator != null) : "Parameter 'nameValidator' of method 'SingleArtifactPage' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'SingleArtifactPage' must not be null";
        assert (ignoreSubTree != null) : "Parameter 'invalidTargetParents' of method 'SingleArtifactPage' must not be null";
        this.m_nameValidator = nameValidator;
        this.m_representation = representation;
        this.m_toBeEdited = null;
        this.m_operation = operation;
        this.m_partialAlternativeInfo = partialAlternativeInfo;
        this.m_ignoreSubTree = ignoreSubTree;
    }

    SingleArtifactPage(ArchitecturalViewArtifactNameValidator nameValidator, ArtifactNode toBeEdited, Set<ArtifactNode> ignoreSubTree, ExplorationViewRepresentation representation) {
        super(NAME, "Edit Artifact", "Name", (ITextValidator)nameValidator, SingleArtifactPage.createDefaultName(toBeEdited, null, ""), null);
        assert (nameValidator != null) : "Parameter 'nameValidator' of method 'SingleArtifactPage' must not be null";
        assert (toBeEdited != null) : "Parameter 'toBeEdited' of method 'SingleArtifactPage' must not be null";
        assert (ignoreSubTree != null) : "Parameter 'invalidTargetParents' of method 'SingleArtifactPage' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'SingleArtifactPage' must not be null";
        this.m_nameValidator = nameValidator;
        this.m_representation = representation;
        this.m_toBeEdited = toBeEdited;
        this.m_operation = null;
        this.m_partialAlternativeInfo = null;
        this.m_ignoreSubTree = ignoreSubTree;
    }

    void setFilterPage(ArtifactFilterPage page) {
        assert (page != null) : "Parameter 'page' of method 'setFilterPage' must not be null";
        this.m_filterPage = page;
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.ARCHITECTURAL_VIEW_SINGLE_ARTIFACT;
    }

    AssignableTargetInfo getAssignableTargetInfo() {
        assert (this.m_artifactComposite != null) : "'m_artifactComposite' of method 'getAssignableTargetInfo' must not be null";
        return this.m_artifactComposite.getAssignableTargetInfo();
    }

    ArtifactProperties getArtifactProperties() {
        return this.m_artifactComposite.getArtifactProperties();
    }

    @Override
    public String getNodeName() {
        String elementName = this.getElementName();
        if (elementName == null || elementName.isEmpty()) {
            if (this.m_operation != null) {
                return this.m_operation.getArtifactName();
            }
            if (this.m_toBeEdited == null) {
                return NEW;
            }
            return EDITED;
        }
        return elementName;
    }

    @Override
    protected void elementNameModified(String name) {
        assert (this.m_artifactComposite != null) : "'m_artifactComposite' of method 'elementNameModified' must not be null";
        this.m_artifactComposite.updateArtifactTreeAndRevealDynamicNode();
    }

    private ArtifactProperties getInitialArtifactProperties() {
        if (this.m_operation != null) {
            return this.m_operation.getArtifactProperties();
        }
        if (this.m_toBeEdited != null) {
            return this.m_toBeEdited.getArtifactProperties();
        }
        return null;
    }

    List<? extends ArchitecturalViewElement> getPartialAlternative() {
        return this.m_artifactComposite.getPartialAlternative();
    }

    @Override
    protected void addWidgetsToDialogAreaAfter(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'addWidgetsToDialogAreaAfter' must not be null";
        this.m_artifactComposite = this.m_toBeEdited == null ? new ArtifactComposite(composite, this.m_nameValidator.getAssignableTargetInfo(), this.getInitialArtifactProperties(), this, this.m_ignoreSubTree, this.m_partialAlternativeInfo, this.m_representation, this) : new ArtifactComposite(composite, this.m_nameValidator.getAssignableTargetInfo(), this.getInitialArtifactProperties(), this, Collections.singletonList(this.m_toBeEdited), this.m_ignoreSubTree, this.m_partialAlternativeInfo, this.m_representation, this);
        this.m_artifactComposite.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        if (this.m_filterPage != null) {
            this.m_filterPage.setAssignableTargetInfo(this.m_artifactComposite.getAssignableTargetInfo());
        }
    }

    boolean hasBeenEdited() {
        boolean same = true;
        if (this.m_operation != null) {
            same = this.m_operation.getArtifactName().equals(this.getElementName()) && this.m_operation.getArtifactProperties().equals((Object)this.m_artifactComposite.getArtifactProperties()) && this.m_operation.getTargetParent().equals(this.m_artifactComposite.getAssignableTargetInfo().getTarget().getArchitecturalViewElement().getRelativePath()) && this.m_operation.getTargetPos() == this.m_artifactComposite.getAssignableTargetInfo().getRelativeIndex();
        } else {
            assert (this.m_toBeEdited != null) : "'m_toBeEdited' of method 'hasBeenEdited' must not be null";
            same = this.m_toBeEdited.getShortName().equals(this.getElementName()) && this.m_toBeEdited.getIncomingDependencyMode().equals((Object)this.m_artifactComposite.getArtifactProperties().getIncomingDependencyMode()) && this.m_toBeEdited.getOutgoingDependencyMode().equals((Object)this.m_artifactComposite.getArtifactProperties().getOutgoingDependencyMode()) && this.m_toBeEdited.getAssignmentMode().equals((Object)this.m_artifactComposite.getArtifactProperties().getAssignmentMode()) && this.m_toBeEdited.getVisibility().equals(this.m_artifactComposite.getArtifactProperties().getVisibility()) && this.m_toBeEdited.getParent() == this.m_artifactComposite.getAssignableTargetInfo().getTarget() && this.m_toBeEdited.getRelativeIndex() == this.m_artifactComposite.getAssignableTargetInfo().getRelativeIndex();
        }
        return !same;
    }

    @Override
    public void inputModified() {
        assert (this.m_artifactComposite != null) : "'m_artifactComposite' of method 'inputModified' must not be null";
        this.m_nameValidator.setAssignableTargetInfo(this.m_artifactComposite.getAssignableTargetInfo());
        if (this.m_filterPage != null) {
            this.m_filterPage.setAssignableTargetInfo(this.m_artifactComposite.getAssignableTargetInfo());
        }
        this.getNameTextWidget().validate(true);
        this.validate();
    }
}

