/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.SearchCommand;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableContainer;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveRootNode;
import com.hello2morrow.sonargraph.core.model.programming.SearchCriteria;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.IArchitecturalViewDialog;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.NodeBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.searchview.SearchDialog;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

final class SearchInArchitecturalViewDialog
extends SearchDialog<ArchitecturalViewNode>
implements IArchitecturalViewDialog {
    private static final String SEARCH_IN_ARCHITECTURAL_VIEW = "SearchInArchitecturalView.";
    private static final String IN_SELECTION_ONLY = "InSelectionOnly";
    private static final String PATTERN = "Pattern";
    private static final String REVEAL_LABEL = "Reveal";
    private static final int REVEAL_WITH_FOCUS_BUTTON_ID = Integer.MAX_VALUE;
    private final IArchitecturalViewProvider m_provider;
    private final ExplorationViewRepresentation m_representation;
    private final List<ArchitecturalViewNode> m_nodes;
    private PropertyTableViewer<ArchitecturalViewNode> m_matchingNodesViewer;
    private Text m_searchPattern;
    private Button m_byName;
    private Button m_byFullName;
    private Button m_autoMatchTrailingCharacters;
    private Button m_ignoreCase;
    private Button m_selectionOnly;
    private Composite m_containedInComposite;
    private GridData m_containedCompositeGridData;
    private Label m_rootNodeImage;
    private Text m_rootNodeText;
    private Label m_assignableContainerImage;
    private Text m_assignableContainerText;
    private boolean m_forceFocus;

    SearchInArchitecturalViewDialog(Shell parentShell, String title, ISoftwareSystemProvider softwareSystemProvider, IArchitecturalViewProvider architecturalViewProvider, List<ArchitecturalViewNode> nodes, ExplorationViewRepresentation representation) {
        super(parentShell, title, softwareSystemProvider);
        assert (title != null && title.length() > 0) : "Parameter 'title' of method 'SearchInArchitecturalViewDialog' must not be empty";
        assert (architecturalViewProvider != null) : "Parameter 'architecturalViewProvider' of method 'SearchInArchitecturalViewDialog' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'SearchInArchitecturalViewDialog' must not be null";
        assert (nodes != null) : "Parameter 'nodes' of method 'SearchInArchitecturalViewDialog' must not be null";
        this.m_provider = architecturalViewProvider;
        this.m_representation = representation;
        this.m_nodes = nodes;
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.SEARCH_IN_ARCHITECTURAL_VIEW_DIALOG;
    }

    protected int getNumberOfColumns() {
        return 2;
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (Integer.MAX_VALUE == buttonId) {
            this.m_forceFocus = true;
            this.okPressed();
        }
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        Button revealButton = this.createButton(parent, 0, REVEAL_LABEL, false);
        Button revealWithFocusButton = this.createButton(parent, Integer.MAX_VALUE, "Reveal With Focus", false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        revealButton.setEnabled(false);
        revealWithFocusButton.setEnabled(false);
    }

    private void setContainmentInfoVisible(boolean isVisible) {
        if (this.m_containedInComposite.isVisible() != isVisible) {
            this.m_containedInComposite.setVisible(isVisible);
            this.m_containedCompositeGridData.exclude = !isVisible;
        }
        this.m_containedInComposite.getParent().layout(true, true);
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        IAssignableContainer assignableTarget;
        ArchitecturalViewNode selectedNode;
        NonRecursiveRootNode rootContainer;
        super.selectionChanged(event);
        this.getButton(Integer.MAX_VALUE).setEnabled(this.getButton(0).isEnabled());
        boolean setVisible = false;
        List selectedNodes = this.getSelected();
        if (selectedNodes.size() == 1 && (rootContainer = (NonRecursiveRootNode)(selectedNode = (ArchitecturalViewNode)selectedNodes.get(0)).getParent(NonRecursiveRootNode.class, ParentMode.SELF_OR_FIRST_PARENT)) != null && (assignableTarget = (IAssignableContainer)selectedNode.getParent(IAssignableContainer.class, new Class[0])) != null) {
            this.m_rootNodeImage.setImage(UiResourceManager.getInstance().getImage((Element)rootContainer));
            this.m_rootNodeText.setText(rootContainer.getName());
            this.m_assignableContainerImage.setImage(UiResourceManager.getInstance().getImage((Element)assignableTarget.getArchitecturalViewElement()));
            this.m_assignableContainerText.setText(assignableTarget.getArchitecturalViewElement().getName());
            setVisible = true;
        }
        if (setVisible) {
            this.setContainmentInfoVisible(true);
        } else {
            this.m_rootNodeText.setText("");
            this.m_assignableContainerText.setText("");
            this.setContainmentInfoVisible(false);
        }
    }

    boolean forceFocus() {
        return this.m_forceFocus;
    }

    protected void fillDialogArea(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createDialogArea' must not be null";
        Label criteriaLabel = new Label(parent, 0);
        criteriaLabel.setText("Search criteria:");
        criteriaLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Composite searchCriteriaGroup = new Composite(parent, 0);
        searchCriteriaGroup.setLayout((Layout)this.createGridLayout(this.m_nodes.isEmpty() ? 5 : 7));
        searchCriteriaGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_byName = new Button(searchCriteriaGroup, 16);
        this.m_byName.setText("Name");
        this.m_byName.setSelection(true);
        this.m_byName.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_byFullName = new Button(searchCriteriaGroup, 16);
        this.m_byFullName.setText("Full name");
        this.m_byFullName.setSelection(false);
        this.m_byFullName.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_byName.addSelectionListener((SelectionListener)this);
        this.m_byFullName.addSelectionListener((SelectionListener)this);
        Label additionalOptionsSeparator = new Label(searchCriteriaGroup, 0);
        additionalOptionsSeparator.setText("| ");
        additionalOptionsSeparator.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_autoMatchTrailingCharacters = new Button(searchCriteriaGroup, 32);
        this.m_autoMatchTrailingCharacters.setText("Auto match trailing characters");
        this.m_autoMatchTrailingCharacters.setSelection(true);
        this.m_autoMatchTrailingCharacters.addSelectionListener((SelectionListener)this);
        this.m_autoMatchTrailingCharacters.setToolTipText("If enabled every pattern is automatically appended with ** to match names starting with the specified pattern");
        this.m_autoMatchTrailingCharacters.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_ignoreCase = new Button(searchCriteriaGroup, 32);
        this.m_ignoreCase.setText("Ignore case");
        this.m_ignoreCase.setSelection(true);
        this.m_ignoreCase.addSelectionListener((SelectionListener)this);
        this.m_ignoreCase.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        if (!this.m_nodes.isEmpty()) {
            additionalOptionsSeparator = new Label(searchCriteriaGroup, 0);
            additionalOptionsSeparator.setText("| ");
            additionalOptionsSeparator.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            this.m_selectionOnly = new Button(searchCriteriaGroup, 32);
            this.m_selectionOnly.setText("In selection only");
            this.m_selectionOnly.setSelection(false);
            this.m_selectionOnly.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            this.m_selectionOnly.addSelectionListener((SelectionListener)this);
        }
        Label searchPatternLabel = new Label(parent, 0);
        searchPatternLabel.setText("Search pattern:");
        searchPatternLabel.setToolTipText("Wildcards: ?=any character, *=any sequence between dots or slashes, **=any sequence\nTo reveal a found element either select it and press OK or simply double click it.");
        searchPatternLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_searchPattern = new Text(parent, 2048);
        this.m_searchPattern.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_searchPattern.addModifyListener((ModifyListener)this);
        this.m_searchPattern.addVerifyListener((VerifyListener)this);
        this.m_searchPattern.addKeyListener((KeyListener)this);
        this.m_matchingNodesViewer = new PropertyTableViewer(parent, (BeanPropertyReader.BeanAdapter)new NodeBeanAdapter(), "name", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_matchingNodesViewer.addColumn("Element", "presentationName", "name", "image", 80, PropertyTableViewer.ColumnType.TEXT);
        this.m_matchingNodesViewer.addColumn("Info", "info", "info", null, 20, PropertyTableViewer.ColumnType.TEXT);
        this.m_matchingNodesViewer.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_matchingNodesViewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_matchingNodesViewer.getTableViewer().addDoubleClickListener((IDoubleClickListener)this);
        this.m_matchingNodesViewer.getTable().addKeyListener((KeyListener)this);
        this.m_containedInComposite = new Composite(parent, 0);
        this.m_containedCompositeGridData = new GridData(4, 0x1000000, true, false, this.getNumberOfColumns(), 1);
        this.m_containedInComposite.setLayoutData((Object)this.m_containedCompositeGridData);
        this.m_containedInComposite.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithMargin((int)3));
        Label textParentPath = new Label(this.m_containedInComposite, 0);
        textParentPath.setText("Contained in: ");
        textParentPath.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_rootNodeImage = new Label(this.m_containedInComposite, 0);
        this.m_rootNodeImage.setImage(UiResourceManager.getInstance().getImage(Module.IMAGE_RESOURCE_NAME));
        this.m_rootNodeImage.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_rootNodeText = new Text(this.m_containedInComposite, 8);
        this.m_rootNodeText.setBackground(this.m_containedInComposite.getBackground());
        this.m_rootNodeText.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        SwtUtility.createFillerForGridLayoutCell((Composite)this.m_containedInComposite);
        this.m_assignableContainerImage = new Label(this.m_containedInComposite, 0);
        this.m_assignableContainerImage.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_assignableContainerText = new Text(this.m_containedInComposite, 72);
        this.m_assignableContainerText.setBackground(this.m_containedInComposite.getBackground());
        this.m_assignableContainerText.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_containedInComposite.setVisible(false);
        this.m_containedCompositeGridData.exclude = true;
        this.m_searchPattern.setFocus();
    }

    protected void applyData() {
        IEclipsePreferences settings = this.getPreferences("com.hello2morrow.sonargraph.standalone");
        boolean isSearchByFullName = settings.getBoolean(SEARCH_IN_ARCHITECTURAL_VIEW + SearchCriteria.FULL_NAME.name(), false);
        this.m_byName.setSelection(!isSearchByFullName);
        this.m_byFullName.setSelection(isSearchByFullName);
        this.m_autoMatchTrailingCharacters.setSelection(settings.getBoolean(SEARCH_IN_ARCHITECTURAL_VIEW + SearchCriteria.AUTO_MATCH_TRAILING_CHARACTERS.name(), true));
        this.m_ignoreCase.setSelection(settings.getBoolean(SEARCH_IN_ARCHITECTURAL_VIEW + SearchCriteria.IGNORE_CASE.name(), true));
        if (this.m_selectionOnly != null) {
            this.m_selectionOnly.setSelection(settings.getBoolean("SearchInArchitecturalView.InSelectionOnly", false));
        }
        this.m_searchPattern.setText(settings.get("SearchInArchitecturalView.Pattern", ""));
    }

    protected IEclipsePreferences saveData() {
        IEclipsePreferences settings = this.getPreferences("com.hello2morrow.sonargraph.standalone");
        settings.putBoolean(SEARCH_IN_ARCHITECTURAL_VIEW + SearchCriteria.FULL_NAME.name(), this.m_byFullName.getSelection());
        settings.putBoolean(SEARCH_IN_ARCHITECTURAL_VIEW + SearchCriteria.AUTO_MATCH_TRAILING_CHARACTERS.name(), this.m_autoMatchTrailingCharacters.getSelection());
        settings.putBoolean(SEARCH_IN_ARCHITECTURAL_VIEW + SearchCriteria.IGNORE_CASE.name(), this.m_ignoreCase.getSelection());
        if (this.m_selectionOnly != null) {
            settings.putBoolean("SearchInArchitecturalView.InSelectionOnly", this.m_selectionOnly.getSelection());
        }
        settings.put("SearchInArchitecturalView.Pattern", this.m_searchPattern.getText());
        return settings;
    }

    @Override
    protected Text getSearchPatternText() {
        return this.m_searchPattern;
    }

    @Override
    protected PropertyTableViewer<ArchitecturalViewNode> getMatchingElementsViewer() {
        return this.m_matchingNodesViewer;
    }

    @Override
    protected void validateSearchPattern() {
        final String pattern = this.m_searchPattern.getText();
        final EnumSet<SearchCriteria> searchCriteria = EnumSet.noneOf(SearchCriteria.class);
        if (this.m_byFullName.getSelection()) {
            searchCriteria.add(SearchCriteria.FULL_NAME);
        }
        if (this.m_autoMatchTrailingCharacters.getSelection()) {
            searchCriteria.add(SearchCriteria.AUTO_MATCH_TRAILING_CHARACTERS);
        }
        if (this.m_ignoreCase.getSelection()) {
            searchCriteria.add(SearchCriteria.IGNORE_CASE);
        }
        if (this.m_provider.isSearchPatternValid(pattern, searchCriteria)) {
            this.cancelSearch();
            final boolean useNodes = this.m_selectionOnly != null && this.m_selectionOnly.getSelection();
            final SearchCommand command = new SearchCommand(this.getSoftwareSystemProvider(), new SearchCommand.ISearchInteraction(){

                public boolean collect(SearchCommand.SearchData data) {
                    if (!$assertionsDisabled && data == null) {
                        throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                    }
                    data.setRepresentation(SearchInArchitecturalViewDialog.this.m_representation);
                    data.setPattern(pattern);
                    data.setSearchCriteria(searchCriteria);
                    if (useNodes) {
                        data.setSearchInNodes(SearchInArchitecturalViewDialog.this.m_nodes);
                    }
                    return true;
                }
            });
            assert (command.isEnabled().isSuccess()) : "Not enabled: " + String.valueOf(command);
            UserInterfaceAdapter.getInstance().run((Command)command, this.getCurrentWorkerContext((SonargraphCommand)command), new CommandResultConsumer(){

                public void consume(CommandException exception) {
                    super.consume(exception);
                    if (SearchInArchitecturalViewDialog.this.getCurrentCommand() == command && exception == null && SearchInArchitecturalViewDialog.this.m_matchingNodesViewer != null && !SearchInArchitecturalViewDialog.this.m_matchingNodesViewer.isDisposed()) {
                        SearchInArchitecturalViewDialog.this.m_matchingNodesViewer.showData((Collection)command.getMatching());
                    }
                }
            });
        } else {
            this.m_matchingNodesViewer.showData(Collections.emptyList());
        }
    }
}

