/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewStructureMode;
import com.hello2morrow.sonargraph.core.model.path.ArchitecturalViewsDirectory;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDescriptionWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.NamedElementViewContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

final class NewArchitecturalViewWizardPage
extends NameAndDescriptionWizardPage
implements ISelectionChangedListener {
    private static final String NO_SELECTION = " (none)";
    private final ArchitecturalViewsDirectory m_views;
    private final boolean m_openArchitecturalViewIsPossible;
    private ArchitecturalViewFile m_basedOn;
    private ExplorationViewStructureMode m_structureMode = ExplorationViewStructureMode.getDefault();
    private CLabel m_architecturalViewLabel;
    private Composite m_structureModeComposite;
    private boolean m_openArchitecturalView;

    public NewArchitecturalViewWizardPage(ITextValidator nameValidator, ArchitecturalViewsDirectory views, ArchitecturalViewFile basedOn, boolean openArchitecturalViewIsPossible) {
        super(CoreDialogId.ARCHITECTURAL_VIEW_NEW.getStandardName(), "New Architectural View", "Name", nameValidator, "", "");
        assert (views != null) : "Parameter 'views' of method 'CreateArchitecturalViewWizardPage' must not be null";
        this.m_views = views;
        this.m_basedOn = basedOn;
        this.m_openArchitecturalView = this.m_openArchitecturalViewIsPossible = openArchitecturalViewIsPossible;
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.ARCHITECTURAL_VIEW_NEW;
    }

    @Override
    protected void addWidgetsToDialogAreaAfter(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'addWidgetsToDialogAreaAfter' must not be null";
        Label structureModeLabel = new Label(composite, 0);
        structureModeLabel.setText("Structure mode:");
        structureModeLabel.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        this.m_structureModeComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        this.m_structureModeComposite.setLayout((Layout)gridLayout);
        this.m_structureModeComposite.setLayoutData((Object)new GridData(1, 1, true, false, 2, 1));
        SoftwareSystem softwareSystem = WorkbenchRegistry.getInstance().getSoftwareSystem();
        ExplorationViewStructureMode structureMode = this.m_basedOn == null ? ExplorationViewStructureMode.getDefault() : this.m_basedOn.getStructureMode();
        ExplorationViewStructureMode[] explorationViewStructureModeArray = ExplorationViewStructureMode.values();
        int n = explorationViewStructureModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            final ExplorationViewStructureMode nextMode = explorationViewStructureModeArray[n2];
            if (nextMode.isAvailableFor((Collection)(softwareSystem != null ? softwareSystem.getUsedLanguages() : null))) {
                Button nextButton = new Button(this.m_structureModeComposite, 16);
                nextButton.setText(nextMode.getPresentationName());
                nextButton.setData((Object)nextMode);
                if (nextMode.equals((Object)structureMode)) {
                    nextButton.setSelection(true);
                }
                nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        NewArchitecturalViewWizardPage.this.m_structureMode = nextMode;
                    }
                });
                nextButton.setLayoutData((Object)new GridData(1, 1, false, false));
            }
            ++n2;
        }
        Label label = new Label(composite, 0);
        label.setText("Architectural view based on: ");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        this.m_architecturalViewLabel = new CLabel(composite, 0);
        if (this.m_basedOn != null) {
            this.m_architecturalViewLabel.setText(this.m_basedOn.getPresentationName(false));
            this.m_architecturalViewLabel.setImage(UiResourceManager.getInstance().getImage((Element)this.m_basedOn));
        } else {
            this.m_architecturalViewLabel.setText(this.m_views.getPresentationName(false) + NO_SELECTION);
            this.m_architecturalViewLabel.setImage(UiResourceManager.getInstance().getImage((Element)this.m_views));
        }
        this.m_architecturalViewLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        TreeViewer modelView = new TreeViewer(composite, 4);
        modelView.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        NamedElementViewContentAndLabelProvider contentAndLabelProvider = new NamedElementViewContentAndLabelProvider(Collections.singletonList(ArchitecturalViewsDirectory.class), Collections.singletonList(ArchitecturalViewFile.class));
        modelView.setContentProvider((IContentProvider)contentAndLabelProvider);
        modelView.setLabelProvider((IBaseLabelProvider)contentAndLabelProvider);
        modelView.setInput((Object)this.m_views.getParent());
        modelView.expandAll();
        Composite openViewComposite = new Composite(composite, 0);
        openViewComposite.setLayout((Layout)new FillLayout());
        openViewComposite.setLayoutData((Object)new GridData(0x1000008, 1, true, false, 3, 1));
        final Button openView = new Button(openViewComposite, 32);
        openView.setText("Open architectural view");
        openView.setSelection(this.m_openArchitecturalView);
        if (this.m_openArchitecturalViewIsPossible) {
            openView.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NewArchitecturalViewWizardPage.this.m_openArchitecturalView = openView.getSelection();
                }
            });
        } else {
            openView.setEnabled(false);
        }
        if (this.m_basedOn != null) {
            modelView.setSelection((ISelection)new StructuredSelection((Object)this.m_basedOn));
            Control[] controlArray = this.m_structureModeComposite.getChildren();
            int n3 = controlArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Control nextButton = controlArray[n4];
                assert (nextButton instanceof Button) : "Unexpected class in method 'selectionChanged': " + String.valueOf(nextButton);
                nextButton.setEnabled(false);
                ++n4;
            }
        } else {
            modelView.setSelection((ISelection)new StructuredSelection((Object)this.m_views));
        }
        modelView.addSelectionChangedListener((ISelectionChangedListener)this);
        super.addWidgetsToDialogAreaAfter(composite);
    }

    public final void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof ArchitecturalViewFile) {
            this.m_basedOn = (ArchitecturalViewFile)selectedElement;
            this.m_structureMode = this.m_basedOn.getStructureMode();
            this.m_architecturalViewLabel.setText(this.m_basedOn.getPresentationName(false));
            this.m_architecturalViewLabel.setImage(UiResourceManager.getInstance().getImage((Element)this.m_basedOn));
            Control[] controlArray = this.m_structureModeComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control nextButton = controlArray[n2];
                assert (nextButton instanceof Button) : "Unexpected class in method 'selectionChanged': " + String.valueOf(nextButton);
                ((Button)nextButton).setSelection(this.m_basedOn.getStructureMode().equals(nextButton.getData()));
                nextButton.setEnabled(false);
                ++n2;
            }
        } else {
            this.m_basedOn = null;
            this.m_architecturalViewLabel.setText(this.m_views.getPresentationName(false) + NO_SELECTION);
            this.m_architecturalViewLabel.setImage(UiResourceManager.getInstance().getImage((Element)this.m_views));
            Control[] controlArray = this.m_structureModeComposite.getChildren();
            int n = controlArray.length;
            int n3 = 0;
            while (n3 < n) {
                Control nextButton = controlArray[n3];
                assert (nextButton instanceof Button) : "Unexpected class in method 'selectionChanged': " + String.valueOf(nextButton);
                nextButton.setEnabled(true);
                ++n3;
            }
        }
        this.m_architecturalViewLabel.getParent().layout(true);
        this.m_architecturalViewLabel.layout(true);
    }

    boolean openView() {
        return this.m_openArchitecturalView;
    }

    ArchitecturalViewFile getBasedOn() {
        return this.m_basedOn;
    }

    ExplorationViewStructureMode getStructureMode() {
        return this.m_structureMode;
    }
}

