/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.MoveElementsCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.explorationview.PartialAlternativeInfo;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewHandler;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewMenuGroup;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.MoveElementsDialog;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IMenuGroup;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

public final class MoveElementsHandler
extends ArchitecturalViewHandler {
    public IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public String getLabel(IWorkbenchView workbenchView, List<Element> elements, String defaultLabel) {
                if (!$assertionsDisabled && elements == null) {
                    throw new AssertionError((Object)"Parameter 'elements' of method 'getLabel' must not be null");
                }
                return elements.size() == 1 ? "Move Element..." : "Move Elements...";
            }

            public IMenuGroup getMenuGroup() {
                return ArchitecturalViewMenuGroup.OTHER;
            }
        };
    }

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.MOVE_ARCHITECTURAL_VIEW_ELEMENTS;
    }

    @CanExecute
    public final boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        List elements;
        if (this.mayBeExecuted(selection) && !(elements = MoveElementsHandler.getMultipleSelectionIfAllAreAssignable(ArchitecturalViewElement.class, (List)selection.getElements())).isEmpty()) {
            return ((IArchitecturalViewProvider)WorkbenchRegistry.getInstance().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).isMoveElementsPossible(elements);
        }
        return false;
    }

    @Execute
    public final void execute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'execute' must not be null";
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "Not software system available";
        List elements = MoveElementsHandler.getMultipleSelectionIfAllAreAssignable(ArchitecturalViewNode.class, (List)selection.getElements());
        assert (elements != null && !elements.isEmpty()) : "'elements' of method 'execute' must not be empty";
        IArchitecturalViewProvider architecturalViewProvider = (IArchitecturalViewProvider)WorkbenchRegistry.getInstance().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class);
        PartialAlternativeInfo alternativeInfo = architecturalViewProvider.calculatePartialMoveElementsAlternative(elements);
        final MoveElementsDialog dialog = new MoveElementsDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), provider, architecturalViewProvider, elements, alternativeInfo);
        if (dialog.open() == 0) {
            MoveElementsCommand command = new MoveElementsCommand(provider, new MoveElementsCommand.IMoveElementsInteraction(){

                public boolean collect(MoveElementsCommand.MoveElementsData data) {
                    if (!$assertionsDisabled && data == null) {
                        throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                    }
                    data.set(dialog.getElements(), dialog.getMovableTargetInfo());
                    return true;
                }

                public void processMoveElementsResult(OperationResult result) {
                    if (!$assertionsDisabled && result == null) {
                        throw new AssertionError((Object)"Parameter 'result' of method 'processMoveElementsResult' must not be null");
                    }
                    UserInterfaceAdapter.getInstance().process(result);
                }
            });
            UserInterfaceAdapter.getInstance().run((Command)command);
        }
    }
}

