/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.DeleteDependenciesCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewCommandAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.compositecommand.CompositeCommandAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import java.util.Collection;
import java.util.List;

public final class DeleteDependenciesCommandAdapter
extends ArchitecturalViewCommandAdapter {
    public CompositeCommandAdapter.Type getType() {
        return CompositeCommandAdapter.Type.DELETE;
    }

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.DELETE_ARCHITECTURAL_VIEW_DEPENDENCIES;
    }

    public CompositeCommandAdapter.Applicable applicable(ISoftwareSystemProvider provider, List<Element> elements) {
        IArchitecturalViewProvider architecturalViewProvider;
        List dependencies;
        assert (provider != null) : "Parameter 'provider' of method 'applicable' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'applicable' must not be null";
        if (WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED}) && !elements.isEmpty() && !(dependencies = CommandHandler.getMultipleSelectionIfAllAreAssignable(ArchitecturalViewNode.ArchitecturalViewDependency.class, elements)).isEmpty() && (architecturalViewProvider = (IArchitecturalViewProvider)provider.getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).isDeleteDependenciesPossible(dependencies)) {
            ArchitecturalViewFile file = architecturalViewProvider.getArchitecturalViewFile((Collection)dependencies);
            assert (file != null) : "'file' of method 'applicable' must not be null";
            if (dependencies.size() == 1) {
                return new CompositeCommandAdapter.Applicable("Dependency In Architectural View [" + file.getIdentifyingPath() + "]", "Dependency");
            }
            return new CompositeCommandAdapter.Applicable("Dependencies In Architectural View [" + file.getIdentifyingPath() + "]", "Dependencies");
        }
        return null;
    }

    public void apply(ISoftwareSystemProvider provider, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'apply' must not be null";
        assert (provider.hasSoftwareSystem()) : "No system available";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'apply' must not be empty";
        final List dependencies = CommandHandler.getMultipleSelectionIfAllAreAssignable(ArchitecturalViewNode.ArchitecturalViewDependency.class, elements);
        assert (dependencies != null && !dependencies.isEmpty()) : "Parameter 'dependencies' of method 'apply' must not be empty";
        DeleteDependenciesCommand command = new DeleteDependenciesCommand(provider, new DeleteDependenciesCommand.IDeleteDependenciesInteraction(){

            public boolean collect(DeleteDependenciesCommand.DependenciesData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setDependencies(dependencies);
                return true;
            }

            public void processDeleteDependenciesResult(OperationResult result) {
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)"Parameter 'result' of method 'processDeleteDependencyResult' must not be null");
                }
                UserInterfaceAdapter.getInstance().process(result);
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)command);
    }
}

