/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetrieverProvider;
import com.hello2morrow.sonargraph.core.model.architecture.ParsedPatternInfo;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFilter;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeFilter;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.explorationview.PatternFilterExclude;
import com.hello2morrow.sonargraph.core.model.explorationview.PatternFilterInclude;
import com.hello2morrow.sonargraph.core.model.explorationview.PatternType;
import com.hello2morrow.sonargraph.foundation.activity.CancellableWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.propertyreader.StringBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.IArchitecturalViewSettingsProvider;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.Matcher;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.NodeBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.PatternFilterWithMatchingCounterBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.FocusableToolTip;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

final class ArtifactFilterPage
extends StandardWizardPage
implements IArchitecturalViewSettingsProvider,
ModifyListener,
FocusableToolTip.IToolTipProvider,
Matcher.IConsumer {
    static final String NAME = CoreDialogId.ARCHITECTURAL_VIEW_ARTIFACT_FILTER.getStandardName();
    private static final String IN_PATTERN_MODIFICATION_CONFIRMATION = "You are still in pattern modification on the filter page!\nIf yo want to apply these changes to the currently edited filter,\nit is necessary to click the button next to the pattern input field.\n\nDo you want to discard these changes and finish the wizard?";
    private static final String PATTERN_TYPE = "filter.patternType";
    private final IArchitecturalViewProvider m_provider;
    private final ExplorationViewRepresentation m_representation;
    private final List<PatternType> m_patternTypes;
    private final ArtifactNodeFilter m_originalFilter;
    private final ArtifactNode m_toBeEdited;
    private final ExecutorService m_executorService;
    private ArtifactNodeFilter.PatternKind m_selectedPatternKind;
    private AssignableTargetInfo m_targetInfo;
    private PatternType m_selectedPatternType;
    private ArtifactNodeFilter m_toBeEditedFilter;
    private ArtifactNodeFilter m_currentlyModifyingFilter;
    private ArchitecturalViewFilter m_originalCurrentlyModifyingPattern;
    private ArchitecturalViewFilter m_currentlyModifyingPattern;
    private CancellableWorkerContext m_currentWorkerContext;
    private Matcher m_currentMatcher;
    private PropertyTableViewer<ArchitecturalViewFilter> m_filter;
    private PropertyTableViewer<ArchitecturalViewNode> m_matchingElements;
    private PropertyTableViewer<String> m_multipleAttributeInfo;
    private Composite m_patternModificationComposite;
    private Label m_patternLabel;
    private Text m_pattern;
    private Button m_addModifiedPatternButton;
    private String m_addModifiedPatternButtonDisabledMessage;
    private Button m_cancelPatternModificationButton;
    private Button m_patternTypeButton;
    private Button m_addIncludePatternButton;
    private Button m_addExcludePatternButton;
    private Button m_editPatternButton;
    private Button m_deletedPatternsButton;
    private Color m_matchingBackgroundColor;
    private boolean m_filterInitialized;

    ArtifactFilterPage(Set<Language> usedLanguages, IArchitecturalViewProvider architecturalViewProvider, ExplorationViewRepresentation representation, ArtifactNodeFilter originalFilter) {
        super(NAME, "Filter");
        assert (usedLanguages != null && !usedLanguages.isEmpty()) : "Parameter 'usedLanguages' of method 'ArtifactFilterPage' must not be empty";
        assert (architecturalViewProvider != null) : "Parameter 'architecturalViewProvider' of method 'ArtifactEditFilterPage' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'ArtifactEditFilterPage' must not be null";
        assert (originalFilter != null) : "Parameter 'originalFilter' of method 'ArtifactEditFilterPage' must not be null";
        assert (architecturalViewProvider.isFilterValid(originalFilter) == null) : "'originalFilter' of method 'ArtifactFilterPage' must be valid";
        this.m_provider = architecturalViewProvider;
        this.m_representation = representation;
        this.m_originalFilter = originalFilter;
        this.m_toBeEdited = (ArtifactNode)this.m_originalFilter.getParent(ArtifactNode.class, ParentMode.ONLY_DIRECT_PARENT);
        this.m_toBeEditedFilter = ArtifactNodeFilter.createCopy((ArtifactNodeFilter)this.m_originalFilter, (ArchitecturalViewFilter[])new ArchitecturalViewFilter[0]);
        this.m_patternTypes = this.m_representation.getPatternTypes(usedLanguages);
        assert (this.m_patternTypes != null && !this.m_patternTypes.isEmpty()) : "Parameter 'm_patternTypes' of method 'ArtifactEditFilterPage' must not be empty";
        String initialPatternTypeStandardName = this.getPreferences().get(PATTERN_TYPE, this.m_patternTypes.get(0).getStandardName());
        for (PatternType nextPatternType : this.m_patternTypes) {
            if (!nextPatternType.getStandardName().equals(initialPatternTypeStandardName)) continue;
            this.m_selectedPatternType = nextPatternType;
            break;
        }
        if (this.m_selectedPatternType == null) {
            this.m_selectedPatternType = this.m_patternTypes.get(0);
        }
        this.m_executorService = Executors.newCachedThreadPool();
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.ARCHITECTURAL_VIEW_ARTIFACT_FILTER;
    }

    public void dispose() {
        this.cancelMatch(false);
        this.m_executorService.shutdownNow();
        IEclipsePreferences preferences = this.getPreferences();
        preferences.put(PATTERN_TYPE, this.m_selectedPatternType.getStandardName());
        PreferencesUtility.save((IEclipsePreferences)preferences);
        super.dispose();
    }

    void setAssignableTargetInfo(AssignableTargetInfo targetInfo) {
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'setAssignableTargetInfo' must not be null";
        this.m_targetInfo = targetInfo;
    }

    private void selectPatternType(PatternType patternType, boolean force) {
        assert (patternType != null) : "Parameter 'patternType' of method 'selectPatternType' must not be null";
        if (force || this.m_selectedPatternType != patternType) {
            this.cancelMatch(true);
            this.disablePatternModification();
            this.m_selectedPatternType = patternType;
            this.m_patternLabel.setText(this.m_selectedPatternType.getPresentationName() + ":");
            this.m_addIncludePatternButton.setToolTipText("Add include pattern " + this.m_selectedPatternType.getPresentationName());
            this.m_addExcludePatternButton.setToolTipText("Add exclude pattern " + this.m_selectedPatternType.getPresentationName());
            this.m_patternModificationComposite.layout(true);
        }
    }

    private void selectPatternType(SelectionEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectPatternType' must not be null";
        Shell shell = this.m_patternTypeButton.getShell();
        Display display = shell.getDisplay();
        Menu menu = new Menu((Decorations)shell, 8);
        for (final PatternType nextPatternType : this.m_patternTypes) {
            MenuItem nextItem = new MenuItem(menu, 8);
            nextItem.setText(nextPatternType.getPresentationName());
            if (nextPatternType == this.m_selectedPatternType) {
                nextItem.setImage(UiResourceManager.getInstance().getImage("CheckBoxChecked"));
            } else {
                nextItem.setImage(UiResourceManager.getInstance().getImage("CheckBoxUnchecked"));
            }
            nextItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ArtifactFilterPage.this.selectPatternType(nextPatternType, false);
                }
            });
        }
        Point location = display.map((Control)this.m_patternTypeButton, null, event.x, event.y);
        Rectangle buttonBounds = this.m_patternTypeButton.getBounds();
        location.x = location.x + buttonBounds.width - 5;
        menu.setLocation(location);
        menu.setVisible(true);
        while (!menu.isDisposed() && menu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        menu.dispose();
    }

    private void disablePatternModification() {
        this.m_pattern.removeModifyListener((ModifyListener)this);
        this.m_pattern.setEnabled(false);
        this.m_pattern.setText("");
        this.m_currentlyModifyingFilter = null;
        this.m_currentlyModifyingPattern = null;
        this.m_originalCurrentlyModifyingPattern = null;
        this.m_selectedPatternKind = null;
        this.m_patternTypeButton.setImage(UiResourceManager.getInstance().getImage("PatternType"));
        this.m_addModifiedPatternButton.setImage(UiResourceManager.getInstance().getImage("CheckDisabled"));
        this.m_addModifiedPatternButton.setToolTipText("Add a new pattern or choose to edit an existing pattern to modify the filter");
        this.m_addModifiedPatternButtonDisabledMessage = "No pattern";
        this.m_cancelPatternModificationButton.setEnabled(false);
        this.m_filter.setFocus();
    }

    private void enablePatternModification(String toBeEdited) {
        assert (toBeEdited != null) : "Parameter 'toBeEdited' of method 'enablePatternModification' must not be null";
        this.m_addModifiedPatternButton.setImage(UiResourceManager.getInstance().getImage("Check"));
        this.m_addModifiedPatternButtonDisabledMessage = "Pattern has not been modified";
        this.m_addModifiedPatternButton.setToolTipText(this.m_addModifiedPatternButtonDisabledMessage);
        this.m_cancelPatternModificationButton.setEnabled(true);
        this.m_pattern.setText(toBeEdited);
        this.m_pattern.setSelection(toBeEdited.length());
        this.m_pattern.setEnabled(true);
        this.m_pattern.setFocus();
        this.m_pattern.addModifyListener((ModifyListener)this);
    }

    private void cancelMatch(boolean forceMatchingReset) {
        boolean resetMatching = forceMatchingReset;
        if (this.m_currentWorkerContext != null) {
            this.m_currentWorkerContext.cancel();
            this.m_currentMatcher = null;
            this.m_currentWorkerContext = null;
            resetMatching = true;
        }
        if (resetMatching && !this.m_matchingElements.isDisposed()) {
            this.m_matchingElements.setAdditionalFirstColumnInfo(null);
            this.m_matchingElements.showData(null);
            this.m_matchingElements.getTable().setBackground(this.m_matchingBackgroundColor);
            this.m_multipleAttributeInfo.showData(null);
        }
    }

    @Override
    public void finished(final Matcher matcher, final List<AssignableToArtifactNode> nodes, final Set<String> multipleAttributeInfoCollector) {
        assert (matcher != null) : "Parameter 'matcher' of method 'finished' must not be null";
        UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

            @Override
            public void run() {
                if (ArtifactFilterPage.this.m_currentMatcher == matcher && !ArtifactFilterPage.this.m_matchingElements.isDisposed()) {
                    ArtifactFilterPage.this.m_matchingElements.setAdditionalFirstColumnInfo(null);
                    ArtifactFilterPage.this.m_matchingElements.showData((Collection)nodes);
                    ArtifactFilterPage.this.m_multipleAttributeInfo.showData((Collection)multipleAttributeInfoCollector);
                    ArtifactFilterPage.this.m_matchingElements.getTable().setBackground(ArtifactFilterPage.this.m_matchingBackgroundColor);
                    ArtifactFilterPage.this.m_filter.refresh();
                }
            }
        });
    }

    private void match(ArtifactNodeFilter filter) {
        Matcher matcher;
        assert (filter != null) : "Parameter 'filter' of method 'match' must not be null";
        assert (this.m_currentWorkerContext == null) : "'m_currentWorkerContext' of method 'match' must be null";
        this.m_currentWorkerContext = new CancellableWorkerContext();
        this.m_matchingElements.setAdditionalFirstColumnInfo("Processing...");
        this.m_matchingElements.showData(null);
        this.m_multipleAttributeInfo.showData(null);
        this.m_matchingElements.getTable().setBackground(UiResourceManager.getInstance().getViewHasFilteredElementsColor());
        this.m_currentMatcher = matcher = new Matcher(this.m_provider, this.m_targetInfo, filter, this.m_toBeEdited, (IWorkerContext)this.m_currentWorkerContext, this);
        this.m_executorService.execute(matcher);
    }

    private void editPattern(ArchitecturalViewFilter pattern) {
        assert (pattern != null) : "Parameter 'pattern' of method 'editPattern' must not be null";
        this.disablePatternModification();
        IAssignableAttributeRetriever restriever = pattern.getRetriever();
        PatternType select = null;
        for (PatternType nextPatternType : this.m_patternTypes) {
            if (nextPatternType.getAttributeRetriever() != restriever) continue;
            select = nextPatternType;
            break;
        }
        this.m_originalCurrentlyModifyingPattern = pattern;
        this.m_currentlyModifyingFilter = ArtifactNodeFilter.createCopy((ArtifactNodeFilter)this.m_toBeEditedFilter, (ArchitecturalViewFilter[])new ArchitecturalViewFilter[]{pattern});
        assert (select != null) : "'select' of method 'editPattern' must not be null";
        this.selectPatternType(select, false);
        this.m_selectedPatternKind = pattern instanceof PatternFilterInclude ? ArtifactNodeFilter.PatternKind.INCLUDE : ArtifactNodeFilter.PatternKind.EXCLUDE;
        this.enablePatternModification(pattern.getPattern());
        this.updateAddEditedPatternButtonState(null, false);
    }

    private void deletePatterns(List<ArchitecturalViewFilter> patterns) {
        assert (patterns != null && !patterns.isEmpty()) : "Parameter 'patterns' of method 'deletePatterns' must not be empty";
        this.disablePatternModification();
        patterns.forEach(p -> this.m_toBeEditedFilter.removeChild((NamedElement)p));
        List remainingPatterns = this.m_toBeEditedFilter.getChildren(ArchitecturalViewFilter.class);
        this.m_filter.showData((Collection)remainingPatterns);
        if (remainingPatterns.isEmpty()) {
            this.m_matchingElements.showData(Collections.emptyList());
        } else {
            this.cancelMatch(true);
            this.match(this.m_toBeEditedFilter);
        }
        this.updatePageCompletionState();
    }

    private GridLayout createGridLayout(int columns, int verticalSpacing, int marginBottom) {
        GridLayout gridLayout = new GridLayout(columns, false);
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = marginBottom;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = verticalSpacing;
        gridLayout.horizontalSpacing = 0;
        return gridLayout;
    }

    protected int getNumberOfColumns() {
        return 1;
    }

    private void updateSelectionBasedActions() {
        List selected = this.m_filter.getSelected();
        this.m_editPatternButton.setEnabled(selected.size() == 1);
        this.m_deletedPatternsButton.setEnabled(!selected.isEmpty());
    }

    protected void createContent(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createContent' must not be null";
        SashForm sashForm = new SashForm(parent, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite patternsAndButtons = new Composite((Composite)sashForm, 0);
        patternsAndButtons.setLayout((Layout)this.createGridLayout(4, 0, 0));
        this.m_patternTypeButton = new Button(patternsAndButtons, 8);
        this.m_patternTypeButton.setImage(UiResourceManager.getInstance().getImage("PatternType"));
        this.m_patternTypeButton.setToolTipText("Select pattern type");
        this.m_patternTypeButton.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        this.m_patternModificationComposite = new Composite(patternsAndButtons, 0);
        this.m_patternModificationComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_patternModificationComposite.setLayout((Layout)this.createGridLayout(2, 4, 0));
        this.m_patternLabel = new Label(this.m_patternModificationComposite, 0);
        this.m_patternLabel.setFont(UiResourceManager.getInstance().getFont(1));
        this.m_patternLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        new FocusableToolTip((Control)this.m_patternLabel, this);
        this.m_pattern = new Text(this.m_patternModificationComposite, 2048);
        this.m_pattern.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_addModifiedPatternButton = new Button(patternsAndButtons, 8);
        this.m_addModifiedPatternButton.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        this.m_cancelPatternModificationButton = new Button(patternsAndButtons, 8);
        this.m_cancelPatternModificationButton.setImage(UiResourceManager.getInstance().getImage("CancelEdit"));
        this.m_cancelPatternModificationButton.setToolTipText("Cancel pattern modification");
        this.m_cancelPatternModificationButton.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        this.m_filter = new PropertyTableViewer(patternsAndButtons, (BeanPropertyReader.BeanAdapter)new PatternFilterWithMatchingCounterBeanAdapter(), null, true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_filter.addColumn("Filter", "originalPattern", null, "image", 90, PropertyTableViewer.ColumnType.TEXT);
        this.m_filter.addColumn("Matching", "matchingCount", null, null, 10, PropertyTableViewer.ColumnType.NUMBER);
        this.m_filter.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Composite buttons = new Composite(patternsAndButtons, 0);
        buttons.setLayoutData((Object)new GridData(0, 0, false, false));
        buttons.setLayout((Layout)this.createGridLayout(1, 0, 0));
        this.m_addIncludePatternButton = new Button(buttons, 8);
        this.m_addIncludePatternButton.setImage(UiResourceManager.getInstance().getImage("Include"));
        this.m_addIncludePatternButton.setEnabled(true);
        this.m_addExcludePatternButton = new Button(buttons, 8);
        this.m_addExcludePatternButton.setImage(UiResourceManager.getInstance().getImage("Exclude"));
        this.m_addExcludePatternButton.setEnabled(true);
        this.m_deletedPatternsButton = new Button(buttons, 8);
        this.m_deletedPatternsButton.setImage(UiResourceManager.getInstance().getImage("Delete"));
        this.m_deletedPatternsButton.setToolTipText("Delete selected pattern(s)");
        this.m_deletedPatternsButton.setEnabled(false);
        this.m_editPatternButton = new Button(buttons, 8);
        this.m_editPatternButton.setImage(UiResourceManager.getInstance().getImage("Edit"));
        this.m_editPatternButton.setToolTipText("Edit selected pattern");
        this.m_editPatternButton.setEnabled(false);
        this.m_matchingElements = new PropertyTableViewer((Composite)sashForm, (BeanPropertyReader.BeanAdapter)new NodeBeanAdapter(), "name", true, PropertyTableViewer.SelectionType.SINGLE_FULL_LINE);
        this.m_matchingElements.addColumn("Matching", "presentationName", "name", "image", 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_matchingBackgroundColor = this.m_matchingElements.getTable().getBackground();
        this.m_multipleAttributeInfo = new PropertyTableViewer((Composite)sashForm, (BeanPropertyReader.BeanAdapter)new StringBeanAdapter(), PropertyTableViewer.SelectionType.SINGLE_FULL_LINE);
        this.m_multipleAttributeInfo.addColumn("Additional matching info", "info", null, null, 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_matchingBackgroundColor = this.m_matchingElements.getTable().getBackground();
        sashForm.setWeights(new int[]{35, 45, 20});
        SwtUtility.applySashSeparatorStyle((SashForm)sashForm);
        this.selectPatternType(this.m_selectedPatternType, true);
        this.disablePatternModification();
        this.m_patternTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'widgetSelected' must not be null");
                }
                ArtifactFilterPage.this.selectPatternType(event);
            }
        });
        this.m_addModifiedPatternButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ArtifactFilterPage.this.m_addModifiedPatternButtonDisabledMessage == null) {
                    if (!$assertionsDisabled && ArtifactFilterPage.this.m_currentlyModifyingPattern == null) {
                        throw new AssertionError((Object)"'m_currentlyModifyingPattern' of method 'widgetSelected' must not be null");
                    }
                    ArtifactFilterPage.this.m_toBeEditedFilter = ArtifactFilterPage.this.m_currentlyModifyingFilter;
                    ArtifactFilterPage.this.disablePatternModification();
                    ArtifactFilterPage.this.m_filter.showData((Collection)ArtifactFilterPage.this.m_toBeEditedFilter.getChildren(ArchitecturalViewFilter.class));
                    ArtifactFilterPage.this.updatePageCompletionState();
                }
            }
        });
        this.m_cancelPatternModificationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArtifactFilterPage.this.cancelMatch(true);
                ArtifactFilterPage.this.disablePatternModification();
            }
        });
        this.m_addIncludePatternButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArtifactFilterPage.this.cancelMatch(false);
                ArtifactFilterPage.this.disablePatternModification();
                ArtifactFilterPage.this.m_selectedPatternKind = ArtifactNodeFilter.PatternKind.INCLUDE;
                ArtifactFilterPage.this.m_patternTypeButton.setImage(UiResourceManager.getInstance().getImage("Include"));
                ArtifactFilterPage.this.m_currentlyModifyingFilter = ArtifactNodeFilter.createCopy((ArtifactNodeFilter)ArtifactFilterPage.this.m_toBeEditedFilter, (ArchitecturalViewFilter[])new ArchitecturalViewFilter[0]);
                ArtifactFilterPage.this.enablePatternModification("");
            }
        });
        this.m_addExcludePatternButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArtifactFilterPage.this.cancelMatch(false);
                ArtifactFilterPage.this.disablePatternModification();
                ArtifactFilterPage.this.m_selectedPatternKind = ArtifactNodeFilter.PatternKind.EXCLUDE;
                ArtifactFilterPage.this.m_patternTypeButton.setImage(UiResourceManager.getInstance().getImage("Exclude"));
                ArtifactFilterPage.this.m_currentlyModifyingFilter = ArtifactNodeFilter.createCopy((ArtifactNodeFilter)ArtifactFilterPage.this.m_toBeEditedFilter, (ArchitecturalViewFilter[])new ArchitecturalViewFilter[0]);
                ArtifactFilterPage.this.enablePatternModification("");
            }
        });
        this.m_editPatternButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArtifactFilterPage.this.cancelMatch(false);
                List selected = ArtifactFilterPage.this.m_filter.getSelected();
                if (!$assertionsDisabled && selected.size() != 1) {
                    throw new AssertionError((Object)"Exactly 1 selected pattern expected");
                }
                ArtifactFilterPage.this.editPattern((ArchitecturalViewFilter)selected.get(0));
            }
        });
        this.m_deletedPatternsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List selected = ArtifactFilterPage.this.m_filter.getSelected();
                if (!$assertionsDisabled && (selected == null || selected.isEmpty())) {
                    throw new AssertionError((Object)"'selected' of method 'widgetSelected' must not be empty");
                }
                ArtifactFilterPage.this.deletePatterns(selected);
            }
        });
        this.m_filter.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArtifactFilterPage.this.updateSelectionBasedActions();
            }
        });
    }

    public void setVisible(boolean visible) {
        assert (this.m_targetInfo != null) : "'m_targetInfo' of method 'setVisible' must not be null";
        if (visible) {
            if (!this.m_filterInitialized) {
                List patterns = this.m_toBeEditedFilter.getChildren(ArchitecturalViewFilter.class);
                this.m_filter.showData((Collection)patterns);
                if (!patterns.isEmpty()) {
                    this.match(this.m_toBeEditedFilter);
                }
                this.m_filterInitialized = true;
            } else if (this.m_currentlyModifyingFilter != null) {
                this.cancelMatch(false);
                this.match(this.m_currentlyModifyingFilter);
            }
        }
        super.setVisible(visible);
    }

    private void updatePageCompletionState() {
        String invalid = this.m_provider.isFilterValid(this.m_toBeEditedFilter);
        if (invalid != null) {
            this.setPageComplete(false);
            this.setMessage(invalid, 3);
        } else {
            this.setPageComplete(true);
            this.setMessage(null);
        }
        this.updateSelectionBasedActions();
    }

    boolean assureCanFinish() {
        return !this.m_cancelPatternModificationButton.isEnabled() || this.m_addModifiedPatternButtonDisabledMessage != null || UserInterfaceAdapter.getInstance().question(IN_PATTERN_MODIFICATION_CONFIRMATION, false) != UserInterfaceAdapter.Feedback.DISAGREED;
    }

    boolean hasBeenEdited() {
        return this.m_provider.isFilterValid(this.m_toBeEditedFilter) == null && !ArtifactNodeFilter.areEqual((ArtifactNodeFilter)this.m_originalFilter, (ArtifactNodeFilter)this.m_toBeEditedFilter);
    }

    ArtifactNodeFilter getEditedFilter() {
        return this.m_toBeEditedFilter;
    }

    void updateAddEditedPatternButtonState(ParsedPatternInfo parsedPatternInfo, boolean isDuplicate) {
        if (this.m_currentlyModifyingPattern == null) {
            this.m_addModifiedPatternButton.setImage(UiResourceManager.getInstance().getImage("Check"));
            this.m_addModifiedPatternButtonDisabledMessage = "No pattern";
            this.m_addModifiedPatternButton.setToolTipText(this.m_addModifiedPatternButtonDisabledMessage);
        } else if (this.m_originalCurrentlyModifyingPattern == null || !this.m_originalCurrentlyModifyingPattern.getName().equals(this.m_currentlyModifyingPattern.getName())) {
            if (parsedPatternInfo == null) {
                parsedPatternInfo = ParsedPatternInfo.parsePattern((String)(this.m_selectedPatternType.getPatternPrefix() + this.m_pattern.getText()), (boolean)false, (boolean)false, (IAssignableAttributeRetrieverProvider)this.m_representation);
            }
            if (parsedPatternInfo.isValid()) {
                if (!isDuplicate) {
                    this.m_addModifiedPatternButton.setImage(UiResourceManager.getInstance().getImage("CheckValid"));
                    this.m_addModifiedPatternButtonDisabledMessage = null;
                    this.m_addModifiedPatternButton.setToolTipText("Add the modified pattern to the pattern list");
                } else {
                    this.m_addModifiedPatternButton.setImage(UiResourceManager.getInstance().getImage("CheckInvalid"));
                    this.m_addModifiedPatternButtonDisabledMessage = "Pattern already defined";
                    this.m_addModifiedPatternButton.setToolTipText(this.m_addModifiedPatternButtonDisabledMessage);
                }
            } else {
                this.m_addModifiedPatternButton.setImage(UiResourceManager.getInstance().getImage("CheckInvalid"));
                this.m_addModifiedPatternButtonDisabledMessage = parsedPatternInfo.getErrorMessage();
                this.m_addModifiedPatternButton.setToolTipText(this.m_addModifiedPatternButtonDisabledMessage);
            }
        } else {
            this.m_addModifiedPatternButton.setImage(UiResourceManager.getInstance().getImage("CheckValid"));
            this.m_addModifiedPatternButtonDisabledMessage = "Pattern not modified";
            this.m_addModifiedPatternButton.setToolTipText(this.m_addModifiedPatternButtonDisabledMessage);
        }
    }

    public final void modifyText(ModifyEvent event) {
        assert (this.m_currentlyModifyingFilter != null) : "'m_currentlyEditedFilter' of method 'modifyText' must not be null";
        this.cancelMatch(false);
        if (this.m_currentlyModifyingPattern != null) {
            this.m_currentlyModifyingPattern.remove();
        }
        boolean isDuplicate = false;
        ParsedPatternInfo parsedPatternInfo = ParsedPatternInfo.parsePattern((String)(this.m_selectedPatternType.getPatternPrefix() + this.m_pattern.getText()), (boolean)false, (boolean)false, (IAssignableAttributeRetrieverProvider)this.m_representation);
        if (parsedPatternInfo.isValid()) {
            if (this.m_toBeEditedFilter.containsPattern(parsedPatternInfo.getOriginalPattern())) {
                isDuplicate = true;
            } else {
                assert (this.m_selectedPatternKind != null) : "'m_selectedPatternKind' of method 'modifyText' must not be null";
                switch (this.m_selectedPatternKind) {
                    case INCLUDE: {
                        this.m_currentlyModifyingPattern = new PatternFilterInclude((NamedElement)this.m_currentlyModifyingFilter, parsedPatternInfo.getRetriever(), parsedPatternInfo.getOriginalPattern(), parsedPatternInfo.getPattern(), parsedPatternInfo.isStrong(), parsedPatternInfo.getParams(), true);
                        break;
                    }
                    case EXCLUDE: {
                        this.m_currentlyModifyingPattern = new PatternFilterExclude((NamedElement)this.m_currentlyModifyingFilter, parsedPatternInfo.getRetriever(), parsedPatternInfo.getOriginalPattern(), parsedPatternInfo.getPattern(), parsedPatternInfo.isStrong(), parsedPatternInfo.getParams(), true);
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled pattern kind: " + String.valueOf(this.m_selectedPatternKind);
                        break;
                    }
                }
                this.m_currentlyModifyingFilter.addChild((NamedElement)this.m_currentlyModifyingPattern);
                this.match(this.m_currentlyModifyingFilter);
            }
        }
        this.updateAddEditedPatternButtonState(parsedPatternInfo, isDuplicate);
    }

    @Override
    public String getToolTipText(Point location) {
        return this.m_selectedPatternType.getDescription(this.m_representation.getStructureMode());
    }
}

