/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.analyzersview;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerState;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultClearedEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultStateChangedEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzersFinishedEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzersStartedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.IAnalyzerProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.analyzersview.AnalyzerViewComparator;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import gnu.trove.map.hash.THashMap;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public final class AnalyzersView
extends WorkbenchView {
    private static final int STATE_COLUMN_WIDTH = 100;
    private static final String PERCENT_SAMPLE = "99 %";
    private final Map<String, Point> m_textToExtent = new THashMap();
    private TableViewer m_analyzerListView;
    private Timer m_timer;

    public IViewId getViewId() {
        return ViewId.ANALYZERS_VIEW;
    }

    protected EnumSet<WorkbenchView.EventCategory> getDisabledEventCategories() {
        return EnumSet.of(WorkbenchView.EventCategory.INSTALLATION);
    }

    public List<Control> getControlsForInteraction() {
        return Collections.emptyList();
    }

    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        this.m_analyzerListView = new TableViewer(viewContentArea, 772);
        this.m_analyzerListView.getTable().setHeaderVisible(true);
        this.m_analyzerListView.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AnalyzersView.this.m_analyzerListView.getTable().deselectAll();
            }
        });
        TableViewerColumn name = new TableViewerColumn(this.m_analyzerListView, 0);
        name.getColumn().setText("Name");
        name.getColumn().setWidth(160);
        name.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                if (!($assertionsDisabled || obj != null && obj instanceof AnalyzerResult)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(obj)));
                }
                return ((AnalyzerResult)obj).getPresentationName(false);
            }

            public Image getImage(Object obj) {
                if (!($assertionsDisabled || obj != null && obj instanceof AnalyzerResult)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getImage': " + String.valueOf(obj)));
                }
                if (((AnalyzerResult)obj).getState() == AnalyzerState.RUNNING) {
                    return UiResourceManager.getInstance().getImage("AnalyzersViewRunning");
                }
                return UiResourceManager.getInstance().getImage((Element)((NamedElement)obj));
            }
        });
        TableViewerColumn level = new TableViewerColumn(this.m_analyzerListView, 0);
        level.getColumn().setText("Level");
        level.getColumn().setWidth(80);
        level.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                if (!($assertionsDisabled || obj != null && obj instanceof AnalyzerResult)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(obj)));
                }
                return ((AnalyzerResult)obj).getId().getExecutionLevel().getPresentationName();
            }

            public Image getImage(Object obj) {
                if (!($assertionsDisabled || obj != null && obj instanceof AnalyzerResult)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getImage': " + String.valueOf(obj)));
                }
                return UiResourceManager.getInstance().getImage("AnalyzerExecutionLevel");
            }
        });
        TableViewerColumn state = new TableViewerColumn(this.m_analyzerListView, 0x1000000);
        state.getColumn().setText("State");
        state.getColumn().setWidth(100);
        state.getColumn().setResizable(false);
        state.setLabelProvider((CellLabelProvider)new OwnerDrawLabelProvider(){

            protected void measure(Event event, Object element) {
            }

            protected void paint(Event event, Object element) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'paint' must not be null");
                }
                if (!($assertionsDisabled || element != null && element instanceof AnalyzerResult)) {
                    throw new AssertionError((Object)("Unexpected class in method 'paint': " + String.valueOf(element)));
                }
                SoftwareSystem softwareSystem = AnalyzersView.this.getSoftwareSystem();
                if (softwareSystem != null) {
                    Object text;
                    Point extent;
                    Rectangle bounds = event.getBounds();
                    AnalyzerResult result = (AnalyzerResult)element;
                    int progress = 0;
                    if (result.getState() == AnalyzerState.RUNNING) {
                        progress = ((IAnalyzerProvider)softwareSystem.getExtension(IAnalyzerProvider.class)).getProgress(result);
                    }
                    Color currentColor = event.gc.getBackground();
                    if (progress > 0) {
                        event.gc.setBackground(UiResourceManager.getInstance().getColor(UiResourceManager.GREEN));
                        event.gc.fillRectangle(bounds.x, bounds.y + 5, progress, bounds.height - 13);
                        extent = AnalyzersView.this.m_textToExtent.get(AnalyzersView.PERCENT_SAMPLE);
                        if (extent == null) {
                            extent = event.gc.stringExtent(AnalyzersView.PERCENT_SAMPLE);
                            AnalyzersView.this.m_textToExtent.put(AnalyzersView.PERCENT_SAMPLE, extent);
                        }
                        text = progress + " %";
                    } else {
                        event.gc.setBackground(UiResourceManager.getInstance().getBackgroundColor());
                        event.gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                        text = result.getState().getPresentationName();
                        extent = AnalyzersView.this.m_textToExtent.get(text);
                        if (extent == null) {
                            extent = event.gc.stringExtent((String)text);
                            AnalyzersView.this.m_textToExtent.put((String)text, extent);
                        }
                    }
                    if (!$assertionsDisabled && extent == null) {
                        throw new AssertionError((Object)"'extent' of method 'paint' must not be null");
                    }
                    if (extent.x < 100) {
                        event.gc.drawText((String)text, bounds.x + (100 - extent.x) / 2, bounds.y, true);
                    } else {
                        event.gc.drawText((String)text, bounds.x + 1, bounds.y, true);
                    }
                    event.gc.setBackground(currentColor);
                }
            }
        });
        final AnalyzerViewComparator comparator = new AnalyzerViewComparator(AnalyzerViewComparator.Column.LEVEL, false);
        this.m_analyzerListView.setComparator((ViewerComparator)comparator);
        name.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                comparator.setColumn(AnalyzerViewComparator.Column.NAME);
                int direction = comparator.getDirection();
                AnalyzersView.this.m_analyzerListView.getTable().setSortDirection(direction);
                AnalyzersView.this.m_analyzerListView.refresh();
            }
        });
        level.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                comparator.setColumn(AnalyzerViewComparator.Column.LEVEL);
                int direction = comparator.getDirection();
                AnalyzersView.this.m_analyzerListView.getTable().setSortDirection(direction);
                AnalyzersView.this.m_analyzerListView.refresh();
            }
        });
        this.m_analyzerListView.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzersStartedEvent>(AnalyzersStartedEvent.class, (Object)this){

            public void handleEvent(AnalyzersStartedEvent event) {
                AnalyzersView.this.checkCalculating(true);
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzersFinishedEvent>(AnalyzersFinishedEvent.class, (Object)this){

            public void handleEvent(AnalyzersFinishedEvent event) {
                AnalyzersView.this.checkCalculating(false);
                AnalyzersView.this.checkForErrors(AnalyzersView.this.getAllResults());
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultStateChangedEvent>(AnalyzerResultStateChangedEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultStateChangedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (AnalyzersView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    AnalyzersView.this.getContentArea().setRedraw(false);
                    AnalyzersView.this.m_analyzerListView.refresh((Object)event.getResult());
                    AnalyzersView.this.getContentArea().setRedraw(true);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultClearedEvent>(AnalyzerResultClearedEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultClearedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (AnalyzersView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    SoftwareSystem softwareSystem = AnalyzersView.this.getSoftwareSystem();
                    AnalyzersView.this.showData(softwareSystem != null ? AnalyzersView.this.getAllResults() : null);
                }
            }
        });
    }

    private List<AnalyzerResult> getAllResults() {
        return ((Files)this.getSoftwareSystem().getUniqueExistingChild(Files.class)).getAnalyzers().getCurrentAnalyzerResults();
    }

    private void checkForErrors(List<AnalyzerResult> results) {
        OperationResult result = new OperationResult("Analyzer Execution");
        for (AnalyzerResult analyzerResult : results) {
            if (analyzerResult.getState() != AnalyzerState.ERROR) continue;
            result.addError((OperationResult.IMessageCause)MessageCause.ERROR, analyzerResult.getId().getPresentationName() + ": " + analyzerResult.getErrorMessage(), new Object[0]);
        }
        if (result.isFailure()) {
            UserInterfaceAdapter.getInstance().process(result);
        }
    }

    protected void destroyViewContent() {
        if (this.m_timer != null) {
            this.m_timer.cancel();
            this.m_timer = null;
        }
        EventManager.getInstance().detach(AnalyzersStartedEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzersFinishedEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzerResultStateChangedEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzerResultClearedEvent.class, (Object)this);
        super.destroyViewContent();
    }

    public List<Element> getSelectedElements() {
        return Collections.emptyList();
    }

    private void showData(List<AnalyzerResult> input) {
        this.m_analyzerListView.getControl().setRedraw(false);
        this.m_analyzerListView.setInput(input);
        if (input != null && !input.isEmpty()) {
            this.m_analyzerListView.getTable().getColumn(0).pack();
        }
        this.m_analyzerListView.getControl().setRedraw(true);
    }

    private void checkCalculating(boolean calculating) {
        if (!calculating) {
            if (this.m_timer != null) {
                this.m_timer.cancel();
                this.m_timer = null;
            }
            this.getPart().setIconURI("platform:/plugin/com.hello2morrow.sonargraph.ui.swt/images/AnalyzersView.gif");
        } else if (this.m_timer == null) {
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                        @Override
                        public void run() {
                            (this).AnalyzersView.this.m_analyzerListView.refresh();
                        }
                    });
                }
            };
            this.m_timer = new Timer(false);
            this.m_timer.scheduleAtFixedRate(timerTask, 50L, 250L);
            this.getPart().setIconURI("platform:/plugin/com.hello2morrow.sonargraph.ui.swt/images/AnalyzersViewRunning.gif");
        }
    }

    protected void softwareSystemShow(WorkbenchView.ShowMode mode) {
        this.showData(((Files)this.getSoftwareSystem().getUniqueExistingChild(Files.class)).getAnalyzers().getCurrentAnalyzerResults());
        this.checkCalculating(WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.CALCULATING}));
        super.softwareSystemShow(mode);
    }

    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        assert (modification != null) : "Parameter 'modification' of method 'softwareSystemModified' must not be null";
        if (modification.contains(Modification.AVAILABLE_LANGUAGES_MODIFIED) || modification.contains(Modification.AVAILABLE_ANALYZER_PLUGINS_MODIFIED) || modification.contains(Modification.VIRTUAL_MODEL_CHANGED)) {
            this.showData(((Files)this.getSoftwareSystem().getUniqueExistingChild(Files.class)).getAnalyzers().getCurrentAnalyzerResults());
        }
        super.softwareSystemModified(modification, restoredFromHistory);
    }

    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.showData(null);
    }

    static enum MessageCause implements OperationResult.IMessageCause
    {
        ERROR;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

