/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizards;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.system.IIssueProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.wizard.StandaloneWizardAdapter;
import com.hello2morrow.sonargraph.ui.standalone.wizards.CycleIgnoreWizard;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import java.util.List;

public final class CycleIgnoreWizardAdapter
extends StandaloneWizardAdapter {
    public String getName() {
        return "New Pattern Based Cycle Ignore Filter";
    }

    public SonargraphWizardAdapter.Category getCategory() {
        return SonargraphWizardAdapter.Category.OTHER;
    }

    public String getImageResource() {
        return "IgnoreView";
    }

    public boolean isAvailable() {
        return CommandHandlerWithCorrespondingCommand.isAvailable((ICommandId)CoreCommandId.CREATE_OR_EDIT_PATTERN_BASED_CYCLE_IGNORE_FILTER);
    }

    public boolean isEnabled(ISoftwareSystemProvider provider, List<Element> selected) {
        assert (provider != null) : "Parameter 'provider' of method 'isEnabled' must not be null";
        return this.isAvailable() && provider.hasSoftwareSystem() && ((IIssueProvider)provider.getSoftwareSystem().getExtension(IIssueProvider.class)).isCreatePatternBasedCycleIgnoreFilterPossible();
    }

    public boolean showInContextMenu(ISoftwareSystemProvider provider, IWorkbenchView workbenchView, List<Element> selected) {
        assert (provider != null) : "Parameter 'provider' of method 'showInContextMenu' must not be null";
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'showInContextMenu' must not be null";
        assert (selected != null) : "Parameter 'selected' of method 'showInContextMenu' must not be null";
        if (selected.isEmpty() && workbenchView.getViewId() == ViewId.FILES_VIEW || workbenchView.getViewId() == ViewId.CYCLE_GROUPS_VIEW || workbenchView.getViewId() == ViewId.IGNORE_VIEW) {
            return true;
        }
        if (!selected.isEmpty()) {
            for (Element next : selected) {
                if (next instanceof CycleGroupIssue) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public SonargraphWizard create(ISoftwareSystemProvider provider, List<Element> selected) {
        return new CycleIgnoreWizard(provider, null);
    }
}

