/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.treemap;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.treemap.DeleteTreeMapFilesCommand;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.treemap.ITreeMapProvider;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapFile;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.treemap.TreeMapCommandAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.compositecommand.CompositeCommandAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import java.util.List;

public final class DeleteTreeMapsCommandAdapter
extends TreeMapCommandAdapter {
    public CompositeCommandAdapter.Type getType() {
        return CompositeCommandAdapter.Type.DELETE;
    }

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.DELETE_TREE_MAPS;
    }

    public CompositeCommandAdapter.Applicable applicable(ISoftwareSystemProvider provider, List<Element> elements) {
        List treeMapFiles;
        assert (provider != null) : "Parameter 'provider' of method 'applicable' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'applicable' must not be null";
        if (this.mayBeExecuted(provider, elements) && !(treeMapFiles = CommandHandler.getMultipleSelectionIfAllAreAssignable(TreeMapFile.class, elements)).isEmpty() && ((ITreeMapProvider)provider.getSoftwareSystem().getExtension(ITreeMapProvider.class)).isDeleteTreeMapsPossible(treeMapFiles)) {
            String presentationKind = ((TreeMapFile)treeMapFiles.get(0)).getPresentationKind();
            if (treeMapFiles.size() == 1) {
                return new CompositeCommandAdapter.Applicable(presentationKind + " [" + ((TreeMapFile)treeMapFiles.get(0)).getIdentifyingPath() + "]", presentationKind);
            }
            return new CompositeCommandAdapter.Applicable(treeMapFiles.size() + " " + presentationKind + "s");
        }
        return null;
    }

    public void apply(ISoftwareSystemProvider provider, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'apply' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'apply' must not be null";
        assert (provider.hasSoftwareSystem()) : "No system available";
        final List treeMapFiles = CommandHandler.getMultipleSelectionIfAllAreAssignable(TreeMapFile.class, elements);
        assert (treeMapFiles != null && !treeMapFiles.isEmpty()) : "'files' of method 'apply' must not be empty";
        DeleteTreeMapFilesCommand.IDeleteTreeMapFilesInteraction deleteInteraction = new DeleteTreeMapFilesCommand.IDeleteTreeMapFilesInteraction(){

            public boolean collect(DeleteTreeMapFilesCommand.DeleteTreeMapFilesData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setFiles(treeMapFiles);
                return true;
            }

            public boolean confirmDeletion(String info) {
                if (!($assertionsDisabled || info != null && info.length() > 0)) {
                    throw new AssertionError((Object)"Parameter 'info' of method 'confirmDeletion' must not be empty");
                }
                return UserInterfaceAdapter.getInstance().question(info, false) == UserInterfaceAdapter.Feedback.CONFIRMED;
            }

            public void processDeleteTreeMapFilesResult(OperationResult result) {
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)"Parameter 'result' of method 'processDeleteTreeMapFilesResult' must not be null");
                }
                UserInterfaceAdapter.getInstance().process(result);
            }

            public INavigationState getNavigationState() {
                return ViewNavigationManager.getInstance().getCurrentNavigationState();
            }
        };
        UserInterfaceAdapter.getInstance().run((Command)new DeleteTreeMapFilesCommand(provider, deleteInteraction));
    }
}

