/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise;

import com.hello2morrow.sonargraph.core.model.enterprise.ISonargraphEnterpriseInfo;
import com.hello2morrow.sonargraph.core.model.enterprise.ISonargraphEnterpriseProvider;
import com.hello2morrow.sonargraph.core.model.enterprise.SonargraphEnterpriseConnection;
import com.hello2morrow.sonargraph.foundation.utilities.HttpConnectionConsumer;
import com.hello2morrow.sonargraph.foundation.utilities.HttpConnectionResult;
import com.hello2morrow.sonargraph.foundation.utilities.IConnectionConsumer;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractRequestRemoteInfoWizardPage<T extends ISonargraphEnterpriseInfo>
extends StandardWizardPage {
    private static final String REQUEST = "Request";
    private final ISonargraphEnterpriseProvider m_enterpriseExtension;
    private final ProxySettings m_proxySettings;
    private final AtomicBoolean m_hasBeenCancelled = new AtomicBoolean(false);
    private Label m_serverUrl;
    private Button m_request;
    private SonargraphEnterpriseConnection m_connection;
    private Text m_connectionInfo;
    private final IConnectionConsumer m_connectionConsumer;
    private PropertyTableViewer<T> m_propertyTableViewer;

    public AbstractRequestRemoteInfoWizardPage(IDialogId dialogId, ISonargraphEnterpriseProvider enterpriseExtension, ProxySettings proxySettings) {
        super(dialogId.getStandardName(), dialogId.getPresentationName());
        assert (enterpriseExtension != null) : "Parameter 'enterpriseExtension' of method 'SelectSnapshotFromServerWizardPage' must not be null";
        assert (proxySettings != null) : "Parameter 'proxySettings' of method 'SelectSnapshotFromServerWizardPage' must not be null";
        this.m_enterpriseExtension = enterpriseExtension;
        this.m_proxySettings = proxySettings;
        this.m_connectionConsumer = new HttpConnectionConsumer(){

            public boolean hasBeenCanceled() {
                return AbstractRequestRemoteInfoWizardPage.this.m_hasBeenCancelled.get();
            }

            public void working(String message) {
                super.working(message);
                UserInterfaceAdapter.getInstance().displayUiElementAsync(() -> AbstractRequestRemoteInfoWizardPage.this.m_connectionInfo.append(message + "\n"));
            }

            public void consumeResult(HttpConnectionResult result, String uri, String content) {
                super.consumeResult(result, uri, content);
                AbstractRequestRemoteInfoWizardPage.this.m_hasBeenCancelled.set(false);
            }
        };
    }

    public final T getSelection() {
        List selected = this.m_propertyTableViewer.getSelected();
        return (T)(selected.size() > 0 ? (ISonargraphEnterpriseInfo)selected.get(0) : null);
    }

    protected final void setSelection(T elementToSelect) {
        assert (elementToSelect != null) : "Parameter 'elementToSelect' of method 'setSelection' must not be null";
        this.m_propertyTableViewer.select(Arrays.asList(elementToSelect));
    }

    protected final Collection<? extends T> getData() {
        return this.m_propertyTableViewer.getInputData();
    }

    public final boolean setConnection(SonargraphEnterpriseConnection connection) {
        assert (connection != null) : "Parameter 'connection' of method 'setConnection' must not be null";
        boolean changed = !connection.equals((Object)this.m_connection);
        this.m_connection = connection;
        assert (this.m_connection.getServerUrl() != null) : "Missing serverUrl in connection " + String.valueOf(this.m_connection);
        if (this.m_serverUrl != null) {
            this.m_serverUrl.setText(this.m_connection.getServerUrl());
        }
        return changed;
    }

    public boolean isPageComplete() {
        return this.getSelection() != null;
    }

    protected final void createContent(Composite parent) {
        Label urlLabel = new Label(parent, 0);
        urlLabel.setText("Server Url: ");
        urlLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.m_serverUrl = new Label(parent, 0);
        this.m_serverUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_request = new Button(parent, 8);
        this.m_request.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractRequestRemoteInfoWizardPage.this.m_request.getText().equals(AbstractRequestRemoteInfoWizardPage.REQUEST)) {
                    AbstractRequestRemoteInfoWizardPage.this.execute();
                } else {
                    AbstractRequestRemoteInfoWizardPage.this.m_hasBeenCancelled.set(true);
                    AbstractRequestRemoteInfoWizardPage.this.m_request.setText(AbstractRequestRemoteInfoWizardPage.REQUEST);
                }
            }
        });
        this.m_request.setLayoutData((Object)new GridData(131072, 4, false, false));
        this.m_request.setText(REQUEST);
        SashForm sashForm = new SashForm(parent, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.m_connectionInfo = new Text((Composite)sashForm, 2626);
        this.m_connectionInfo.setEditable(false);
        this.m_connectionInfo.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.m_propertyTableViewer = this.createPropertyTable((Composite)sashForm);
        this.m_propertyTableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractRequestRemoteInfoWizardPage.this.setPageComplete(AbstractRequestRemoteInfoWizardPage.this.isPageComplete());
            }
        });
        if (this.m_connection != null) {
            this.m_serverUrl.setText(this.m_connection.getServer());
        }
        sashForm.setWeights(new int[]{30, 70});
        this.createAdditionalWidgets(parent);
    }

    protected void createAdditionalWidgets(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createAdditionalWidgets' must not be null";
    }

    public void execute() {
        this.clear();
        this.m_request.setText("Cancel");
        assert (!this.m_connectionConsumer.hasBeenCanceled()) : "Consumer already cancelled!";
        ISonargraphEnterpriseProvider.IEnterpriseInfoProvider infoProvider = this.m_enterpriseExtension.createInfoProvider(this.m_connection, this.m_proxySettings, this.m_connectionConsumer);
        OperationResultWithOutcome<List<T>> result = this.executeRequest(this.m_enterpriseExtension, infoProvider);
        this.m_hasBeenCancelled.set(false);
        this.m_request.setText(REQUEST);
        if (result == null || result.getOutcome() == null) {
            this.m_propertyTableViewer.showData(null);
        } else {
            this.m_propertyTableViewer.showData((Collection)result.getOutcome());
            if (((List)result.getOutcome()).size() > 0) {
                this.m_propertyTableViewer.getTable().select(0);
                this.setPageComplete(this.isPageComplete());
            }
        }
    }

    protected void clear() {
        this.m_propertyTableViewer.showData(null);
        this.m_connectionInfo.setText("");
    }

    protected abstract OperationResultWithOutcome<List<T>> executeRequest(ISonargraphEnterpriseProvider var1, ISonargraphEnterpriseProvider.IEnterpriseInfoProvider var2);

    protected abstract PropertyTableViewer<T> createPropertyTable(Composite var1);

    protected final int getNumberOfColumns() {
        return 3;
    }

    public void disableEscapeKeyListener() {
        this.m_propertyTableViewer.hideTextFilter();
    }
}

