/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.AbstractOpenCommand;
import com.hello2morrow.sonargraph.core.command.system.OpenSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.LoadLastSnapshotOnOpenHandler;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.OpenHandler;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.OpenInteraction;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.RefreshSoftwareSystemOnOpenHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.DirectoryDialog;

public final class OpenSoftwareSystemHandler
extends OpenHandler {
    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.OPEN_SOFTWARE_SYSTEM;
    }

    @Execute
    public void execute(final IEclipseContext eclipseContext) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'execute' must not be null";
        boolean performRefresh = RefreshSoftwareSystemOnOpenHandler.isActive();
        final boolean loadLastSnapshot = LoadLastSnapshotOnOpenHandler.isActive();
        OpenSoftwareSystemCommand cmd = new OpenSoftwareSystemCommand(WorkbenchRegistry.getInstance().getProvider(), (AbstractOpenCommand.IOpenInteraction)new OpenInteraction(){

            public boolean collectOpenData(AbstractOpenCommand.OpenData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                RunnableWithResult<String> result = new RunnableWithResult<String>(){

                    public void run() {
                        DirectoryDialog directoryDialog = new DirectoryDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell());
                        directoryDialog.setText("Sonargraph - Open Sonargraph System Directory");
                        directoryDialog.setMessage("Choose a Sonargraph system directory (i.e. a directory with suffix '.sonargraph' containing a 'system.sonargraph' file)");
                        directoryDialog.setFilterPath(WorkbenchRegistry.getInstance().getProvider().getLocation("OpenSystem"));
                        this.setResult(directoryDialog.open());
                        WorkbenchRegistry.getInstance().getProvider().setLocation("OpenSystem", directoryDialog.getFilterPath());
                    }
                };
                UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)result);
                String filePath = (String)result.getResult();
                if (filePath != null && !filePath.isEmpty()) {
                    if (loadLastSnapshot) {
                        data.addFlags(new ISoftwareSystemProvider.OpenOption[]{ISoftwareSystemProvider.OpenOption.READ_SNAPSHOT});
                    }
                    data.setLocation(new TFile(filePath));
                    return true;
                }
                return false;
            }
        }, performRefresh);
        UserInterfaceAdapter.getInstance().run((Command)cmd, new CommandResultConsumer(){

            public void consume(CommandException exception) {
                OpenSoftwareSystemHandler.finishExecute(eclipseContext);
                super.consume(exception);
            }
        });
    }
}

