/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.AbstractOpenCommand;
import com.hello2morrow.sonargraph.core.command.system.LoadSnapshotCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.OpenHandler;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.OpenInteraction;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.OpenSnapshotInAttachedModeDialog;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import jakarta.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;

public final class OpenRecentlyUsedSoftwareSystemFromSnapshotHandler
extends OpenHandler {
    public static final String COMMAND_ID = "com.hello2morrow.sonargraph.standalone.command.recentlyUsedOpenSoftwareSystemFromSnapshot";
    public static final String PARAM_ID_FILE_NAME = "com.hello2morrow.sonargraph.standalone.command.recentlyUsedOpenSoftwareSystemFromSnapshot.fileParam";

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.OPEN_SOFTWARE_SYSTEM_FROM_SNAPSHOT;
    }

    static void performOpen(final IEclipseContext eclipseContext, final String filePath) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'performOpen' must not be null";
        assert (filePath != null && filePath.length() > 0) : "Parameter 'filePath' of method 'execute' must not be empty";
        LoadSnapshotCommand cmd = new LoadSnapshotCommand(WorkbenchRegistry.getInstance().getProvider(), (AbstractOpenCommand.IOpenInteraction)new OpenInteraction(){

            public boolean collectOpenData(AbstractOpenCommand.OpenData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collectOpenData' must not be null");
                }
                data.setLocation(new TFile(filePath));
                return true;
            }

            public boolean confirmOpenSnapshotAttached(final AbstractOpenCommand.OpenSnapshotData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'confirmOpenSnapshotAttached' must not be null");
                }
                RunnableWithResult<Boolean> result = new RunnableWithResult<Boolean>(){

                    public void run() {
                        OpenSnapshotInAttachedModeDialog dialog = new OpenSnapshotInAttachedModeDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), data.getDefaultTargetDirectory());
                        if (dialog.open() == 0) {
                            data.setTargetDirectory(dialog.getTargetDirectory());
                            this.setResult(Boolean.TRUE);
                        } else {
                            this.setResult(Boolean.FALSE);
                        }
                    }
                };
                UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)result);
                return (Boolean)result.getResult();
            }

            public boolean confirmFileReplaceInOpenSnapshotAttached(String question) {
                if (!($assertionsDisabled || question != null && question.length() > 0)) {
                    throw new AssertionError((Object)"Parameter 'question' of method 'confirmTargetSystemDirectoryReplaceInOpenSnapshotAttached' must not be empty");
                }
                return UserInterfaceAdapter.getInstance().question(question, false) == UserInterfaceAdapter.Feedback.CONFIRMED;
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)cmd, new CommandResultConsumer(){

            public void consume(CommandException exception) {
                OpenRecentlyUsedSoftwareSystemFromSnapshotHandler.finishExecute(eclipseContext);
                super.consume(exception);
            }
        });
    }

    @Execute
    public void execute(IEclipseContext eclipseContext, @Named(value="com.hello2morrow.sonargraph.standalone.command.recentlyUsedOpenSoftwareSystemFromSnapshot.fileParam") String filePath) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'execute' must not be null";
        assert (filePath != null && filePath.length() > 0) : "Parameter 'filePath' of method 'execute' must not be empty";
        OpenRecentlyUsedSoftwareSystemFromSnapshotHandler.performOpen(eclipseContext, filePath);
    }
}

