/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.ModifiableFileConflictStateColumnLabelProvider;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class AbstractSaveDialog
extends StandardDialog {
    private final List<IModifiableFile> m_toBeSaved;
    private final List<Pair<IModifiableFile, Files.ConflictState>> m_allNeedingSave;
    private final boolean m_enableToBeSavedSelection;
    private final boolean m_hasCancelButton;

    public AbstractSaveDialog(Shell parentShell, String title, List<Pair<IModifiableFile, Files.ConflictState>> allNeedingSave, List<Pair<IModifiableFile, Files.ConflictState>> toBeSaved, boolean enableToBeSavedSelection, boolean hasCancelButton) {
        super(parentShell, title);
        assert (allNeedingSave != null && !allNeedingSave.isEmpty()) : "Parameter 'allNeedingSave' of method 'SaveDialog' must not be empty";
        assert (toBeSaved != null && !toBeSaved.isEmpty()) : "Parameter 'toBeSaved' of method 'SaveDialog' must not be empty";
        this.m_toBeSaved = new ArrayList<IModifiableFile>();
        if (this.preselectAll()) {
            for (Pair<IModifiableFile, Files.ConflictState> nextToBeSaved : toBeSaved) {
                assert (allNeedingSave.contains(nextToBeSaved)) : "'nextToBeSaved' not found in 'allToBeSaved'";
                this.m_toBeSaved.add((IModifiableFile)nextToBeSaved.getFirst());
            }
        }
        this.m_allNeedingSave = new ArrayList<Pair<IModifiableFile, Files.ConflictState>>(allNeedingSave);
        this.m_enableToBeSavedSelection = enableToBeSavedSelection;
        this.m_hasCancelButton = hasCancelButton;
    }

    public AbstractSaveDialog(Shell parentShell, String title, List<Pair<IModifiableFile, Files.ConflictState>> allNeedingSave, List<Pair<IModifiableFile, Files.ConflictState>> toBeSaved, boolean hasCancelButton) {
        this(parentShell, title, allNeedingSave, toBeSaved, true, hasCancelButton);
    }

    protected Point getMinimumSize() {
        Point minSize = super.getMinimumSize();
        minSize.y = 250;
        return minSize;
    }

    public boolean hasValidData() {
        return true;
    }

    protected abstract String getSecondColumnLabel();

    protected void fillDialogArea(Composite composite) {
        super.fillDialogArea(composite);
        final TableViewer tableViewer = new TableViewer(composite, 68354);
        tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        tableViewer.getTable().setHeaderVisible(true);
        TableViewerColumn fileColumn = new TableViewerColumn(tableViewer, 0);
        fileColumn.getColumn().setResizable(true);
        fileColumn.getColumn().setText("Modified file");
        fileColumn.setLabelProvider((CellLabelProvider)new ModifiableFileConflictStateColumnLabelProvider());
        TableViewerColumn checkColumn = new TableViewerColumn(tableViewer, 0x1000000);
        checkColumn.getColumn().setResizable(false);
        checkColumn.getColumn().setText(this.getSecondColumnLabel());
        checkColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                if (!$assertionsDisabled && cell == null) {
                    throw new AssertionError((Object)"Parameter 'cell' of method 'update' must not be null");
                }
                if (!($assertionsDisabled || cell.getElement() != null && cell.getElement() instanceof Pair)) {
                    throw new AssertionError((Object)("Unexpected class in method 'update': " + String.valueOf(cell.getElement())));
                }
                Pair pair = (Pair)cell.getElement();
                if (!$assertionsDisabled && !(pair.getFirst() instanceof IModifiableFile)) {
                    throw new AssertionError((Object)("Unexpected class: " + pair.getFirst().getClass().getName()));
                }
                IModifiableFile modifiableFile = (IModifiableFile)pair.getFirst();
                if (AbstractSaveDialog.this.m_toBeSaved.contains(modifiableFile)) {
                    cell.setImage(UiResourceManager.getInstance().getImage("CheckBoxChecked"));
                } else {
                    cell.setImage(UiResourceManager.getInstance().getImage("CheckBoxUnchecked"));
                }
            }

            public String getToolTipText(Object element) {
                return "Check to save to file system";
            }
        });
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setInput(this.m_allNeedingSave);
        checkColumn.getColumn().pack();
        fileColumn.getColumn().pack();
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false, 3, 1));
        buttonComposite.setLayout((Layout)new FillLayout());
        Button selectAll = new Button(buttonComposite, 8);
        selectAll.setText("Select All");
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractSaveDialog.this.m_toBeSaved.clear();
                AbstractSaveDialog.this.m_toBeSaved.addAll(AbstractSaveDialog.this.m_allNeedingSave.stream().map(p -> (IModifiableFile)p.getFirst()).collect(Collectors.toList()));
                AbstractSaveDialog.this.updateTableViewer(tableViewer);
            }
        });
        Button deselectAll = new Button(buttonComposite, 8);
        deselectAll.setText("Deselect All");
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractSaveDialog.this.m_toBeSaved.clear();
                AbstractSaveDialog.this.updateTableViewer(tableViewer);
            }
        });
        selectAll.setEnabled(this.m_enableToBeSavedSelection);
        deselectAll.setEnabled(this.m_enableToBeSavedSelection);
        if (this.m_enableToBeSavedSelection) {
            tableViewer.getTable().addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent event) {
                    int key = event.keyCode;
                    if (key == 32) {
                        AbstractSaveDialog.this.updateToBeSaved(tableViewer, (EventObject)event);
                    }
                }
            });
            tableViewer.getTable().addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                }

                public void mouseDown(MouseEvent event) {
                    AbstractSaveDialog.this.updateToBeSaved(tableViewer, (EventObject)event);
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
        }
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer, (int)2);
        SwtUtility.packAllColumnsAndRightAlignLast((TableViewer)tableViewer);
    }

    protected boolean preselectAll() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.m_hasCancelButton) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    private void updateToBeSaved(TableViewer tableViewer, EventObject event) {
        assert (tableViewer != null) : "Parameter 'tableViewer' of method 'updateToBeSaved' must not be null";
        assert (event != null) : "Parameter 'event' of method 'updateToBeSaved' must not be null";
        Object source = event.getSource();
        assert (source != null && source instanceof Table) : "Unexpected class in method 'mouseDown': " + String.valueOf(source);
        Table table = (Table)source;
        StructuredSelection selection = new StructuredSelection((Object[])table.getSelection());
        if (!selection.isEmpty()) {
            Object firstElement = selection.getFirstElement();
            assert (firstElement instanceof TableItem) : "Unexpected class in method 'selectionChanged': " + String.valueOf(firstElement.getClass());
            TableItem item = (TableItem)firstElement;
            assert (item.getData() != null && item.getData() instanceof Pair) : "Unexpected class in method 'mouseDown': " + String.valueOf(item.getData());
            Pair pair = (Pair)item.getData();
            assert (pair.getFirst() instanceof IModifiableFile) : "Unexpected class: " + pair.getFirst().getClass().getName();
            IModifiableFile modifiableFile = (IModifiableFile)pair.getFirst();
            if (this.m_toBeSaved.contains(modifiableFile)) {
                this.m_toBeSaved.remove(modifiableFile);
            } else {
                this.m_toBeSaved.add(modifiableFile);
            }
        }
        this.updateTableViewer(tableViewer);
    }

    private void updateTableViewer(TableViewer tableViewer) {
        tableViewer.getTable().setRedraw(false);
        tableViewer.refresh();
        this.applyData();
        tableViewer.getTable().setRedraw(true);
    }

    protected void applyData() {
        this.getButton(0).setEnabled(this.hasValidData());
        super.applyData();
    }

    public List<IModifiableFile> getToBeSaved() {
        return Collections.unmodifiableList(this.m_toBeSaved);
    }
}

