/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.settings;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.SimpleSoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.command.system.UpdateThresholdsCommand;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.MetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.ThresholdAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.IThresholdProvider;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.settings.AnalyzerPropertyPage;
import com.hello2morrow.sonargraph.ui.standalone.settings.ThresholdBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.settings.ThresholdDialog;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class ThresholdAnalyzerPropertyPage
extends AnalyzerPropertyPage<ThresholdAnalyzerConfiguration> {
    private PropertyTableViewer<IMetricThreshold> m_thresholdList;
    private Button m_addButton;
    private Button m_editButton;
    private Button m_removeButton;
    private List<IMetricThreshold> m_data;
    private Map<IMetricDescriptor, IMetricThreshold> m_cloneToOriginals;
    private final List<IMetricThreshold> m_removedThresholds = new ArrayList<IMetricThreshold>();

    public ThresholdAnalyzerPropertyPage() {
        super((IAnalyzerId)CoreAnalyzerId.METRIC_THRESHOLDS);
    }

    @Override
    protected int getNumberOfColumns() {
        return 2;
    }

    @Override
    public IDialogId getDialogId() {
        return CoreDialogId.THRESHOLD_ANALYZER_PROPERTY_PAGE;
    }

    @Override
    protected void fillDialogArea(Composite composite, ThresholdAnalyzerConfiguration configuration, boolean readOnly) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        this.m_thresholdList = new PropertyTableViewer(composite, (BeanPropertyReader.BeanAdapter)new ThresholdBeanAdapter(), "metricName", true, PropertyTableViewer.SelectionType.SINGLE_FULL_LINE);
        this.m_thresholdList.addColumn("Metric", "metricName", "metricName", null, 35, PropertyTableViewer.ColumnType.TEXT);
        this.m_thresholdList.addColumn("Level", "metricLevel", "metricLevel", null, 25, PropertyTableViewer.ColumnType.TEXT);
        this.m_thresholdList.addColumn("Lower", "lowerThreshold", "lowerThresholdNumber", null, 20, PropertyTableViewer.ColumnType.NUMBER);
        this.m_thresholdList.addColumn("Upper", "upperThreshold", "upperThresholdNumber", null, 20, PropertyTableViewer.ColumnType.NUMBER);
        this.m_thresholdList.addColumn("Severity", "severity", "severity", null, 20, PropertyTableViewer.ColumnType.TEXT);
        this.m_thresholdList.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonRow = new Composite(composite, 0);
        buttonRow.setLayoutData((Object)new GridData(1, 4, false, true));
        buttonRow.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)1));
        this.m_addButton = new Button(buttonRow, 8);
        this.m_addButton.setImage(UiResourceManager.getInstance().getImage("New"));
        this.m_addButton.setEnabled(!readOnly);
        this.m_removeButton = new Button(buttonRow, 8);
        this.m_removeButton.setImage(UiResourceManager.getInstance().getImage("Delete"));
        this.m_removeButton.setEnabled(false);
        this.m_editButton = new Button(buttonRow, 8);
        this.m_editButton.setImage(UiResourceManager.getInstance().getImage("Edit"));
        this.m_editButton.setEnabled(false);
        if (!readOnly) {
            this.m_thresholdList.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ThresholdAnalyzerPropertyPage.this.handleThresholdSelectionChanged();
                }
            });
            this.m_addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ThresholdAnalyzerPropertyPage.this.performAdd();
                }
            });
            this.m_editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ThresholdAnalyzerPropertyPage.this.performEdit();
                }
            });
            this.m_removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ThresholdAnalyzerPropertyPage.this.performRemove();
                }
            });
        }
        this.readThresholdsFromModel();
        this.m_thresholdList.showData(this.m_data);
    }

    private void readThresholdsFromModel() {
        IThresholdProvider tp = (IThresholdProvider)this.getSoftwareSystem().getExtension(IThresholdProvider.class);
        this.m_data = new ArrayList<IMetricThreshold>();
        this.m_cloneToOriginals = new HashMap<IMetricDescriptor, IMetricThreshold>();
        List thresholds = tp.getThresholds(false);
        for (IMetricThreshold t : thresholds) {
            IMetricThreshold clone = (IMetricThreshold)((MetricThreshold)t).clone();
            this.m_data.add(clone);
            this.m_cloneToOriginals.put(t.getMetricDescriptor(), t);
        }
        this.m_removedThresholds.clear();
    }

    private IMetricThreshold openThresholdDialog(String title, IMetricThreshold th) {
        ThresholdDialog dialog = new ThresholdDialog(this.getShell(), title, this.getSoftwareSystem(), th);
        if (dialog.open() == 0) {
            return dialog.getThreshold();
        }
        return null;
    }

    private void performAdd() {
        IMetricThreshold addedThreshold = this.openThresholdDialog("Add New Threshold", null);
        if (addedThreshold != null) {
            IMetricThreshold found = null;
            for (IMetricThreshold existing : this.m_data) {
                if (existing.getMetricDescriptor() != addedThreshold.getMetricDescriptor()) continue;
                found = existing;
                existing.setLowerThreshold(addedThreshold.getLowerThreshold());
                existing.setUpperThreshold(addedThreshold.getUpperThreshold());
                break;
            }
            if (found == null) {
                found = addedThreshold;
                this.m_data.add(addedThreshold);
            }
            for (IMetricThreshold removed : this.m_removedThresholds) {
                if (removed.getMetricDescriptor() != addedThreshold.getMetricDescriptor()) continue;
                this.m_removedThresholds.remove(removed);
                break;
            }
            this.m_thresholdList.showData(this.m_data);
            this.m_thresholdList.getTableViewer().setSelection((ISelection)new StructuredSelection((Object)found), true);
        }
    }

    private void performEdit() {
        assert (this.getSelectedThreshold() != null);
        if (this.openThresholdDialog("Edit Threshold", this.getSelectedThreshold()) != null) {
            this.m_thresholdList.showData(this.m_data);
        }
    }

    private void performRemove() {
        IMetricThreshold metricsThreshold = this.getSelectedThreshold();
        assert (metricsThreshold != null);
        this.m_data.remove(metricsThreshold);
        IMetricThreshold original = this.m_cloneToOriginals.get(metricsThreshold.getMetricDescriptor());
        if (original != null) {
            this.m_removedThresholds.add(original);
        }
        this.m_thresholdList.showData(this.m_data);
        this.handleThresholdSelectionChanged();
    }

    private void handleThresholdSelectionChanged() {
        IMetricThreshold metricsThreshold = this.getSelectedThreshold();
        this.m_editButton.setEnabled(metricsThreshold != null);
        this.m_removeButton.setEnabled(metricsThreshold != null);
    }

    private IMetricThreshold getSelectedThreshold() {
        if (this.m_thresholdList != null && !this.m_thresholdList.isDisposed() && this.m_thresholdList.getSelection() != null && !this.m_thresholdList.getSelection().isEmpty()) {
            assert (this.m_thresholdList.getSelection().getFirstElement() != null && this.m_thresholdList.getSelection().getFirstElement() instanceof IMetricThreshold) : "Unexpected class in method 'getSelection': " + String.valueOf(this.m_thresholdList.getSelection().getFirstElement());
            return (IMetricThreshold)this.m_thresholdList.getSelection().getFirstElement();
        }
        return null;
    }

    @Override
    public boolean performOk() {
        if (this.isReadOnly() || !this.contentCreated()) {
            return true;
        }
        ArrayList<IMetricThreshold> addedThresholds = new ArrayList<IMetricThreshold>();
        ArrayList<IMetricThreshold> modifiedThresholds = new ArrayList<IMetricThreshold>();
        for (IMetricThreshold th : this.m_data) {
            IMetricThreshold original = this.m_cloneToOriginals.get(th.getMetricDescriptor());
            if (original != null) {
                boolean modified;
                if (original.getMetricDescriptor().isFloat()) {
                    modified = original.getLowerThreshold().floatValue() != th.getLowerThreshold().floatValue() || original.getUpperThreshold().floatValue() != th.getUpperThreshold().floatValue() || original.getSeverity() != th.getSeverity();
                } else {
                    boolean bl = modified = original.getLowerThreshold().intValue() != th.getLowerThreshold().intValue() || original.getUpperThreshold().intValue() != th.getUpperThreshold().intValue() || original.getSeverity() != th.getSeverity();
                }
                if (!modified) continue;
                original.setLowerThreshold(th.getLowerThreshold());
                original.setUpperThreshold(th.getUpperThreshold());
                original.setSeverity(th.getSeverity());
                modifiedThresholds.add(original);
                continue;
            }
            addedThresholds.add(th);
        }
        if (addedThresholds.size() > 0 || modifiedThresholds.size() > 0 || this.m_removedThresholds.size() > 0) {
            UpdateThresholdsCommand cmd = new UpdateThresholdsCommand((ISoftwareSystemProvider)this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), new SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction(){

                public void process(OperationResult result) {
                    if (!$assertionsDisabled && result == null) {
                        throw new AssertionError((Object)"Parameter 'result' of method 'process' must not be null");
                    }
                    UserInterfaceAdapter.getInstance().process(result);
                }

                public INavigationState getNavigationState() {
                    return ViewNavigationManager.getInstance().getCurrentNavigationState();
                }
            }, addedThresholds, modifiedThresholds, this.m_removedThresholds);
            UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)cmd);
            this.readThresholdsFromModel();
        }
        return true;
    }
}

