/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.settings;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.system.settings.ISettingsDelta;
import com.hello2morrow.sonargraph.foundation.common.StandaloneResourceProviderAdapter;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.base.EditorPreferences;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.StandardPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.settings.PositiveIntegerValidator;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EditorPreferencePage
extends StandardPreferencePage
implements ISettingsDelta {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditorPreferencePage.class);
    private static final String TITLE = "Editor";
    private static final String PROPERTY_PREFIX = "standalone.label.editor.";
    private Button m_autoFormat;
    private Button m_showWhiteSpace;
    private Button m_indentEmptyLines;
    private ValidatingTextWidget m_tabSize;
    private Combo m_comboPolicy;
    private EditorPreferences m_initialConfiguration;
    private EditorPreferences m_currentConfiguration;
    private boolean m_indentationSizeIsValid;
    private Combo m_comboBraceStart;
    private Combo m_comboBraceEnd;

    public EditorPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    public String getTitle() {
        return TITLE;
    }

    @Override
    public IDialogId getDialogId() {
        return CoreDialogId.EDITOR_PREFERENCES_PAGE;
    }

    @Override
    protected Composite createPageContents(Composite parent) {
        this.m_initialConfiguration = new EditorPreferences();
        this.m_currentConfiguration = this.m_initialConfiguration.copy();
        Composite container = new Composite(parent, 0);
        container.setSize(600, 400);
        container.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)2, (boolean)false));
        Label autoFormatLabel = new Label(container, 131072);
        autoFormatLabel.setText(StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.editor.autoFormat", new Object[0]));
        this.m_autoFormat = new Button(container, 32);
        this.m_autoFormat.addListener(13, event -> {
            Button btn = (Button)event.widget;
            this.m_currentConfiguration.setAutoFormat(btn.getSelection());
            this.handleButtons();
        });
        Label showWhiteSpaceLabel = new Label(container, 131072);
        showWhiteSpaceLabel.setText(StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.editor.showWhiteSpace", new Object[0]));
        this.m_showWhiteSpace = new Button(container, 32);
        this.m_showWhiteSpace.addListener(13, event -> {
            Button btn = (Button)event.widget;
            this.m_currentConfiguration.setShowWhiteSpace(btn.getSelection());
            this.handleButtons();
        });
        Label indentEmptyLinesLabel = new Label(container, 131072);
        indentEmptyLinesLabel.setText(StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.editor.indentEmptyLines", new Object[0]));
        this.m_indentEmptyLines = new Button(container, 32);
        this.m_indentEmptyLines.addListener(13, event -> {
            Button btn = (Button)event.widget;
            this.m_currentConfiguration.setIndentEmptyLines(btn.getSelection());
            this.handleButtons();
        });
        Label indentationSizeLabel = new Label(container, 131072);
        indentationSizeLabel.setText(StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.editor.indentationSize", new Object[0]));
        this.m_tabSize = new ValidatingTextWidget(container, (ITextValidator)new PositiveIntegerValidator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                if (input != null && !input.trim().isEmpty()) {
                    EditorPreferencePage.this.m_currentConfiguration.setIndentSize(Integer.parseInt(input));
                    EditorPreferencePage.this.m_indentationSizeIsValid = true;
                } else {
                    EditorPreferencePage.this.m_indentationSizeIsValid = false;
                }
                EditorPreferencePage.this.handleButtons();
            }
        });
        this.m_tabSize.setLayoutData((Object)new GridData(4, 0, true, false));
        SwtUtility.createOneCellLabel((Composite)container, (String)StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.editor.policy", new Object[0]), (int)16384);
        this.m_comboPolicy = new Combo(container, 12);
        this.m_comboPolicy.add(StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.editor.policy.tab", new Object[0]));
        this.m_comboPolicy.add(StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.editor.policy.blank", new Object[0]));
        this.m_comboPolicy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int policy = ((Combo)e.getSource()).getSelectionIndex();
                EditorPreferencePage.this.m_currentConfiguration.setUseTabs(policy == 0);
                EditorPreferencePage.this.handleButtons();
            }
        });
        SwtUtility.createOneCellLabel((Composite)container, (String)StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.editor.braceStart", new Object[0]), (int)16384);
        this.m_comboBraceStart = new Combo(container, 12);
        this.m_comboBraceStart.add(StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.editor.sameLine", new Object[0]));
        this.m_comboBraceStart.add(StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.editor.nextLine", new Object[0]));
        this.m_comboBraceStart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int sameOrNext = ((Combo)e.getSource()).getSelectionIndex();
                EditorPreferencePage.this.m_currentConfiguration.setBracesStart(sameOrNext);
                EditorPreferencePage.this.handleButtons();
            }
        });
        SwtUtility.createOneCellLabel((Composite)container, (String)StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.editor.braceEnd", new Object[0]), (int)16384);
        this.m_comboBraceEnd = new Combo(container, 12);
        this.m_comboBraceEnd.add(StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.editor.sameLine", new Object[0]));
        this.m_comboBraceEnd.add(StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.editor.nextLine", new Object[0]));
        this.m_comboBraceEnd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int sameOrNext = ((Combo)e.getSource()).getSelectionIndex();
                EditorPreferencePage.this.m_currentConfiguration.setBracesEnd(sameOrNext);
                EditorPreferencePage.this.handleButtons();
            }
        });
        this.createButtonsPart(parent, true);
        this.getApplyButton().setEnabled(false);
        this.getCancelButton().setEnabled(false);
        this.applyCurrentConfigurationToWidgets();
        return container;
    }

    private void handleButtons() {
        this.getApplyButton().setEnabled(this.isModified() && this.m_indentationSizeIsValid);
        this.getCancelButton().setEnabled(this.isModified());
    }

    @Override
    protected ISettingsDelta getDelta() {
        return this;
    }

    @Override
    protected OperationResult getOperationResult() {
        return null;
    }

    @Override
    protected void cancel() {
        this.reset();
    }

    @Override
    protected void internPerformOk() {
        try {
            this.m_currentConfiguration.store();
            this.m_initialConfiguration = this.m_currentConfiguration.copy();
            this.handleButtons();
        }
        catch (BackingStoreException e) {
            LOGGER.warn("Unable to save preferences", (Throwable)e);
        }
    }

    public boolean isModified() {
        return !this.m_currentConfiguration.equals(this.m_initialConfiguration);
    }

    protected final void performDefaults() {
        this.m_currentConfiguration.setToDefaults();
        this.applyCurrentConfigurationToWidgets();
        this.handleButtons();
    }

    public void reset() {
        this.m_currentConfiguration = this.m_initialConfiguration.copy();
        this.applyCurrentConfigurationToWidgets();
        this.handleButtons();
    }

    private void applyCurrentConfigurationToWidgets() {
        this.m_autoFormat.setSelection(this.m_currentConfiguration.isAutoFormat());
        this.m_showWhiteSpace.setSelection(this.m_currentConfiguration.isShowWhiteSpace());
        this.m_indentEmptyLines.setSelection(this.m_currentConfiguration.isIndentEmptyLines());
        this.m_tabSize.setText(String.valueOf(this.m_currentConfiguration.getTabSize()));
        this.m_comboPolicy.select(this.m_currentConfiguration.useTabs() ? 0 : 1);
        this.m_comboBraceStart.select(this.m_currentConfiguration.getBracesStart());
        this.m_comboBraceEnd.select(this.m_currentConfiguration.getBracesEnd());
    }
}

