/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.settings;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.ApplyEditedConfigurationCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.standalone.documentation.ui.help.HelpRegistry;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.IAnalyzerPreferencePage;
import com.hello2morrow.sonargraph.ui.swt.base.help.HelpAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class AnalyzerPropertyPage<T extends AnalyzerConfiguration>
extends PreferencePage
implements IAnalyzerPreferencePage {
    private static HelpAdapter s_helpAdapter;
    private final IAnalyzerId m_analyzerId;
    private final T m_configuration;
    private final boolean m_supportsDefaults;
    private Button m_restoreDefaults;
    private boolean m_contentCreated;
    private String m_id;

    public static final void setHelpAdapter(HelpAdapter adapter) {
        assert (adapter != null) : "Parameter 'adapter' of method 'setHelpAdapter' must not be null";
        s_helpAdapter = adapter;
    }

    public static final void resetHelpAdapter() {
        s_helpAdapter = null;
    }

    public AnalyzerPropertyPage(IAnalyzerId analyzerId, boolean supportsDefaultValues) {
        AnalyzerConfiguration configuration;
        block3: {
            assert (analyzerId != null) : "Parameter 'analyzerId' of method 'AnalyzerPropertyPage' must not be null";
            this.m_analyzerId = analyzerId;
            configuration = null;
            try {
                configuration = ApplyEditedConfigurationCommand.getConfigurationForEdit((ISoftwareSystemProvider)((ISoftwareSystemProvider)this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class)), (IAnalyzerId)this.m_analyzerId);
            }
            catch (ClassCastException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)("Unexpected class: " + ExceptionUtility.collectAll((Throwable)e)));
            }
        }
        this.m_configuration = configuration;
        this.m_supportsDefaults = supportsDefaultValues;
        this.noDefaultAndApplyButton();
    }

    public AnalyzerPropertyPage(IAnalyzerId analyzerId) {
        this(analyzerId, false);
    }

    @Override
    public Language getLanguage() {
        return this.m_analyzerId.getLanguage();
    }

    @Override
    public final void setId(String id) {
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'setId' must not be empty";
        this.m_id = id;
    }

    @Override
    public final String getId() {
        assert (this.m_id != null && this.m_id.length() > 0) : "'m_id' of method 'getId' must not be empty";
        return this.m_id;
    }

    protected final boolean contentCreated() {
        return this.m_contentCreated;
    }

    @Override
    public final IAnalyzerId getAnalyzerId() {
        return this.m_analyzerId;
    }

    protected final T getConfiguration() {
        return this.m_configuration;
    }

    protected final SoftwareSystem getSoftwareSystem() {
        return WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem();
    }

    protected final boolean isReadOnly() {
        return !SonargraphCommand.isAvailable((ICommandId)CoreCommandId.APPLY_EDITED_CONFIGURATION, (SoftwareSystem)this.getSoftwareSystem());
    }

    @Override
    public IDialogId getDialogId() {
        return null;
    }

    public final void setTitle(String title) {
        if (this.isReadOnly()) {
            super.setTitle(title + " - Read Only");
        } else {
            super.setTitle(title);
        }
    }

    protected void fillDialogArea(Composite composite, T configuration, boolean readOnly) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'fillDialogArea' must not be null";
    }

    protected int getNumberOfColumns() {
        return 1;
    }

    protected boolean makeColumnsEqualWidth() {
        return false;
    }

    protected boolean enableRestoreDefaultsButton(T configuration) {
        assert (this.m_supportsDefaults) : "Does not support defaults";
        return false;
    }

    protected void updateRestoreDefaultsButton() {
        assert (this.m_supportsDefaults) : "Does not support defaults";
        this.m_restoreDefaults.setEnabled(this.enableRestoreDefaultsButton(null));
    }

    protected void restoreDefaults() {
        assert (this.m_supportsDefaults) : "Does not support defaults";
    }

    protected void contributeButtons(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'contributeButtons' must not be null";
        if (this.m_supportsDefaults) {
            this.m_restoreDefaults = new Button(parent, 8);
            this.m_restoreDefaults.setText("Restore Defaults");
            this.m_restoreDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    AnalyzerPropertyPage.this.restoreDefaults();
                    AnalyzerPropertyPage.this.updateRestoreDefaultsButton();
                }
            });
            ++((GridLayout)parent.getLayout()).numColumns;
            this.m_restoreDefaults.setEnabled(this.enableRestoreDefaultsButton(this.m_configuration));
        }
    }

    protected final Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(this.getNumberOfColumns(), this.makeColumnsEqualWidth());
        gridLayout.horizontalSpacing = 7;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginBottom = 5;
        gridLayout.marginTop = 5;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 5;
        composite.setLayout((Layout)gridLayout);
        this.fillDialogArea(composite, this.m_configuration, this.isReadOnly());
        this.m_contentCreated = true;
        return composite;
    }

    public final void createControl(Composite parent) {
        super.createControl(parent);
        if (s_helpAdapter != null && this.getDialogId() != null) {
            HelpRegistry.getInstance().register((Object)this, this.getDialogId().getId());
        }
    }

    private TrayDialog getTrayDialog() {
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof TrayDialog) {
            return (TrayDialog)container;
        }
        return null;
    }

    protected boolean applyChanges(T configuration) {
        assert (configuration != null) : "Parameter 'configuration' of method 'applyChanges' must not be null";
        return true;
    }

    protected final void performApply() {
    }

    protected final void performDefaults() {
    }

    protected String isDataValid() {
        return null;
    }

    public boolean performOk() {
        String notValid = this.isDataValid();
        if (notValid != null && !notValid.isEmpty()) {
            UserInterfaceAdapter.getInstance().warning("Data is not valid!", notValid);
            return false;
        }
        if (!this.isReadOnly() && this.m_contentCreated && this.applyChanges(this.m_configuration)) {
            ApplyEditedConfigurationCommand command = new ApplyEditedConfigurationCommand(WorkbenchRegistry.getInstance().getProvider(), new ApplyEditedConfigurationCommand.IInteraction(){

                public boolean collect(ApplyEditedConfigurationCommand.ConfigurationData data) {
                    data.setConfiguration(AnalyzerPropertyPage.this.m_configuration);
                    return true;
                }

                public INavigationState getNavigationState() {
                    return ViewNavigationManager.getInstance().getCurrentNavigationState();
                }

                public void processApplyResult(OperationResult result) {
                    UserInterfaceAdapter.getInstance().process(result);
                }
            });
            UserInterfaceAdapter.getInstance().run((Command)command);
        }
        return true;
    }

    public final void performHelp() {
        TrayDialog dialog;
        if (this.getDialogId() != null && (dialog = this.getTrayDialog()) != null) {
            if (dialog.getTray() == null) {
                s_helpAdapter.showHelp(dialog, (Object)this);
            } else {
                dialog.closeTray();
            }
        }
    }

    public void dispose() {
        if (this.getDialogId() != null) {
            HelpRegistry.getInstance().unregister((Object)this);
        }
        super.dispose();
    }
}

