/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.resolutionsview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.SimpleSoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.resolution.DeleteResolutionsCommand;
import com.hello2morrow.sonargraph.core.command.system.resolution.EditResolutionCommand;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.resolution.PatternBasedCycleIgnoreFilter;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.IIssueProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.resolutionsview.ResolutionDialog;
import com.hello2morrow.sonargraph.ui.standalone.resolutionsview.ResolutionsCommandAdapter;
import com.hello2morrow.sonargraph.ui.standalone.wizards.CycleIgnoreWizard;
import com.hello2morrow.sonargraph.ui.swt.base.compositecommand.CompositeCommandAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import java.util.List;
import org.eclipse.swt.widgets.Shell;

public final class EditResolutionsCommandAdapter
extends ResolutionsCommandAdapter {
    public CompositeCommandAdapter.Type getType() {
        return CompositeCommandAdapter.Type.EDIT;
    }

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.EDIT_RESOLUTION;
    }

    public void apply(ISoftwareSystemProvider provider, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'apply' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'apply' must not be empty";
        IIssueProvider issueProvider = (IIssueProvider)provider.getSoftwareSystem().getExtension(IIssueProvider.class);
        List resolutions = issueProvider.getResolutions(elements);
        assert (resolutions != null && !resolutions.isEmpty()) : "'resolutions' of method 'apply' must not be empty";
        String description = "";
        Priority priority = null;
        String assignee = null;
        List namedElementPatterns = null;
        List dependencyPatterns = null;
        Resolution resolution = null;
        ResolutionDialog.AssigneeMode assigneeMode = ResolutionDialog.AssigneeMode.SHOW;
        if (resolutions.size() == 1) {
            resolution = (Resolution)resolutions.get(0);
            description = resolution.getDescription();
            if (!resolution.ignores()) {
                priority = resolution.getPriority();
                assignee = resolution.getAssignee();
            } else {
                assigneeMode = ResolutionDialog.AssigneeMode.HIDE;
            }
            namedElementPatterns = issueProvider.getNamedElementPatterns(resolution);
            dependencyPatterns = issueProvider.getDependencyPatterns(resolution);
        } else {
            assigneeMode = ResolutionDialog.AssigneeMode.SHOW;
            for (Resolution next : resolutions) {
                if (!next.ignores()) continue;
                assigneeMode = ResolutionDialog.AssigneeMode.HIDE;
                break;
            }
            if (assigneeMode == ResolutionDialog.AssigneeMode.SHOW) {
                priority = Priority.MEDIUM;
                assignee = "";
            }
        }
        if (resolution != null && resolution.hasChildren(true, new Class[]{PatternBasedCycleIgnoreFilter.class})) {
            PatternBasedCycleIgnoreFilter filter = (PatternBasedCycleIgnoreFilter)resolution.getUniqueExistingChild(PatternBasedCycleIgnoreFilter.class);
            CycleIgnoreWizard wizard = new CycleIgnoreWizard(provider, filter);
            SonargraphWizardAdapter.createWizardDialog((Shell)WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), (SonargraphWizard)wizard).open();
        } else {
            ResolutionDialog dialog = new ResolutionDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), (String)(resolution == null ? "Edit Resolutions" : "Edit " + resolution.getName()), namedElementPatterns, dependencyPatterns, assignee, priority, description, ResolutionDialog.Mode.EDIT, assigneeMode);
            if (dialog.open() == 0) {
                String[] cancelOk = new String[]{"Ok", "Cancel"};
                if (resolution != null) {
                    if (issueProvider.isPatternEditable(resolution) && (dialog.getNamedElementPatterns() == null || dialog.getNamedElementPatterns().isEmpty()) && (dialog.getDependencyPatterns() == null || dialog.getDependencyPatterns().isEmpty())) {
                        if (UserInterfaceAdapter.getInstance().question("The resolution does not define any matching patterns. Delete the resolution?", cancelOk) == 0) {
                            DeleteResolutionsCommand cmd = new DeleteResolutionsCommand(provider, new SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction(){

                                public void process(OperationResult result) {
                                    if (!$assertionsDisabled && result == null) {
                                        throw new AssertionError((Object)"Parameter 'result' of method 'process' must not be null");
                                    }
                                    UserInterfaceAdapter.getInstance().process(result);
                                }

                                public INavigationState getNavigationState() {
                                    return ViewNavigationManager.getInstance().getCurrentNavigationState();
                                }
                            }, resolutions);
                            UserInterfaceAdapter.getInstance().run((Command)cmd);
                        }
                    } else {
                        EditResolutionCommand cmd = new EditResolutionCommand(provider, new SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction(){

                            public void process(OperationResult result) {
                                if (!$assertionsDisabled && result == null) {
                                    throw new AssertionError((Object)"Parameter 'result' of method 'process' must not be null");
                                }
                                UserInterfaceAdapter.getInstance().process(result);
                            }

                            public INavigationState getNavigationState() {
                                return ViewNavigationManager.getInstance().getCurrentNavigationState();
                            }
                        }, resolutions, dialog.getDescription(), dialog.getAssignee(), dialog.getPriority(), dialog.getNamedElementPatterns(), dialog.getDependencyPatterns());
                        UserInterfaceAdapter.getInstance().run((Command)cmd);
                    }
                } else {
                    UserInterfaceAdapter.getInstance().run((Command)new EditResolutionCommand(provider, new SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction(){

                        public void process(OperationResult result) {
                            if (!$assertionsDisabled && result == null) {
                                throw new AssertionError((Object)"Parameter 'result' of method 'process' must not be null");
                            }
                            UserInterfaceAdapter.getInstance().process(result);
                        }

                        public INavigationState getNavigationState() {
                            return ViewNavigationManager.getInstance().getCurrentNavigationState();
                        }
                    }, resolutions, dialog.getDescription(), dialog.getAssignee(), dialog.getPriority(), null, null));
                }
            }
        }
    }
}

