/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.resolutionsview;

import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ISingleIssueProvider;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.system.IIssueProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.SelectionBasedCommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public abstract class CreateIssueResolutionHandler
extends SelectionBasedCommandHandler {
    protected abstract String getKind();

    private String getLabel(List<Element> selection, String defaultLabel) {
        assert (selection != null) : "Parameter 'selection' of method 'getLabel' must not be null";
        assert (defaultLabel != null) : "Parameter 'defaultLabel' of method 'getLabel' must not be null";
        if (selection.size() == 1) {
            Element selected = selection.get(0);
            if (selected instanceof ISingleIssueProvider) {
                Issue issue = ((ISingleIssueProvider)selected).getAssociatedIssue();
                if (issue != null) {
                    return this.getKind() + " " + issue.getPresentationName(true) + "...";
                }
            } else if (selected instanceof Issue) {
                return this.getKind() + " Issue...";
            }
        }
        return defaultLabel;
    }

    public final IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public String getLabel(IWorkbenchView workbenchView, List<Element> selection, String defaultLabel) {
                return CreateIssueResolutionHandler.this.getLabel(selection, defaultLabel);
            }

            public boolean showInContextMenu(IWorkbenchView workbenchView, List<Element> currentSelection) {
                return true;
            }
        };
    }

    public final boolean internalCanExecute(IEclipseContext eclipseContext, MMenuItem menuItem, WorkbenchViewSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'internalCanExecute' must not be null";
        if (!selection.isEmpty() && WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED, WorkbenchState.VIRTUAL_MODEL_IS_MODIFIABLE})) {
            return ((IIssueProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IIssueProvider.class)).associatedResolvableIssuesExist(selection.getWorkbenchView().getContext(), selection.getElements());
        }
        return false;
    }

    protected void apply(ISoftwareSystemProvider provider, IIssueProvider issueProvider, IContext context, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'apply' must not be null";
        assert (issueProvider != null) : "Parameter 'issueProvider' of method 'apply' must not be null";
        assert (context != null) : "Parameter 'context' of method 'apply' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'apply' must not be empty";
    }

    @Execute
    public final void execute(@Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'execute' must not be null";
        assert (!selection.isEmpty()) : "selection is empty";
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        IIssueProvider issueProvider = (IIssueProvider)provider.getSoftwareSystem().getExtension(IIssueProvider.class);
        this.apply(provider, issueProvider, selection.getWorkbenchView().getContext(), selection.getElements());
    }

    protected final void handleMatchedIssuesInfo(int selected, List<Issue> matched) {
        assert (matched != null) : "Parameter 'matched' of method 'handleMatchedIssuesInfo' must not be null";
        if (selected < matched.size()) {
            StringBuilder builder = new StringBuilder();
            for (Issue next : matched) {
                String nextDescription = next.getDescription();
                builder.append(next.getName()).append(": ").append(next.getAffectedElement().getName());
                if (nextDescription != null && !nextDescription.isEmpty()) {
                    builder.append(" (").append(nextDescription).append(")");
                }
                builder.append("\n");
            }
            UserInterfaceAdapter.getInstance().information("Due to the generated matching criteria more than the selected\nissues have been resolved (" + selected + " selected and " + matched.size() + " matched).\n\nMatched issues:", builder.toString());
        }
    }
}

