/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.reportview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.CreateReportCommand;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.report.CreateReportResult;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.ReportDialog;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import de.schlichtherle.truezip.file.TFile;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.swt.program.Program;

public final class CreateReportHandler
extends CommandHandlerWithCorrespondingCommand {
    public ICommandId getCorrespondingCommandId() {
        return CreateReportCommand.ID;
    }

    @CanExecute
    public boolean canExecute(@Optional MMenuItem menuItem) {
        if (this.isAvailable(menuItem)) {
            return WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED, WorkbenchState.SOFTWARE_SYSTEM_IS_CLEARABLE});
        }
        return false;
    }

    @Execute
    protected void execute() {
        if (!CreateReportHandler.performCheck((CommandHandler.Check)CommandHandler.Check.LEVEL, (boolean)true)) {
            return;
        }
        UserInterfaceAdapter.getInstance().run((Command)new CreateReportCommand(WorkbenchRegistry.getInstance().getProvider(), (CreateReportCommand.IReportInteraction)new CreateReportInteraction()));
    }

    private class CreateReportInteraction
    implements CreateReportCommand.IReportInteraction {
        private CreateReportInteraction() {
        }

        public INavigationState getNavigationState() {
            return ViewNavigationManager.getInstance().getCurrentNavigationState();
        }

        public boolean collect(final CreateReportCommand.ReportInteractionData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            RunnableWithResult<Boolean> runnable = new RunnableWithResult<Boolean>(){

                public void run() {
                    ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
                    SoftwareSystem softwareSystem = provider.getSoftwareSystem();
                    ReportDialog dialog = new ReportDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), softwareSystem.getMode() == SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT ? softwareSystem.getDirectoryFile().getParentFile() : softwareSystem.getDirectoryFile(), data.getAvailableLevels(), data.getStandardLevels(), data.getMaxRowCountPerMetricForHtml());
                    if (dialog.open() == 0) {
                        data.setMetricLevels(dialog.getSelectedMetricLevels());
                        data.setReportFormats(EnumSet.of(dialog.getSelectedReportFormat()));
                        data.setReportDirectory(dialog.getReportDirectory());
                        data.setMaxRowCountPerMetricForHtml(dialog.getMaxRowCountPerMetric());
                        data.setSplitByModule(dialog.getSplitByModule());
                        this.setResult(Boolean.TRUE);
                    } else {
                        this.setResult(Boolean.FALSE);
                    }
                }
            };
            return (Boolean)UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)runnable);
        }

        public void handleResult(OperationResultWithOutcome<CreateReportResult> result) {
            assert (result != null) : "Parameter 'result' of method 'handleResult' must not be null";
            if (result.isSuccess()) {
                CreateReportResult createReportResult = (CreateReportResult)result.getOutcome();
                assert (createReportResult != null) : "'createReportResult' of method 'handleResult' must not be null";
                List targetFiles = createReportResult.getTargetFiles();
                assert (targetFiles != null && targetFiles.size() == 1) : "'targetFiles' of method 'handleResult' must contain exactly 1 target file";
                final TFile targetFile = (TFile)targetFiles.get(0);
                if (UserInterfaceAdapter.Feedback.CONFIRMED == UserInterfaceAdapter.getInstance().question("Report has been saved to: \n\n" + targetFile.getNormalizedAbsolutePath() + "\n\nDo you want to open it?\nNote that it takes some time to render reports with many metric levels and a high number of values/metric.", false)) {
                    UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                        @Override
                        public void run() {
                            Program.launch((String)targetFile.getNormalizedAbsolutePath());
                        }
                    });
                }
            } else {
                UserInterfaceAdapter.getInstance().process(result);
            }
        }
    }
}

