/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.qualitygateview;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementGroup;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultAvailableEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultClearedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableFileDeletedEvent;
import com.hello2morrow.sonargraph.core.model.event.MultipleModifiableFileModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateResultElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateResultElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResultStatus;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.qualitygateview.QualityGateElementAdapter;
import com.hello2morrow.sonargraph.ui.standalone.qualitygateview.QualityGateElementBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.qualitygateview.QualityGateTreeContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.view.TreeBasedViewNavigationStateUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PagingPropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewerBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.TreeBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class QualityGateView
extends WorkbenchSlaveView
implements ISelectionChangedListener,
ITreeViewerListener {
    private static final int TREE_EXPANSION_LEVEL = 3;
    private final QualityGateElementBeanAdapter m_elementBeanAdapter = new QualityGateElementBeanAdapter();
    private final QualityGateTreeContentAndLabelProvider m_treeViewerContentProvider = new QualityGateTreeContentAndLabelProvider();
    private TreeViewer m_treeViewer;
    private PagingPropertyTableViewer<QualityGateElementAdapter> m_tableViewer;
    private TreeBasedTextSearchHandler m_textSearchProviderTree;
    private PropertyTableViewerBasedTextSearchHandler m_textSearchProviderTable;
    private Component m_selectedComponent = Component.TREE;
    private QualityGate m_qualityGate;

    protected boolean supportsSleep() {
        return false;
    }

    public IViewId getViewId() {
        return ViewId.QUALITY_GATE_VIEW;
    }

    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.clearAndCloseView();
    }

    private void clearAndCloseView() {
        this.resetPartName();
        this.hideView();
        this.m_qualityGate = null;
    }

    protected void destroyViewContent() {
        this.m_treeViewer.removeTreeListener((ITreeViewerListener)this);
        EventManager.getInstance().detach(AnalyzerResultAvailableEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzerResultClearedEvent.class, (Object)this);
        EventManager.getInstance().detach(ModifiableFileDeletedEvent.class, (Object)this);
        EventManager.getInstance().detach(MultipleModifiableFileModifiedEvent.class, (Object)this);
        super.destroyViewContent();
    }

    protected void createViewContent(Composite viewContentArea) {
        SashForm sashForm = new SashForm(viewContentArea, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_treeViewer = new TreeViewer((Composite)sashForm, 66308);
        this.createTreeViewerColumn("Condition", 500, 16384, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                Element element = (Element)object;
                return element.getPresentationName(false);
            }

            public Image getImage(Object element) {
                return UiResourceManager.getInstance().getImage((Element)element);
            }
        }, null);
        this.createTreeViewerColumn("Status", 125, 16384, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IQualityGateElement && QualityGateView.this.m_qualityGate.getResultElement() != null) {
                    IQualityGateResultElement resultElement = ((IQualityGateElement)element).getResultElement();
                    if (resultElement != null) {
                        QualityGateResultStatus status = resultElement.getResultStatus();
                        return status != null ? status.getPresentationName() : "";
                    }
                    return "";
                }
                return "";
            }

            public Image getImage(Object element) {
                String imageResourceName;
                QualityGateResultStatus status;
                IQualityGateResultElement resultElement;
                if (element instanceof IQualityGateElement && QualityGateView.this.m_qualityGate.getResultElement() != null && (resultElement = ((IQualityGateElement)element).getResultElement()) != null && (status = resultElement.getResultStatus()) != null && (imageResourceName = status.getImageResourceName()) != null) {
                    return UiResourceManager.getInstance().getImage(imageResourceName);
                }
                return null;
            }
        }, null);
        this.createTreeViewerColumn("Information", 275, 16384, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IQualityGateResultElement resultElement;
                if (element instanceof IQualityGateElement && QualityGateView.this.m_qualityGate.getResultElement() != null && (resultElement = ((IQualityGateElement)element).getResultElement()) != null) {
                    return resultElement.getInformation();
                }
                if (element instanceof Element) {
                    return ((Element)element).getDescription();
                }
                return "";
            }
        }, null);
        this.m_treeViewer.setContentProvider((IContentProvider)this.m_treeViewerContentProvider);
        this.m_treeViewer.setUseHashlookup(true);
        this.m_treeViewer.getTree().setHeaderVisible(true);
        this.m_treeViewer.getTree().setLinesVisible(false);
        this.m_treeViewer.addTreeListener((ITreeViewerListener)this);
        this.m_tableViewer = new PagingPropertyTableViewer((Composite)sashForm, (BeanPropertyReader.BeanAdapter)this.m_elementBeanAdapter, null, true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE, 1000);
        this.m_tableViewer.addColumn("Issue/Metric", "name", "name", "image", 200, PropertyTableViewer.ColumnType.TEXT);
        this.m_tableViewer.addColumn("Element", "affectedElement", "affectedElement", "affectedElementImage", 200, PropertyTableViewer.ColumnType.TEXT);
        this.m_tableViewer.addColumn("Change", "change", "change", "changeImage", 150, PropertyTableViewer.ColumnType.TEXT);
        this.m_tableViewer.addColumn("Information", "information", "information", null, 350, PropertyTableViewer.ColumnType.TEXT);
        this.m_tableViewer.addColumn("Category", "category", "category", null, 200, PropertyTableViewer.ColumnType.TEXT);
        this.m_tableViewer.addColumn("Provider", "provider", "provider", null, 200, PropertyTableViewer.ColumnType.TEXT);
        this.m_textSearchProviderTree = new TreeBasedTextSearchHandler(this.m_treeViewer, this.getViewId().getPresentationName());
        this.m_textSearchProviderTable = new PropertyTableViewerBasedTextSearchHandler(this.m_tableViewer, this.getViewId().getPresentationName());
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultAvailableEvent>(AnalyzerResultAvailableEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultAvailableEvent event) {
                AnalyzerResult analyzerResult;
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (QualityGateView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOriginator() == null && (analyzerResult = event.getResult()).getId() == CoreAnalyzerId.QUALITY_GATES) {
                    QualityGateView.this.refresh();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultClearedEvent>(AnalyzerResultClearedEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultClearedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (QualityGateView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.contains((IAnalyzerId)CoreAnalyzerId.QUALITY_GATES)) {
                    QualityGateView.this.refresh();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableFileDeletedEvent>(ModifiableFileDeletedEvent.class, (Object)this){

            public void handleEvent(ModifiableFileDeletedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (QualityGateView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getModifiableFiles().contains(QualityGateView.this.m_qualityGate)) {
                    QualityGateView.this.clearAndCloseView();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<MultipleModifiableFileModifiedEvent>(MultipleModifiableFileModifiedEvent.class, (Object)this){

            public void handleEvent(MultipleModifiableFileModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (QualityGateView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getModifiableFiles().contains(QualityGateView.this.m_qualityGate)) {
                    QualityGateView.this.setPartName(QualityGateView.this.m_qualityGate.getShortName());
                    QualityGateView.this.refresh();
                }
            }
        });
    }

    private void createTreeViewerColumn(String columnHeader, int width, int style, CellLabelProvider labelProvider, Image image) {
        assert (this.m_treeViewer != null) : "'m_treeViewer' of method 'createTreeViewerColumn' must not be null";
        assert (columnHeader != null && columnHeader.length() > 0) : "Parameter 'columnHeader' of method 'createTreeViewerColumn' must not be empty";
        assert (labelProvider != null) : "Parameter 'labelProvider' of method 'createTreeViewerColumn' must not be null";
        TreeViewerColumn column = new TreeViewerColumn(this.m_treeViewer, style);
        column.getColumn().setText(columnHeader);
        column.getColumn().setWidth(width);
        column.setLabelProvider(labelProvider);
        if (image != null) {
            column.getColumn().setImage(image);
        }
    }

    public void showInView(IContext context, List<Element> elements, List<IStandardEnumeration> options, boolean secondaryIdReused) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'showInView' must not be empty";
        assert (elements.size() == 1) : "Exactly one element expected, but was " + elements.size();
        assert (elements.get(0) instanceof QualityGate) : "Unexpected element of type " + elements.get(0).getClass().getCanonicalName();
        if (this.m_qualityGate == null) {
            this.removeListeners();
            this.m_treeViewer.getTree().setRedraw(false);
            this.m_tableViewer.getTable().setRedraw(false);
            this.m_qualityGate = (QualityGate)elements.get(0);
            this.setPartName(this.m_qualityGate.getShortName());
            this.m_treeViewer.setInput((Object)this.m_qualityGate);
            this.m_treeViewer.expandToLevel(3);
            this.m_tableViewer.showData(null);
            this.m_tableViewer.getTable().setRedraw(true);
            this.m_treeViewer.getTree().setRedraw(true);
            this.addListeners();
        } else assert (this.m_qualityGate == elements.get(0)) : "Not the same quality gate";
    }

    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        WorkbenchRegistry.getInstance().selectView((IWorkbenchView)this);
    }

    private void refresh() {
        this.removeListeners();
        this.m_treeViewer.getTree().setRedraw(false);
        this.m_tableViewer.getTable().setRedraw(false);
        this.m_treeViewer.refresh();
        NavigationState state = ViewNavigationManager.getInstance().getCurrentViewNavigationState(this.getViewId(), this.getSecondaryId());
        if (state != null) {
            TreeBasedViewNavigationStateUtility.restoreViewState((TreeViewer)this.m_treeViewer, (NavigationState)state, (IElementResolver)this.getElementResolver());
            this.showElementsForSelectedCondition();
            List tableSelection = state.getElements((IElementGroup)ElementGroup.TABLE_SELECTION, Element.class, this.getElementResolver());
            this.m_tableViewer.getTableViewer().setSelection((ISelection)new StructuredSelection(tableSelection.toArray()), true);
        }
        this.m_tableViewer.getTable().setRedraw(true);
        this.m_treeViewer.getTree().setRedraw(true);
        this.addListeners();
    }

    public List<Element> getSelectedElements() {
        ITreeSelection selection = switch (this.m_selectedComponent) {
            case Component.TREE -> this.m_treeViewer.getStructuredSelection();
            case Component.TABLE -> this.m_tableViewer.getSelection();
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unhandled section: " + String.valueOf((Object)this.m_selectedComponent)));
                }
                yield null;
            }
        };
        if (selection != null && !selection.isEmpty()) {
            return this.getElementsFromSelection((IStructuredSelection)selection);
        }
        return Collections.singletonList(this.m_qualityGate);
    }

    private List<Element> getElementsFromSelection(IStructuredSelection selection) {
        IStructuredSelection structuredSelection = selection;
        List list = structuredSelection.toList();
        ArrayList<Element> elements = new ArrayList<Element>(list.size());
        for (Object next : list) {
            if (next instanceof Element) {
                elements.add((Element)next);
                continue;
            }
            if (!(next instanceof QualityGateElementAdapter)) continue;
            elements.add(((QualityGateElementAdapter)next).getAdaptedElement());
        }
        return elements;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        this.removeListeners();
        Object source = event.getSource();
        assert (source != null) : "Parameter 'source' of method 'selectionChanged' must not be null";
        if (source == this.m_treeViewer) {
            this.m_selectedComponent = Component.TREE;
            this.showElementsForSelectedCondition();
        } else if (source == this.m_tableViewer.getTableViewer()) {
            this.m_selectedComponent = Component.TABLE;
        } else assert (false) : "Unhandled source: " + source.getClass().getName();
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
        this.completeNavigationState(state, null, null);
        ViewNavigationManager.getInstance().addNavigationState(state);
        List<Element> selectedElements = this.getElementsFromSelection((IStructuredSelection)event.getSelection());
        this.getSelectionProviderAdapter().handleSelectionChanged(selectedElements);
        this.addListeners();
    }

    private List<QualityGateElementAdapter> showElementsForSelectedCondition() {
        assert (this.m_treeViewer != null) : "'m_treeViewer' of method 'showElementsForSelectedCondition' must not be null";
        ITreeSelection selection = this.m_treeViewer.getStructuredSelection();
        ArrayList<AbstractQualityGateElement> selectedElements = new ArrayList<AbstractQualityGateElement>();
        for (Object next : selection.toList()) {
            if (!(next instanceof AbstractQualityGateElement)) continue;
            selectedElements.add((AbstractQualityGateElement)next);
        }
        if (selectedElements.isEmpty()) {
            this.m_tableViewer.showData(null);
            return Collections.emptyList();
        }
        ArrayList<QualityGateElementAdapter> elementsToShow = new ArrayList<QualityGateElementAdapter>();
        for (AbstractQualityGateElement element : selectedElements) {
            IQualityGateResultElement resultElement = element.getResultElement();
            if (resultElement == null || !(resultElement instanceof AbstractQualityGateResultElement)) continue;
            AbstractQualityGateResultElement result = (AbstractQualityGateResultElement)resultElement;
            result.getMatches().forEach(e -> {
                boolean bl = elementsToShow.add(new QualityGateElementAdapter((Element)e));
            });
        }
        this.m_tableViewer.showData(elementsToShow);
        return elementsToShow;
    }

    protected void componentSelected(Control component) {
        assert (component != null) : "Parameter 'component' of method 'componentSelected' must not be null";
        if (component == this.m_treeViewer.getTree()) {
            this.m_selectedComponent = Component.TREE;
            this.m_treeViewer.getTree().setFocus();
        } else if (component == this.m_tableViewer.getTable()) {
            this.m_selectedComponent = Component.TABLE;
            this.m_tableViewer.getTable().setFocus();
        } else assert (false) : "Unhandled component: " + String.valueOf(component);
    }

    public Control getSelectedViewComponent() {
        switch (this.m_selectedComponent) {
            case TREE: {
                return this.m_tableViewer.getTable();
            }
            case TABLE: {
                return this.m_treeViewer.getTree();
            }
        }
        assert (false) : "Unhandled component: " + String.valueOf((Object)this.m_selectedComponent);
        return null;
    }

    public List<Control> getControlsForInteraction() {
        return Arrays.asList(this.m_treeViewer.getTree(), this.m_tableViewer.getTable());
    }

    public List<Control> getViewComponents() {
        return Arrays.asList(this.m_treeViewer.getTree(), this.m_tableViewer.getTable());
    }

    private void addListeners() {
        this.m_treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_treeViewer.addTreeListener((ITreeViewerListener)this);
        this.m_tableViewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void removeListeners() {
        this.m_treeViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_treeViewer.removeTreeListener((ITreeViewerListener)this);
        this.m_tableViewer.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void completeNavigationState(NavigationState state, TreeExpansionEvent event, TreeBasedViewNavigationStateUtility.TreeOperation operation) {
        assert (state != null) : "Parameter 'state' of method 'completeNavigationState' must not be null";
        TreeBasedViewNavigationStateUtility.createViewState((NavigationState)state, (IElementResolver)this.getElementResolver(), (TreeViewer)this.m_treeViewer, (TreeExpansionEvent)event, (TreeBasedViewNavigationStateUtility.TreeOperation)operation, Collections.emptyMap());
        IStructuredSelection tableSelection = this.m_tableViewer.getSelection();
        ArrayList<Element> tableElements = new ArrayList<Element>();
        if (tableSelection != null && !tableSelection.isEmpty()) {
            tableElements.addAll(this.getElementsFromSelection(tableSelection));
        }
        state.addElementsInformation((IElementGroup)ElementGroup.TABLE_SELECTION, NavigationState.getDescriptors(tableElements, (IElementResolver)this.getElementResolver()));
        state.addConstant((IStateData)ViewData.SELECTED_COMPONENT, (Enum)this.m_selectedComponent);
    }

    public void completeViewNavigationState(NavigationState state) {
        this.completeNavigationState(state, null, null);
    }

    protected void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'performRestoreNavigationState' must not be null";
        assert (this.m_treeViewer != null) : "'m_treeViewer' of method 'performRestoreNavigationState' must not be null";
        assert (this.m_tableViewer != null) : "'m_tableViewer' of method 'performRestoreNavigationState' must not be null";
        this.removeListeners();
        this.m_treeViewer.getTree().setRedraw(false);
        this.m_tableViewer.getTable().setRedraw(false);
        TreeBasedViewNavigationStateUtility.restoreViewState((TreeViewer)this.m_treeViewer, (NavigationState)state, (IElementResolver)this.getElementResolver());
        ArrayList<QualityGateElementAdapter> tableElements = new ArrayList<QualityGateElementAdapter>(this.showElementsForSelectedCondition());
        List tableSelection = state.getElements((IElementGroup)ElementGroup.TABLE_SELECTION, Element.class, this.getElementResolver());
        ArrayList<QualityGateElementAdapter> tableElementsToSelect = new ArrayList<QualityGateElementAdapter>(tableSelection.size());
        for (QualityGateElementAdapter nextTableElement : tableElements) {
            if (!tableSelection.contains(nextTableElement.getAdaptedElement())) continue;
            tableElementsToSelect.add(nextTableElement);
        }
        this.m_tableViewer.getTableViewer().setSelection((ISelection)new StructuredSelection(tableElementsToSelect.toArray()), true);
        this.m_tableViewer.getTable().setRedraw(true);
        this.m_treeViewer.getTree().setRedraw(true);
        this.addListeners();
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        assert (this.m_treeViewer != null) : "'m_issueTreeViewer' of method 'treeCollapsed' must not be null";
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_COLLAPSED);
        this.completeNavigationState(state, event, TreeBasedViewNavigationStateUtility.TreeOperation.COLLAPSE);
        ViewNavigationManager.getInstance().addNavigationState(state);
    }

    public void treeExpanded(TreeExpansionEvent event) {
        assert (this.m_treeViewer != null) : "'m_issueTreeViewer' of method 'treeExpanded' must not be null";
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_EXPANDED);
        this.completeNavigationState(state, event, TreeBasedViewNavigationStateUtility.TreeOperation.EXPAND);
        ViewNavigationManager.getInstance().addNavigationState(state);
    }

    public Search supportsSearch() {
        return Search.FIND_TEXT;
    }

    protected ITextSearchHandler getTextSearchHandler() {
        switch (this.m_selectedComponent) {
            case TREE: {
                return this.m_textSearchProviderTree;
            }
            case TABLE: {
                return this.m_textSearchProviderTable;
            }
        }
        assert (false) : "Unhandled section: " + String.valueOf((Object)this.m_selectedComponent);
        return null;
    }

    private static enum Component implements IStandardEnumeration
    {
        TREE,
        TABLE;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }

    private static enum ElementGroup implements IElementGroup
    {
        TABLE_SELECTION;

    }

    private static enum ViewData implements IStateData
    {
        SELECTED_COMPONENT;

    }
}

