/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.qualitygateview;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.system.diff.MetricValueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.ui.standalone.diffview.IssueDiffBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.diffview.MetricValueDiffBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.issuesview.IssueBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.swt.graphics.Image;

final class QualityGateElementAdapter {
    private final Element m_adaptedElement;

    public QualityGateElementAdapter(Element object) {
        assert (object != null) : "Parameter 'object' of method 'QualityGateElementAdapter' must not be null";
        this.m_adaptedElement = object;
    }

    public String getName() {
        if (this.isMetricDiff()) {
            return MetricValueDiffBeanAdapter.getMetricPresentationName(this.getMetricValueDiff());
        }
        return this.isIssueDiff() ? IssueDiffBeanAdapter.getIssuePresentationName(this.getDiff()) : IssueBeanAdapter.getIssueName(this.getIssue());
    }

    public Image getImage() {
        if (this.isMetricDiff()) {
            return MetricValueDiffBeanAdapter.getMetricImage();
        }
        return this.isIssueDiff() ? IssueDiffBeanAdapter.getIssueImage(this.getDiff()) : IssueBeanAdapter.getIssueImage(this.getIssue());
    }

    public Element getAffectedElement() {
        if (this.isMetricDiff()) {
            IMetricValue value = (IMetricValue)this.getMetricValueDiff().getCurrentElement();
            return value.getAssociatedElement();
        }
        if (this.isIssueDiff()) {
            return this.getDiff().getCurrent().getAffectedElement();
        }
        return this.getIssue().getAffectedElement();
    }

    public Image getAffectedElementImage() {
        Element affectedElement = this.getAffectedElement();
        return UiResourceManager.getInstance().getImage(affectedElement.getImageResourceName());
    }

    public String getChange() {
        if (this.isMetricDiff()) {
            return MetricValueDiffBeanAdapter.getChange(this.getMetricValueDiff());
        }
        return this.isIssueDiff() ? IssueDiffBeanAdapter.getChange(this.getDiff()) : "n/a";
    }

    public Image getChangeImage() {
        if (this.isMetricDiff()) {
            return MetricValueDiffBeanAdapter.getChangeImage(this.getMetricValueDiff());
        }
        return this.isIssueDiff() ? IssueDiffBeanAdapter.getChangeImage(this.getDiff()) : null;
    }

    public String getSeverity() {
        if (this.isMetricDiff()) {
            return "n/a";
        }
        return this.isIssueDiff() ? IssueDiffBeanAdapter.getSeverity(this.getDiff()) : IssueBeanAdapter.getSeverity(this.getIssue());
    }

    public Image getSeverityImage() {
        if (this.isMetricDiff()) {
            return null;
        }
        return this.isIssueDiff() ? IssueDiffBeanAdapter.getSeverityImage(this.getDiff()) : IssueBeanAdapter.getSeverityImage(this.getIssue());
    }

    public String getCategory() {
        if (this.isMetricDiff()) {
            return MetricValueDiffBeanAdapter.getCategory(this.getMetricValueDiff());
        }
        return this.isIssueDiff() ? IssueDiffBeanAdapter.getIssueCategory(this.getDiff()) : IssueBeanAdapter.getCategoryName(this.getIssue());
    }

    public String getProvider() {
        if (this.isMetricDiff()) {
            return MetricValueDiffBeanAdapter.getProvider(this.getMetricValueDiff());
        }
        return this.isIssueDiff() ? IssueDiffBeanAdapter.getProvider(this.getDiff()) : IssueBeanAdapter.getIssueProviderName(this.getIssue());
    }

    public String getElementOrFrom() {
        return this.isIssueDiff() ? IssueDiffBeanAdapter.getElementOrFrom(this.getDiff()) : IssueBeanAdapter.getElementOrFrom(this.getIssue(), true);
    }

    public String getDescription() {
        if (this.isMetricDiff()) {
            return MetricValueDiffBeanAdapter.getChangeDetails(this.getMetricValueDiff());
        }
        return this.isIssueDiff() ? IssueDiffBeanAdapter.getChangeDetails(this.getDiff()) : IssueBeanAdapter.getDescription(this.getIssue());
    }

    public Image getElementOrFromImage() {
        return this.isIssueDiff() ? IssueDiffBeanAdapter.getElementOrFromImage(this.getDiff()) : IssueBeanAdapter.getElementOrFromImage(this.getIssue());
    }

    public String getElementOrFromTooltip() {
        return this.isIssueDiff() ? IssueDiffBeanAdapter.getElementOrFromTooltip(this.getDiff()) : IssueBeanAdapter.getElementOrFromTooltip(this.getIssue());
    }

    private boolean isIssueDiff() {
        return this.m_adaptedElement instanceof IIssueDiff;
    }

    private boolean isMetricDiff() {
        return this.m_adaptedElement instanceof MetricValueDiff;
    }

    public Element getAdaptedElement() {
        return this.m_adaptedElement;
    }

    private Issue getIssue() {
        return (Issue)this.m_adaptedElement;
    }

    private IIssueDiff getDiff() {
        return (IIssueDiff)this.m_adaptedElement;
    }

    private MetricValueDiff getMetricValueDiff() {
        return (MetricValueDiff)this.m_adaptedElement;
    }
}

