/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.metricsview;

import java.util.List;
import org.jfree.data.statistics.HistogramBin;
import org.jfree.data.xy.AbstractIntervalXYDataset;

final class SimpleHistogramDataSet
extends AbstractIntervalXYDataset {
    private static final long serialVersionUID = 1L;
    private final List<HistogramBin> m_bins;

    SimpleHistogramDataSet(List<HistogramBin> bins) {
        assert (bins != null && !bins.isEmpty()) : "Parameter 'bins' of method 'SimpleHistogramDataSet' must not be empty";
        this.m_bins = bins;
    }

    public Number getStartX(int series, int item) {
        assert (series == 0) : "Unexpected series: " + series;
        return this.m_bins.get(item).getStartBoundary();
    }

    public Number getEndX(int series, int item) {
        assert (series == 0) : "Unexpected series: " + series;
        return this.m_bins.get(item).getEndBoundary();
    }

    public Number getX(int series, int item) {
        assert (series == 0) : "Unexpected series: " + series;
        HistogramBin bin = this.m_bins.get(item);
        double x = (bin.getStartBoundary() + bin.getEndBoundary()) / 2.0;
        return x;
    }

    public Number getY(int series, int item) {
        assert (series == 0) : "Unexpected series: " + series;
        HistogramBin bin = this.m_bins.get(item);
        return (double)bin.getCount();
    }

    public int getItemCount(int series) {
        assert (series == 0) : "Unexpected series: " + series;
        return this.m_bins.size();
    }

    public int getSeriesCount() {
        return 1;
    }

    public Comparable<?> getSeriesKey(int series) {
        assert (series == 0) : "Unexpected series: " + series;
        return "Elements";
    }

    public Number getStartY(int series, int item) {
        return this.getY(series, item);
    }

    public Number getEndY(int series, int item) {
        return this.getY(series, item);
    }
}

