/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.metricsview;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.system.IThresholdProvider;
import com.hello2morrow.sonargraph.ui.standalone.metricsview.Chart;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import java.awt.Paint;
import java.text.NumberFormat;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.util.Rotation;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.experimental.swt.SWTUtils;

final class PieChart
extends Chart {
    private static final String ELEMENTS = "element(s)";
    private static final String LOWER_VIOLATION = "lower threshold violation(s)";
    private static final String UPPER_VIOLATION = "upper threshold violation(s)";
    private static final String LOWER_VIOLATION_ISSUE_IGNORED = "ignored lower threshold violation(s) by ignore definition(s)";
    private static final String UPPER_VIOLATION_ISSUE_IGNORED = "ignored upper threshold violation(s) by ignore definition(s)";
    private static final String LOWER_VIOLATION_ISSUE_FILTERED_ELEMENTS = "ignored lower threshold violation(s) by issue filter";
    private static final String UPPER_VIOLATION_ISSUE_FILTERED_ELEMENTS = "ignored upper threshold violation(s) by issue filter";

    static ValuesContainer computeValuesContainer(IThresholdProvider thresholdProvider, IMetricDescriptor metricDescriptor, List<IMetricValue> values) {
        assert (thresholdProvider != null) : "Parameter 'thresholdProvider' of method 'computeValuesContainer' must not be null";
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'computeValuesContainer' must not be null";
        assert (values != null && values.size() > 0) : "Parameter 'values' of method 'computeValuesContainer' must not be empty";
        IMetricThreshold threshold = thresholdProvider.getThreshold(metricDescriptor);
        if (threshold == null) {
            return new ValuesContainer(values.size(), 0, 0, 0, 0, 0, 0);
        }
        double lowerThreshold = threshold.getLowerThreshold().doubleValue();
        double upperThreshold = threshold.getUpperThreshold().doubleValue();
        int normals = 0;
        int lowerThresholdViolations = 0;
        int upperThresholdViolations = 0;
        int lowerIgnoredThresholdViolations = 0;
        int upperIgnoredThresholdViolations = 0;
        int lowerThresholdViolationOfIssueFilteredElements = 0;
        int upperThresholdViolationOfIssueFilteredElements = 0;
        for (IMetricValue next : values) {
            double value = next.getValue().doubleValue();
            NamedElementIssue issue = thresholdProvider.getThresholdViolationIssue(metricDescriptor, next.getAssociatedElement());
            if (issue == null) {
                if (value < lowerThreshold) {
                    ++lowerThresholdViolationOfIssueFilteredElements;
                    continue;
                }
                if (value > upperThreshold) {
                    ++upperThresholdViolationOfIssueFilteredElements;
                    continue;
                }
                ++normals;
                continue;
            }
            if (value < lowerThreshold) {
                if (next.getAssociatedElement().ignoreIssues()) {
                    ++lowerThresholdViolationOfIssueFilteredElements;
                    continue;
                }
                if (issue.getResolution() != null && issue.getResolution().ignores()) {
                    ++lowerIgnoredThresholdViolations;
                    continue;
                }
                ++lowerThresholdViolations;
                continue;
            }
            if (!(value > upperThreshold)) continue;
            if (next.getAssociatedElement().ignoreIssues()) {
                ++upperThresholdViolationOfIssueFilteredElements;
                continue;
            }
            if (issue.getResolution() != null && issue.getResolution().ignores()) {
                ++upperIgnoredThresholdViolations;
                continue;
            }
            ++upperThresholdViolations;
        }
        return new ValuesContainer(normals, lowerThresholdViolations, upperThresholdViolations, lowerIgnoredThresholdViolations, upperIgnoredThresholdViolations, lowerThresholdViolationOfIssueFilteredElements, upperThresholdViolationOfIssueFilteredElements);
    }

    PieChart(Composite parent) {
        super(parent, ChartFactory.createPieChart(null, null, (boolean)false, (boolean)false, (boolean)false));
        PiePlot plot = (PiePlot)this.getChart().getPlot();
        NumberFormat percentFormat = NumberFormat.getPercentInstance();
        percentFormat.setMaximumFractionDigits(2);
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("[{2}] {1} {0}", NumberFormat.getInstance(), percentFormat));
        plot.setIgnoreZeroValues(true);
        plot.setStartAngle(340.0);
        plot.setOutlineVisible(false);
        plot.setShadowPaint((Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getBackgroundColor()));
        plot.setDirection(Rotation.CLOCKWISE);
        plot.setForegroundAlpha(1.0f);
        plot.setNoDataMessage("n/a");
        plot.setNoDataMessagePaint((Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getForegroundColor()));
        plot.setSectionPaint((Comparable)((Object)ELEMENTS), (Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getColor(UiResourceManager.GREEN)));
        plot.setSectionPaint((Comparable)((Object)LOWER_VIOLATION), (Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getColor(UiResourceManager.DARK_RED)));
        plot.setSectionPaint((Comparable)((Object)UPPER_VIOLATION), (Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getColor(UiResourceManager.RED)));
        plot.setSectionPaint((Comparable)((Object)LOWER_VIOLATION_ISSUE_IGNORED), (Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getColor(UiResourceManager.DARK_GREY)));
        plot.setSectionPaint((Comparable)((Object)UPPER_VIOLATION_ISSUE_IGNORED), (Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getColor(UiResourceManager.GREY)));
        plot.setSectionPaint((Comparable)((Object)LOWER_VIOLATION_ISSUE_FILTERED_ELEMENTS), (Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_GREY)));
        plot.setSectionPaint((Comparable)((Object)UPPER_VIOLATION_ISSUE_FILTERED_ELEMENTS), (Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getColor(UiResourceManager.VERY_LIGHT_GREY)));
        plot.setBackgroundPaint((Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getBackgroundColor()));
    }

    @Override
    protected String getType() {
        return "Pie Chart";
    }

    void setValues(IMetricDescriptor metricDescriptor, ValuesContainer valueInfo) {
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'setValues' must not be null";
        assert (valueInfo != null) : "Parameter 'valueInfo' of method 'setValues' must not be null";
        assert (valueInfo.getNumberOfValues() > 0) : "ValueInfo must not be empty";
        assert (this.getThresholdProvider() != null) : "ThresholdProvider must be set before calling 'setValues'";
        PiePlot plot = (PiePlot)this.getChart().getPlot();
        DefaultPieDataset result = new DefaultPieDataset();
        result.setValue((Comparable)((Object)ELEMENTS), (double)valueInfo.m_normalValues);
        result.setValue((Comparable)((Object)LOWER_VIOLATION), (double)valueInfo.m_lowerThresholdViolations);
        result.setValue((Comparable)((Object)UPPER_VIOLATION), (double)valueInfo.m_upperThresholdViolations);
        result.setValue((Comparable)((Object)LOWER_VIOLATION_ISSUE_IGNORED), (double)valueInfo.m_lowerIgnoredThresholdViolations);
        result.setValue((Comparable)((Object)UPPER_VIOLATION_ISSUE_IGNORED), (double)valueInfo.m_upperIgnoredThresholdViolations);
        result.setValue((Comparable)((Object)LOWER_VIOLATION_ISSUE_FILTERED_ELEMENTS), (double)valueInfo.m_lowerThresholdViolationsOfIssueFilteredElements);
        result.setValue((Comparable)((Object)UPPER_VIOLATION_ISSUE_FILTERED_ELEMENTS), (double)valueInfo.m_upperThresholdViolationsOfIssueFilteredElements);
        plot.setDataset((PieDataset)result);
    }

    @Override
    public boolean isEmpty() {
        PiePlot plot = (PiePlot)this.getChart().getPlot();
        return plot.getDataset() == null;
    }

    @Override
    public void clear() {
        PiePlot plot = (PiePlot)this.getChart().getPlot();
        plot.setDataset(null);
    }

    static final class ValuesContainer {
        private final int m_normalValues;
        private final int m_lowerThresholdViolations;
        private final int m_upperThresholdViolations;
        private final int m_lowerIgnoredThresholdViolations;
        private final int m_upperIgnoredThresholdViolations;
        private final int m_lowerThresholdViolationsOfIssueFilteredElements;
        private final int m_upperThresholdViolationsOfIssueFilteredElements;

        ValuesContainer(int normalValues, int lowerThresholdViolations, int upperThresholdViolations, int lowerIgnoredThresholdViolations, int upperIgnoredThresholdViolations, int lowerThresholdViolationsOfIssueFilteredElements, int upperThresholdViolationsOfIssueFilteredElements) {
            this.m_normalValues = normalValues;
            this.m_lowerThresholdViolations = lowerThresholdViolations;
            this.m_upperThresholdViolations = upperThresholdViolations;
            this.m_lowerIgnoredThresholdViolations = lowerIgnoredThresholdViolations;
            this.m_upperIgnoredThresholdViolations = upperIgnoredThresholdViolations;
            this.m_lowerThresholdViolationsOfIssueFilteredElements = lowerThresholdViolationsOfIssueFilteredElements;
            this.m_upperThresholdViolationsOfIssueFilteredElements = upperThresholdViolationsOfIssueFilteredElements;
        }

        public int getNumberOfValues() {
            return this.m_normalValues + this.m_lowerThresholdViolations + this.m_upperThresholdViolations + this.m_lowerIgnoredThresholdViolations + this.m_upperIgnoredThresholdViolations + this.m_lowerThresholdViolationsOfIssueFilteredElements + this.m_upperThresholdViolationsOfIssueFilteredElements;
        }
    }
}

