/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.metricsview;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.script.IScriptMetricId;
import com.hello2morrow.sonargraph.core.model.system.IThresholdProvider;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.CompositeImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.DecoratingImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.swt.graphics.Image;

final class MetricDescriptorBeanAdapter
extends BeanPropertyReader.BeanAdapter<IMetricDescriptor> {
    private final IMetricValueProvider m_valueProvider;
    private IThresholdProvider m_thresholdProvider;
    private IMetricDescriptor m_metricDescriptor;
    private NamedElement m_element;

    MetricDescriptorBeanAdapter(IMetricValueProvider valueProvider) {
        this.m_valueProvider = valueProvider;
    }

    void setThresholdProvider(IThresholdProvider thresholdProvider) {
        this.m_thresholdProvider = thresholdProvider;
    }

    void setElement(NamedElement element) {
        this.m_element = element;
    }

    protected void setAdaptedObject(IMetricDescriptor adaptedObject) {
        this.m_metricDescriptor = adaptedObject;
    }

    public Image getMetricImage() {
        if (this.m_metricDescriptor != null && this.m_thresholdProvider != null) {
            CompositeImageDescriptor descriptor = new CompositeImageDescriptor("Metric");
            if (this.m_element != null) {
                NamedElementIssue thresholdViolationIssue = this.m_thresholdProvider.getThresholdViolationIssue(this.m_metricDescriptor, this.m_element);
                if (thresholdViolationIssue != null && thresholdViolationIssue.getResolution() == null) {
                    descriptor.addMarker(DecoratingImageDescriptor.Corner.LOWER_RIGHT, "WarningMarker");
                }
            } else if (this.m_thresholdProvider.hasUnresolvedThresholdViolations(this.m_metricDescriptor)) {
                descriptor.addMarker(DecoratingImageDescriptor.Corner.LOWER_RIGHT, "WarningMarker");
            }
            return UiResourceManager.getInstance().getImage(descriptor);
        }
        return UiResourceManager.getInstance().getImage("Metric");
    }

    public String getName() {
        return this.m_metricDescriptor.getShortName();
    }

    public String getNameTooltip() {
        return this.m_metricDescriptor.getDescription();
    }

    public int getCategoryOrder() {
        return ((IMetricCategory)this.m_metricDescriptor.getMetricId().getCategories().get(0)).getOrderNumber();
    }

    public String getMainCategory() {
        return ((IMetricCategory)this.m_metricDescriptor.getMetricId().getCategories().get(0)).getPresentationName();
    }

    public String getCategories() {
        return StringUtility.concat((Collection)this.m_metricDescriptor.getMetricId().getCategories().stream().map(c -> c.getPresentationName()).collect(Collectors.toList()), (String)", ");
    }

    public String getCategoriesSort() {
        return this.getCategories() + "  " + this.getName();
    }

    public Number getLowerThreshold() {
        IMetricId metricId = this.m_metricDescriptor.getMetricId();
        if (metricId instanceof IScriptMetricId) {
            return ((IScriptMetricId)metricId).getLowerThreshold();
        }
        if (this.m_thresholdProvider == null) {
            return null;
        }
        IMetricThreshold threshold = this.m_thresholdProvider.getThreshold(this.m_metricDescriptor);
        return threshold != null ? (Number)threshold.getLowerThreshold() : (Number)null;
    }

    public Number getUpperThreshold() {
        IMetricId metricId = this.m_metricDescriptor.getMetricId();
        if (metricId instanceof IScriptMetricId) {
            return ((IScriptMetricId)metricId).getUpperThreshold();
        }
        if (this.m_thresholdProvider == null) {
            return null;
        }
        IMetricThreshold threshold = this.m_thresholdProvider.getThreshold(this.m_metricDescriptor);
        return threshold != null ? (Number)threshold.getUpperThreshold() : (Number)null;
    }

    public Number getValue() {
        assert (this.m_valueProvider != null) : "'m_valueProvider' of method 'getValue' must not be null";
        IMetricValue value = this.m_valueProvider.getValue(this.m_metricDescriptor);
        if (value != null) {
            return value.getValue();
        }
        return null;
    }

    public String getProvider() {
        return this.m_metricDescriptor.getMetricId().getProvider().getPresentationName();
    }

    public static interface IMetricValueProvider {
        public IMetricValue getValue(IMetricDescriptor var1);
    }
}

