/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.metricsview;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.text.TextUtilities;
import org.jfree.ui.TextAnchor;

final class HistogramXYBarRenderer
extends XYBarRenderer {
    private static final double MIN_HEIGHT = 5.0;

    HistogramXYBarRenderer() {
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int seriesIndex, int itemIndex, CrosshairState crosshairState, int pass) {
        String label;
        XYItemLabelGenerator generator;
        double value1;
        double value0;
        if (!this.getItemVisible(seriesIndex, itemIndex)) {
            return;
        }
        assert (dataset != null && dataset instanceof IntervalXYDataset) : "Unexpected class in method 'drawItem': " + String.valueOf(dataset);
        IntervalXYDataset intervalDataset = (IntervalXYDataset)dataset;
        if (this.getUseYInterval()) {
            value0 = intervalDataset.getStartYValue(seriesIndex, itemIndex);
            value1 = intervalDataset.getEndYValue(seriesIndex, itemIndex);
        } else {
            value0 = this.getBase();
            value1 = intervalDataset.getYValue(seriesIndex, itemIndex);
        }
        if (Double.isNaN(value0) || Double.isNaN(value1)) {
            return;
        }
        if (value0 <= value1 ? !rangeAxis.getRange().intersects(value0, value1) : !rangeAxis.getRange().intersects(value1, value0)) {
            return;
        }
        double translatedValue0 = rangeAxis.valueToJava2D(value0, dataArea, plot.getRangeAxisEdge());
        double translatedValue1 = rangeAxis.valueToJava2D(value1, dataArea, plot.getRangeAxisEdge());
        double bottom = Math.min(translatedValue0, translatedValue1);
        double top = Math.max(translatedValue0, translatedValue1);
        double startX = intervalDataset.getStartXValue(seriesIndex, itemIndex);
        if (Double.isNaN(startX)) {
            return;
        }
        double endX = intervalDataset.getEndXValue(seriesIndex, itemIndex);
        if (Double.isNaN(endX)) {
            return;
        }
        if (startX <= endX ? !domainAxis.getRange().intersects(startX, endX) : !domainAxis.getRange().intersects(endX, startX)) {
            return;
        }
        if (this.getBarAlignmentFactor() >= 0.0 && this.getBarAlignmentFactor() <= 1.0) {
            double x = intervalDataset.getXValue(seriesIndex, itemIndex);
            double interval = endX - startX;
            startX = x - interval * this.getBarAlignmentFactor();
            endX = startX + interval;
        }
        RectangleEdge location = plot.getDomainAxisEdge();
        double translatedStartX = domainAxis.valueToJava2D(startX, dataArea, location);
        double translatedEndX = domainAxis.valueToJava2D(endX, dataArea, location);
        double translatedWidth = Math.max(1.0, Math.abs(translatedEndX - translatedStartX));
        double left = Math.min(translatedStartX, translatedEndX);
        if (this.getMargin() > 0.0) {
            double cut = translatedWidth * this.getMargin();
            translatedWidth -= cut;
            left += cut / 2.0;
        }
        Rectangle2D.Double bar = null;
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            bottom = Math.max(bottom, dataArea.getMinX());
            top = Math.min(top, dataArea.getMaxX());
            bar = new Rectangle2D.Double(bottom, left, top - bottom, translatedWidth);
        } else if (orientation == PlotOrientation.VERTICAL) {
            bottom = Math.max(bottom, dataArea.getMinY());
            double height = (top = Math.min(top, dataArea.getMaxY())) - bottom;
            if (height < 5.0 && height > 0.0) {
                double oldHeight = height;
                height = 5.0;
                bottom -= 5.0 - oldHeight;
            }
            bar = new Rectangle2D.Double(left, bottom, translatedWidth, height);
        }
        boolean positive = value1 > 0.0;
        boolean inverted = rangeAxis.isInverted();
        RectangleEdge barBase = orientation == PlotOrientation.HORIZONTAL ? (positive && inverted || !positive && !inverted ? RectangleEdge.RIGHT : RectangleEdge.LEFT) : (positive && !inverted || !positive && inverted ? RectangleEdge.BOTTOM : RectangleEdge.TOP);
        if (this.getShadowsVisible()) {
            this.getBarPainter().paintBarShadow(g2, (XYBarRenderer)this, seriesIndex, itemIndex, (RectangularShape)bar, barBase, !this.getUseYInterval());
        }
        this.getBarPainter().paintBar(g2, (XYBarRenderer)this, seriesIndex, itemIndex, (RectangularShape)bar, barBase);
        if (this.isItemLabelVisible(seriesIndex, itemIndex) && (generator = this.getItemLabelGenerator(seriesIndex, itemIndex)) != null && (label = generator.generateLabel(dataset, seriesIndex, itemIndex)) != null) {
            Font labelFont = this.getItemLabelFont(seriesIndex, itemIndex);
            g2.setFont(labelFont);
            Paint paint = this.getItemLabelPaint(seriesIndex, itemIndex);
            g2.setPaint(paint);
            TextUtilities.drawAlignedString((String)label, (Graphics2D)g2, (float)Math.round(((RectangularShape)bar).getX()), (float)Math.round(((RectangularShape)bar).getY() - this.getItemLabelAnchorOffset()), (TextAnchor)TextAnchor.BASELINE_LEFT);
        }
        double x1 = (startX + endX) / 2.0;
        double y1 = dataset.getYValue(seriesIndex, itemIndex);
        double transX1 = domainAxis.valueToJava2D(x1, dataArea, location);
        double transY1 = rangeAxis.valueToJava2D(y1, dataArea, plot.getRangeAxisEdge());
        int domainAxisIndex = plot.getDomainAxisIndex(domainAxis);
        this.updateCrosshairValues(crosshairState, x1, y1, domainAxisIndex, transX1, transY1, plot.getOrientation());
        EntityCollection entities = state.getEntityCollection();
        if (entities != null) {
            this.addEntity(entities, bar, dataset, seriesIndex, itemIndex, 0.0, 0.0);
        }
    }
}

