/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.metricsview;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.ui.standalone.metricsview.Chart;
import com.hello2morrow.sonargraph.ui.standalone.metricsview.HistogramXYBarRenderer;
import com.hello2morrow.sonargraph.ui.standalone.metricsview.SimpleHistogramDataSet;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.statistics.HistogramBin;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.swt.SWTUtils;

final class Histogram
extends Chart
implements XYToolTipGenerator {
    private static final String LABEL_Y_AXIS = "Number of elements in range";
    private static final String LABEL_X_AXIS = "Metric value";
    private static final int NUMBER_OF_BINS = 7;
    private final XYItemLabelGenerator m_labelGenerator = new StandardXYItemLabelGenerator();
    private IMetricDescriptor m_currentMetricDescriptor;

    Histogram(Composite parent) {
        super(parent, ChartFactory.createHistogram(null, (String)LABEL_X_AXIS, (String)LABEL_Y_AXIS, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false));
        XYPlot plot = this.getChart().getXYPlot();
        plot.setNoDataMessage("n/a");
        plot.setNoDataMessagePaint((Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getForegroundColor()));
        plot.setBackgroundPaint(null);
        plot.setOutlinePaint((Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getForegroundColor()));
        plot.setRangeGridlinePaint((Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getForegroundColor()));
        HistogramXYBarRenderer renderer = new HistogramXYBarRenderer();
        renderer.setItemLabelAnchorOffset(5.0);
        renderer.setDrawBarOutline(false);
        renderer.setShadowVisible(false);
        renderer.setMargin(0.1);
        renderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        renderer.setDefaultLegendTextPaint(SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getForegroundColor()));
        renderer.setDefaultToolTipGenerator(this);
        plot.getDomainAxis().setLabelPaint((Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getForegroundColor()));
        plot.getRangeAxis().setLabelPaint((Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getForegroundColor()));
        plot.getDomainAxis().setTickMarkPaint((Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getForegroundColor()));
        plot.getRangeAxis().setTickMarkPaint((Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getForegroundColor()));
        plot.getDomainAxis().setTickLabelPaint((Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getForegroundColor()));
        plot.getRangeAxis().setTickLabelPaint((Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getForegroundColor()));
        plot.setRenderer((XYItemRenderer)renderer);
    }

    public XYItemLabelGenerator getItemLabelGenerator(int series, int item) {
        return this.m_labelGenerator;
    }

    @Override
    protected String getType() {
        return "Histogram";
    }

    public String generateToolTip(XYDataset dataset, int series, int item) {
        String to;
        String from;
        assert (dataset != null && dataset instanceof SimpleHistogramDataSet) : "Unexpected class in method 'generateToolTip': " + String.valueOf(dataset);
        if (this.m_currentMetricDescriptor == null) {
            return null;
        }
        SimpleHistogramDataSet histogramDataset = (SimpleHistogramDataSet)dataset;
        if (this.m_currentMetricDescriptor.isFloat()) {
            from = NumberUtility.format((Number)histogramDataset.getStartX(series, item).doubleValue(), (boolean)true);
            to = NumberUtility.format((Number)histogramDataset.getEndX(series, item).doubleValue(), (boolean)true);
        } else {
            from = String.valueOf(histogramDataset.getStartX(series, item).intValue());
            to = String.valueOf(histogramDataset.getEndX(series, item).intValue());
        }
        return "[" + from + " - " + to + "]: " + (int)histogramDataset.getYValue(series, item) + " element(s)";
    }

    private void reset(XYPlot plot) {
        assert (plot != null) : "Parameter 'plot' of method 'reset' must not be null";
        this.m_currentMetricDescriptor = null;
        plot.setNoDataMessage("n/a");
        plot.clearDomainMarkers();
        plot.setDataset(null);
        plot.getDomainAxis().setRange(0.0, 10.0);
        plot.getDomainAxis().setLabel(LABEL_X_AXIS);
        plot.getRangeAxis().setRange(0.0, 10.0);
        plot.getRangeAxis().setLabel(LABEL_Y_AXIS);
    }

    @Override
    protected void clear() {
        this.reset(this.getChart().getXYPlot());
    }

    @Override
    protected boolean isEmpty() {
        return this.getChart().getXYPlot().getDataset() == null;
    }

    private SplitBinResult splitBinIfNecessary(ValueRange currentValueRange, double currentStartBoundary, double nextEndBoundary, double lowerThresholdAsDouble, double upperThresholdAsDouble, List<HistogramBin> bins, boolean isFloat) {
        assert (currentValueRange != null) : "Parameter 'currentValueRange' of method 'splitBinIfNecessary' must not be null";
        switch (currentValueRange) {
            case LESS_THAN_LOWER_THRESHOLD: {
                if (!(nextEndBoundary >= lowerThresholdAsDouble) || !(currentStartBoundary < lowerThresholdAsDouble)) break;
                bins.add(new HistogramBin(currentStartBoundary, Math.max(currentStartBoundary, lowerThresholdAsDouble - (isFloat ? 1.0E-6 : 1.0))));
                return new SplitBinResult(lowerThresholdAsDouble, ValueRange.INBETWEEN_LOWER_AND_UPPER_THRESHOLD);
            }
            case INBETWEEN_LOWER_AND_UPPER_THRESHOLD: {
                if (!(nextEndBoundary > upperThresholdAsDouble) || !(currentStartBoundary <= upperThresholdAsDouble)) break;
                bins.add(new HistogramBin(currentStartBoundary, upperThresholdAsDouble));
                return new SplitBinResult(upperThresholdAsDouble, ValueRange.GREATER_THAN_UPPER_THRESHOLD);
            }
            case GREATER_THAN_UPPER_THRESHOLD: {
                break;
            }
            default: {
                assert (false) : "Unhandled value range: " + String.valueOf((Object)currentValueRange);
                break;
            }
        }
        return null;
    }

    private SimpleHistogramDataSet createDataSet(List<Number> metrics, double seriesMinValue, double seriesMaxValue, Number lowerThreshold, Number upperThreshold, boolean isFloat) {
        assert (metrics != null && !metrics.isEmpty()) : "Parameter 'metrics' of method 'createDataSet' must not be empty";
        double lowerThresholdAsDouble = lowerThreshold != null ? lowerThreshold.doubleValue() : -1.7976931348623157E308;
        double upperThresholdAsDouble = upperThreshold != null ? upperThreshold.doubleValue() : Double.MAX_VALUE;
        ArrayList<HistogramBin> bins = new ArrayList<HistogramBin>();
        double binWidth = (seriesMaxValue - seriesMinValue) / 7.0;
        double firstValueAsDouble = metrics.get(0).doubleValue();
        ValueRange currentValueRange = firstValueAsDouble < lowerThresholdAsDouble ? ValueRange.LESS_THAN_LOWER_THRESHOLD : (firstValueAsDouble <= upperThresholdAsDouble ? ValueRange.INBETWEEN_LOWER_AND_UPPER_THRESHOLD : ValueRange.GREATER_THAN_UPPER_THRESHOLD);
        double currentStartBoundary = seriesMinValue;
        int i = 0;
        while (i < 7) {
            double nextEndBoundary = currentStartBoundary + binWidth;
            SplitBinResult splitBinResult = this.splitBinIfNecessary(currentValueRange, currentStartBoundary, nextEndBoundary, lowerThresholdAsDouble, upperThresholdAsDouble, bins, isFloat);
            if (splitBinResult != null) {
                currentStartBoundary = splitBinResult.getStartBoundary();
                currentValueRange = splitBinResult.getValueRange();
            }
            if ((splitBinResult = this.splitBinIfNecessary(currentValueRange, currentStartBoundary, nextEndBoundary, lowerThresholdAsDouble, upperThresholdAsDouble, bins, isFloat)) != null) {
                currentStartBoundary = splitBinResult.getStartBoundary();
                currentValueRange = splitBinResult.getValueRange();
            }
            bins.add(new HistogramBin(currentStartBoundary, i == 6 ? seriesMaxValue : nextEndBoundary));
            currentStartBoundary = nextEndBoundary;
            ++i;
        }
        int currentBinIndex = 0;
        HistogramBin currentBin = (HistogramBin)bins.get(currentBinIndex);
        for (Number nextMetric : metrics) {
            double nextMetricAsDouble = nextMetric.doubleValue();
            while (nextMetricAsDouble > currentBin.getEndBoundary()) {
                currentBin = (HistogramBin)bins.get(++currentBinIndex);
            }
            assert (currentBin != null) : "'currentBin' of method 'createDataSet' must not be null";
            currentBin.incrementCount();
        }
        return new SimpleHistogramDataSet(bins);
    }

    void setValues(IMetricDescriptor metricDescriptor, List<IMetricValue> metricValues) {
        ValueMarker marker;
        Number upperThreshold;
        Number lowerThreshold;
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'setValues' must not be null";
        assert (metricValues != null) : "Parameter 'metricValues' of method 'setValues' must not be null";
        assert (this.getThresholdProvider() != null) : "ThresholdProvider must be set before calling 'setValues'";
        List<Number> sortedMetricValues = metricValues.stream().filter(IMetricValue::isValid).map(IMetricValue::getValue).sorted().collect(Collectors.toList());
        XYPlot plot = this.getChart().getXYPlot();
        this.reset(plot);
        if (sortedMetricValues.size() < 5) {
            this.clear();
            return;
        }
        this.m_currentMetricDescriptor = metricDescriptor;
        double minValue = ((Number)sortedMetricValues.get(0)).doubleValue();
        double maxValue = ((Number)sortedMetricValues.get(sortedMetricValues.size() - 1)).doubleValue();
        assert (maxValue >= minValue) : "maxValue >= minValue " + String.valueOf(sortedMetricValues);
        IMetricThreshold threshold = this.getThresholdProvider().getThreshold(metricDescriptor);
        if (threshold != null) {
            lowerThreshold = threshold.getLowerThreshold();
            upperThreshold = threshold.getUpperThreshold();
        } else {
            upperThreshold = null;
            lowerThreshold = null;
        }
        double domainAxisMinValue = 0.0;
        double domainAxisMaxValue = 0.0;
        double seriesMinValue = 0.0;
        double seriesMaxValue = 0.0;
        boolean domainAxisMinValueIsThreshold = false;
        if (lowerThreshold != null && lowerThreshold.doubleValue() < minValue) {
            domainAxisMinValue = seriesMinValue = lowerThreshold.doubleValue();
            domainAxisMinValueIsThreshold = true;
        } else {
            domainAxisMinValue = seriesMinValue = minValue;
        }
        boolean domainAxisMaxValueIsThreshold = false;
        if (upperThreshold != null && upperThreshold.doubleValue() > maxValue) {
            domainAxisMaxValue = seriesMaxValue = upperThreshold.doubleValue();
            domainAxisMaxValueIsThreshold = true;
        } else {
            domainAxisMaxValue = seriesMaxValue = maxValue;
        }
        assert (domainAxisMaxValue >= domainAxisMinValue) : "seriesMaxValue >= seriesMinValue";
        if (domainAxisMinValueIsThreshold || domainAxisMaxValueIsThreshold) {
            double offset;
            double d = offset = domainAxisMinValue == domainAxisMaxValue ? 0.1 : (domainAxisMaxValue - domainAxisMinValue) * 0.015;
            if (domainAxisMinValueIsThreshold) {
                domainAxisMinValue -= offset;
            }
            if (domainAxisMaxValueIsThreshold) {
                domainAxisMaxValue += offset;
            }
        }
        if (domainAxisMinValue == domainAxisMaxValue) {
            domainAxisMinValue -= 0.5;
            domainAxisMaxValue += 0.5;
            seriesMinValue = minValue - 0.1;
            seriesMaxValue = maxValue + 0.1;
        }
        plot.getDomainAxis().setLabel(metricDescriptor.getPresentationName());
        plot.getDomainAxis().setRange(domainAxisMinValue, domainAxisMaxValue);
        plot.getRangeAxis().setAutoRange(true);
        plot.setDataset((XYDataset)this.createDataSet(sortedMetricValues, seriesMinValue, seriesMaxValue, lowerThreshold, upperThreshold, this.m_currentMetricDescriptor.isFloat()));
        XYItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesItemLabelGenerator(0, this.m_labelGenerator);
        renderer.setSeriesPaint(0, (Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_BLUE)));
        renderer.setSeriesItemLabelsVisible(0, Boolean.TRUE);
        if (lowerThreshold != null) {
            marker = new ValueMarker(lowerThreshold.doubleValue());
            marker.setPaint((Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getColor(UiResourceManager.DARK_RED)));
            marker.setStroke((Stroke)new BasicStroke(2.0f));
            plot.addDomainMarker((Marker)marker);
        }
        if (upperThreshold != null) {
            marker = new ValueMarker(upperThreshold.doubleValue());
            marker.setPaint((Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getColor(UiResourceManager.RED)));
            marker.setStroke((Stroke)new BasicStroke(2.0f));
            plot.addDomainMarker((Marker)marker);
        }
    }

    static final class SplitBinResult {
        private final double m_startBoundary;
        private final ValueRange m_valueRange;

        SplitBinResult(double startBoundary, ValueRange valueRange) {
            assert (valueRange != null) : "Parameter 'valueRange' of method 'SplitBinResult' must not be null";
            this.m_startBoundary = startBoundary;
            this.m_valueRange = valueRange;
        }

        double getStartBoundary() {
            return this.m_startBoundary;
        }

        ValueRange getValueRange() {
            return this.m_valueRange;
        }
    }

    static enum ValueRange {
        LESS_THAN_LOWER_THRESHOLD,
        INBETWEEN_LOWER_AND_UPPER_THRESHOLD,
        GREATER_THAN_UPPER_THRESHOLD;

    }
}

