/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.metricsview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.RequestMetricValuesCommand;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IOriginator;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IResolution;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzersStartedEvent;
import com.hello2morrow.sonargraph.core.model.event.MetricValuesAvailableEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.metrics.ThresholdViolationIssue;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.IThresholdProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.ui.standalone.metricsview.MetricDescriptorBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.AbstractHorizontalSeparator;
import com.hello2morrow.sonargraph.ui.swt.base.HorizontalSeparator;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewerBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class ElementMetricsView
extends WorkbenchView
implements IOriginator,
MetricDescriptorBeanAdapter.IMetricValueProvider,
ISelectionChangedListener,
AbstractHorizontalSeparator.ILayoutListener {
    private static final String NO_SYSTEM_OPENED = "No System Opened";
    private static final String ELEMENT_HAS_NO_METRICS = "Element Has No Metrics";
    private static final String VALUE_PROPERTY = "value";
    private final MetricDescriptorBeanAdapter m_metricDescriptorBeanAdapter = new MetricDescriptorBeanAdapter(this);
    private final Map<IMetricDescriptor, IMetricValue> m_elementMetrics = new THashMap();
    private HorizontalSeparator m_elementSeparator;
    private PropertyTableViewer<IMetricDescriptor> m_elementMetricsViewer;
    private PropertyTableViewerBasedTextSearchHandler m_elementMetricsViewerTextSearchHandler;
    private NamedElement m_displayingMetricsOf;

    public IViewId getViewId() {
        return ViewId.ELEMENT_METRICS_VIEW;
    }

    protected EnumSet<WorkbenchView.EventCategory> getDisabledEventCategories() {
        return EnumSet.of(WorkbenchView.EventCategory.INSTALLATION);
    }

    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        Composite composite = new Composite(viewContentArea, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.m_elementSeparator = new HorizontalSeparator(composite, NO_SYSTEM_OPENED);
        this.m_elementSeparator.setLayoutData((Object)new GridData(4, 0, true, false));
        this.m_elementMetricsViewer = new PropertyTableViewer(composite, (BeanPropertyReader.BeanAdapter)this.m_metricDescriptorBeanAdapter, "categoriesSort", true, PropertyTableViewer.SelectionType.SINGLE_FULL_LINE);
        this.m_elementMetricsViewer.addColumn("Metric", "name", "name", "metricImage", 40, PropertyTableViewer.ColumnType.TEXT);
        this.m_elementMetricsViewer.addColumn("Categories", "categories", "categoriesSort", null, 18, PropertyTableViewer.ColumnType.TEXT);
        this.m_elementMetricsViewer.addColumn("Provider", "provider", "provider", null, 18, PropertyTableViewer.ColumnType.TEXT);
        this.m_elementMetricsViewer.addColumn("Min", "lowerThreshold", "lowerThreshold", null, 8, PropertyTableViewer.ColumnType.NUMBER);
        this.m_elementMetricsViewer.addColumn("Max", "upperThreshold", "upperThreshold", null, 8, PropertyTableViewer.ColumnType.NUMBER);
        this.m_elementMetricsViewer.addColumn("Value", VALUE_PROPERTY, VALUE_PROPERTY, null, 8, PropertyTableViewer.ColumnType.NUMBER);
        this.m_elementMetricsViewer.addColumnValueMapper(VALUE_PROPERTY, null, "n/a");
        this.m_elementMetricsViewer.addSortProperty("mainCategory", true, false);
        this.m_elementMetricsViewer.addSortProperty("metricName", true, false);
        this.m_elementMetricsViewer.setCellImageProvider((PropertyTableViewer.ICellImageProvider)new PropertyTableViewer.ICellImageProvider<IMetricDescriptor>(){

            public Image getCellImage(PropertyTableViewer<IMetricDescriptor> viewer, IMetricDescriptor metricDescriptor, String propertyName, Image columnImage) {
                if (ElementMetricsView.VALUE_PROPERTY.equals(propertyName)) {
                    IMetricValue value;
                    if (ElementMetricsView.this.m_displayingMetricsOf != null && ElementMetricsView.this.getSoftwareSystem() != null && (value = ElementMetricsView.this.m_elementMetrics.get(metricDescriptor)) != null) {
                        List thresholdViolations = ElementMetricsView.this.m_displayingMetricsOf.getIssues(new IIssueId[]{CoreIssueId.THRESHOLD_VIOLATION});
                        ThresholdViolationIssue found = null;
                        for (Issue issue : thresholdViolations) {
                            ThresholdViolationIssue thv = (ThresholdViolationIssue)issue;
                            if (thv.getThreshold().getMetricDescriptor() != value.getMetricDescriptor()) continue;
                            found = thv;
                            break;
                        }
                        if (found != null) {
                            IResolution resolution = found.getResolution();
                            if (resolution == null) {
                                return UiResourceManager.getInstance().getImage(found.getImageResourceName());
                            }
                            return UiResourceManager.getInstance().getImage(resolution.getImageResourceName());
                        }
                    }
                    return null;
                }
                return null;
            }
        });
        this.m_elementMetricsViewer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_elementMetricsViewerTextSearchHandler = new PropertyTableViewerBasedTextSearchHandler(this.m_elementMetricsViewer, this.getViewId().getPresentationName());
        this.showMetrics(this.getSelectionProviderAdapter().getCurrentSelection());
        EventManager.getInstance().attach((EventHandler)new EventHandler<MetricValuesAvailableEvent>(MetricValuesAvailableEvent.class, (Object)this){

            public void handleEvent(MetricValuesAvailableEvent event) {
                if (ElementMetricsView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOriginator() == ElementMetricsView.this) {
                    ElementMetricsView.this.handleMetricValuesAvailableEvent(event);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzersStartedEvent>(AnalyzersStartedEvent.class, (Object)this){

            public void handleEvent(AnalyzersStartedEvent event) {
                if (ElementMetricsView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    ElementMetricsView.this.showMetrics(ElementMetricsView.this.getSelectionProviderAdapter().getCurrentSelection());
                }
            }
        });
        this.m_elementSeparator.setLayoutListener((AbstractHorizontalSeparator.ILayoutListener)this);
        this.m_elementMetricsViewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void destroyViewContent() {
        EventManager.getInstance().detach(MetricValuesAvailableEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzersStartedEvent.class, (Object)this);
        super.destroyViewContent();
    }

    public List<Control> getControlsForInteraction() {
        return Collections.singletonList(this.m_elementMetricsViewer.getTable());
    }

    public Search supportsSearch() {
        return Search.FIND_TEXT;
    }

    protected ITextSearchHandler getTextSearchHandler() {
        return this.m_elementMetricsViewerTextSearchHandler;
    }

    @Override
    public IMetricValue getValue(IMetricDescriptor metricDescriptor) {
        return this.m_elementMetrics.get(metricDescriptor);
    }

    private void showMetrics(List<Element> elements) {
        Set metricDescriptors;
        SoftwareSystem element;
        assert (elements != null) : "Parameter 'elements' of method 'showMetrics' must not be null";
        this.m_elementMetricsViewer.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_displayingMetricsOf = null;
        this.m_elementMetrics.clear();
        SoftwareSystem system = this.getSoftwareSystem();
        Object object = element = !elements.isEmpty() ? elements.get(0) : system;
        if (element != null) {
            IMetricsProvider metricsProvider = (IMetricsProvider)this.getSoftwareSystemProvider().getInstallation().getExtension(IMetricsProvider.class);
            StrictPair result = metricsProvider.getMetricDescriptorsForElement((Element)element);
            if (result != null) {
                this.m_displayingMetricsOf = (NamedElement)result.getFirst();
                metricDescriptors = (Set)result.getSecond();
            } else {
                metricDescriptors = Collections.emptySet();
            }
        } else {
            metricDescriptors = Collections.emptySet();
        }
        if (metricDescriptors.isEmpty()) {
            if (system == null) {
                this.m_elementSeparator.set(NO_SYSTEM_OPENED, null);
            } else {
                this.m_elementSeparator.set(ELEMENT_HAS_NO_METRICS, null);
            }
            this.m_metricDescriptorBeanAdapter.setElement(null);
            this.m_elementMetricsViewer.showData(null);
        } else {
            metricDescriptors.forEach(d -> {
                Object v0 = this.m_elementMetrics.put((IMetricDescriptor)d, (IMetricValue)null);
            });
            this.m_elementSeparator.set(this.m_displayingMetricsOf.getPresentationName(false), UiResourceManager.getInstance().getImage((Element)this.m_displayingMetricsOf));
            this.m_metricDescriptorBeanAdapter.setElement(this.m_displayingMetricsOf);
            this.m_elementMetricsViewer.showData(this.m_elementMetrics.keySet());
            UserInterfaceAdapter.getInstance().run((Command)new RequestMetricValuesCommand(this.getSoftwareSystemProvider(), metricDescriptors, this.m_displayingMetricsOf, true, (IOriginator)this));
        }
        this.m_elementMetricsViewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void handleMetricValuesAvailableEvent(MetricValuesAvailableEvent event) {
        assert (event != null) : "Parameter 'event' of method 'handleMetricValuesAvailableEvent' must not be null";
        boolean metricsChanged = false;
        for (IMetricDescriptor nextMetricDescriptor : event.getMetricDescriptors()) {
            List nextMetricValues;
            if (!this.m_elementMetrics.containsKey(nextMetricDescriptor) || (nextMetricValues = event.getMetricValues(nextMetricDescriptor)).isEmpty()) continue;
            Optional val = nextMetricValues.stream().findFirst();
            this.m_elementMetrics.put(nextMetricDescriptor, val.isPresent() ? (IMetricValue)val.get() : null);
            metricsChanged = true;
        }
        if (metricsChanged) {
            this.m_elementMetricsViewer.showData(this.m_elementMetrics.keySet());
        }
    }

    protected void softwareSystemShow(WorkbenchView.ShowMode mode) {
        this.m_metricDescriptorBeanAdapter.setThresholdProvider((IThresholdProvider)this.getSoftwareSystem().getExtension(IThresholdProvider.class));
        this.showMetrics(this.getSelectionProviderAdapter().getCurrentSelection());
        super.softwareSystemShow(mode);
    }

    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        assert (modification != null) : "Parameter 'modification' of method 'softwareSystemModified' must not be null";
        this.showMetrics(this.getSelectionProviderAdapter().getCurrentSelection());
        super.softwareSystemModified(modification, restoredFromHistory);
    }

    protected void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        assert (modification != null) : "Parameter 'modification' of method 'analyzerModification' must not be null";
        if (modification.contains(AnalyzerModificationEvent.AnalyzerModification.METRIC_DESCRIPTOR_ADDED)) {
            this.showMetrics(this.getSelectionProviderAdapter().getCurrentSelection());
        } else if (modification.contains(AnalyzerModificationEvent.AnalyzerModification.METRIC_VALUE_ADDED) && !this.m_elementMetrics.isEmpty()) {
            UserInterfaceAdapter.getInstance().run((Command)new RequestMetricValuesCommand(this.getSoftwareSystemProvider(), this.m_elementMetrics.keySet(), this.m_displayingMetricsOf, true, (IOriginator)this));
        }
        super.analyzerModification(modification, analyzerId);
    }

    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.m_elementMetricsViewer.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_metricDescriptorBeanAdapter.setElement(null);
        this.m_displayingMetricsOf = null;
        this.m_elementSeparator.reset();
        this.m_elementMetrics.clear();
        this.m_elementMetricsViewer.showData(null);
        this.m_metricDescriptorBeanAdapter.setThresholdProvider(null);
        this.m_elementMetricsViewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void performViewSelectionChanged(IWorkbenchView view, List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'selectionChanged' must not be null";
        this.showMetrics(elements);
    }

    public List<Element> getSelectedElements() {
        assert (this.m_elementMetricsViewer != null) : "Parameter 'm_elementMetricsViewer' of method 'getSelectedElements' must not be null";
        IStructuredSelection selection = this.m_elementMetricsViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return this.m_displayingMetricsOf != null ? Collections.singletonList(this.m_displayingMetricsOf) : Collections.emptyList();
        }
        ArrayList<Element> selected = new ArrayList<Element>();
        for (Object next : selection.toList()) {
            if (next instanceof IMetricDescriptor) {
                IMetricValue nextMetricValue = this.m_elementMetrics.get(next);
                if (nextMetricValue == null) continue;
                selected.add((Element)nextMetricValue.getElement());
                continue;
            }
            selected.add((Element)next);
        }
        return selected;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        this.getSelectionProviderAdapter().handleSelectionChanged(this.getSelectedElements());
    }

    public void layoutAdapted() {
        if (this.isActive()) {
            this.getContentArea().layout(true, true);
        }
    }
}

