/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.metricsview;

import com.hello2morrow.sonargraph.core.model.system.IThresholdProvider;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import de.schlichtherle.truezip.file.TFile;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.jfree.experimental.swt.SWTUtils;

abstract class Chart
extends ChartComposite {
    private IThresholdProvider m_thresholdProvider;

    protected Chart(Composite parent, JFreeChart jFreeChart) {
        super(parent, 0, jFreeChart, false, false, false, false, true);
        assert (jFreeChart != null) : "Parameter 'jFreeChart' of method 'Chart' must not be null";
        jFreeChart.setAntiAlias(true);
        jFreeChart.setTextAntiAlias(true);
        jFreeChart.setBackgroundPaint((Paint)SWTUtils.toAwtColor((Color)UiResourceManager.getInstance().getBackgroundColor()));
        this.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.getCanvas().setBackground(UiResourceManager.getInstance().getBackgroundColor());
    }

    protected abstract String getType();

    protected abstract void clear();

    protected abstract boolean isEmpty();

    public final void exportToImage(TFile file) throws IOException {
        assert (file != null) : "Parameter 'file' of method 'exportToImage' must not be null";
        Canvas canvas = this.getCanvas();
        ChartUtils.saveChartAsPNG((File)file, (JFreeChart)this.getChart(), (int)canvas.getSize().x, (int)canvas.getSize().y);
    }

    public String getToolTipText(MouseEvent e) {
        EntityCollection entities;
        String result = null;
        ChartRenderingInfo info = this.getChartRenderingInfo();
        if (info != null && (entities = info.getEntityCollection()) != null) {
            Rectangle insets = this.getClientArea();
            double x = e.x - insets.x;
            double y = e.y - insets.y;
            ChartEntity entity = entities.getEntity(x, y);
            if (entity != null) {
                result = entity.getToolTipText();
            }
        }
        return result;
    }

    final Canvas getCanvas() {
        Control[] children = this.getChildren();
        assert (children.length == 1) : "Unexpected number of children: " + children.length;
        assert (children[0] instanceof Canvas) : "Unexpected class of child: " + children[0].getClass().getCanonicalName();
        return (Canvas)children[0];
    }

    final void setThresholdProvider(IThresholdProvider thresholdProvider) {
        this.m_thresholdProvider = thresholdProvider;
    }

    final IThresholdProvider getThresholdProvider() {
        return this.m_thresholdProvider;
    }
}

