/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.issuesview;

import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.DependencyIssue;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementGroup;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.IIssueAffectedElementType;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.IHierarchicalIssueProvider;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.IssueCountInfo;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.IssueNamedElement;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.IssueRootElement;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.NamedElementIssueTree;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IDefinedInSystemDefinitionFile;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.export.IExportProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.export.ExportData;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.CategoryProvider;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.IViewWithTextFilterWidget;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.NamedElementViewComparator;
import com.hello2morrow.sonargraph.ui.standalone.base.view.PresentationModeBasedViewContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.issuesview.HierarchicalIssueContentProvider;
import com.hello2morrow.sonargraph.ui.standalone.issuesview.IssueBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.issuesview.IssuesFilterDialog;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.BaseTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewWithTree;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.view.TreeBasedViewNavigationStateUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PagingPropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewerBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.TreeBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class IssuesView
extends WorkbenchSlaveView
implements ISelectionChangedListener,
ITreeViewerListener,
IViewWithTree,
IViewWithTextFilterWidget {
    private static final int TREE_EXPANSION_LEVEL = 3;
    private static final Predicate<Issue> IGNORE_RESOLUTIONS_CONDITION = issue -> issue.getResolution(Resolution.class) != null;
    private final Set<IIssueId> m_availableIds = new THashSet();
    private final Set<IProviderId> m_availableProviderIds = new THashSet();
    private final IssueBeanAdapter m_issueBeanAdapter = new IssueBeanAdapter();
    private final HierarchicalIssueContentProvider m_treeViewerContentProvider = new HierarchicalIssueContentProvider();
    private IssueFilter m_filter = new IssueFilter(new IStandardEnumeration[0]);
    private TreeViewer m_treeViewer;
    private PagingPropertyTableViewer<Issue> m_issuesViewer;
    private PresentationMode m_presentationMode;
    private BaseTextSearchHandler m_textSearchProvider;
    private ViewComponent m_selectedViewComponent = ViewComponent.TREE;

    public IssuesView() {
        this.m_filter.addIgnore(IGNORE_RESOLUTIONS_CONDITION);
    }

    public IViewId getViewId() {
        return ViewId.ISSUES_VIEW;
    }

    @Override
    public boolean isFilterWidgetShown() {
        return this.m_issuesViewer != null && !this.m_issuesViewer.isDisposed() && this.m_issuesViewer.isTextFilterShown();
    }

    @Override
    public final void showFilterWidget(boolean show) {
        if (show) {
            this.m_issuesViewer.showTextFilter();
        } else {
            this.m_issuesViewer.hideTextFilter();
        }
    }

    private void loadSettings() {
        IEclipsePreferences settings = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone", (IDialogId)this.getViewId());
        assert (settings != null) : "'settings' of method 'loadSettings' must not be null";
        assert (this.m_filter != null) : "'m_filter' of method 'loadSettings' must not be null";
        for (Severity severity : IssuesFilterDialog.getSeveritiesForFilter()) {
            if (severity == Severity.ERROR || severity == Severity.WARNING) {
                if (!settings.getBoolean(severity.getStandardName(), true)) continue;
                this.m_filter.add((IStandardEnumeration)severity);
                continue;
            }
            if (!settings.getBoolean(severity.getStandardName(), false)) continue;
            this.m_filter.add((IStandardEnumeration)severity);
        }
        for (IssueCategory issueCategory : IssuesFilterDialog.getCategoriesForFilter()) {
            if (!settings.getBoolean(issueCategory.getStandardName(), true)) continue;
            this.m_filter.add((IStandardEnumeration)issueCategory);
        }
        for (IProviderId iProviderId : IssuesFilterDialog.getProviderIdsForFilter(this.getSoftwareSystemProvider())) {
            if (!settings.getBoolean(iProviderId.getStandardName(), true)) continue;
            this.m_filter.add((IStandardEnumeration)iProviderId);
        }
        for (IIssueId iIssueId : IssuesFilterDialog.getIssueIdsForFilter(this.getSoftwareSystemProvider())) {
            if (!settings.getBoolean(iIssueId.getStandardName(), true)) continue;
            this.m_filter.add((IStandardEnumeration)iIssueId);
        }
        for (IIssueAffectedElementType iIssueAffectedElementType : IssuesFilterDialog.getAffectedElementTypesForFilter()) {
            if (!settings.getBoolean(iIssueAffectedElementType.getStandardName(), true)) continue;
            this.m_filter.add((IStandardEnumeration)iIssueAffectedElementType);
        }
        String string = settings.get(Settings.PRESENTATION_MODE.getStandardName(), PresentationMode.MIXED.getStandardName());
        try {
            this.m_presentationMode = PresentationMode.fromStandardName((String)string);
        }
        catch (IllegalArgumentException e) {
            this.m_presentationMode = PresentationMode.MIXED;
        }
        this.m_treeViewerContentProvider.setPresentationMode(this.m_presentationMode);
    }

    private void saveSettings() {
        IEclipsePreferences settings = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone", (IDialogId)this.getViewId());
        assert (settings != null) : "'settings' of method 'saveSettings' must not be null";
        assert (this.m_filter != null) : "'m_filter' of method 'saveSettings' must not be null";
        for (Severity severity : IssuesFilterDialog.getSeveritiesForFilter()) {
            settings.putBoolean(severity.getStandardName(), this.m_filter.containsFilter((IStandardEnumeration)severity));
        }
        for (IssueCategory issueCategory : IssuesFilterDialog.getCategoriesForFilter()) {
            settings.putBoolean(issueCategory.getStandardName(), this.m_filter.containsFilter((IStandardEnumeration)issueCategory));
        }
        for (IProviderId iProviderId : IssuesFilterDialog.getProviderIdsForFilter(this.getSoftwareSystemProvider())) {
            settings.putBoolean(iProviderId.getStandardName(), this.m_filter.containsFilter((IStandardEnumeration)iProviderId));
        }
        for (IIssueId iIssueId : IssuesFilterDialog.getIssueIdsForFilter(this.getSoftwareSystemProvider())) {
            settings.putBoolean(iIssueId.getStandardName(), this.m_filter.containsFilter((IStandardEnumeration)iIssueId));
        }
        for (IIssueAffectedElementType iIssueAffectedElementType : IssuesFilterDialog.getAffectedElementTypesForFilter()) {
            settings.putBoolean(iIssueAffectedElementType.getStandardName(), this.m_filter.containsFilter((IStandardEnumeration)iIssueAffectedElementType));
        }
        settings.put(Settings.PRESENTATION_MODE.getStandardName(), this.m_presentationMode.getStandardName());
        PreferencesUtility.save((IEclipsePreferences)settings);
    }

    private void createTreeViewerColumn(String columnHeader, int width, int style, CellLabelProvider labelProvider, Image image) {
        assert (this.m_treeViewer != null) : "'m_treeViewer' of method 'createTreeViewerColumn' must not be null";
        assert (columnHeader != null && columnHeader.length() > 0) : "Parameter 'columnHeader' of method 'createTreeViewerColumn' must not be empty";
        assert (labelProvider != null) : "Parameter 'labelProvider' of method 'createTreeViewerColumn' must not be null";
        TreeViewerColumn column = new TreeViewerColumn(this.m_treeViewer, style);
        column.getColumn().setText(columnHeader);
        column.getColumn().setWidth(width);
        column.setLabelProvider(labelProvider);
        if (image != null) {
            column.getColumn().setImage(image);
        }
    }

    protected void createViewContent(Composite viewContentArea) {
        this.loadSettings();
        SashForm sashForm = new SashForm(viewContentArea, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        SwtUtility.applySashSeparatorStyle((SashForm)sashForm);
        this.m_treeViewer = new TreeViewer((Composite)sashForm, 66306);
        this.createTreeViewerColumn("Element", 425, 16384, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!$assertionsDisabled && !(element instanceof IssueNamedElement)) {
                    throw new AssertionError((Object)("Wrong class: " + element.getClass().getCanonicalName()));
                }
                IssueNamedElement treeNode = (IssueNamedElement)element;
                return PresentationModeBasedViewContentAndLabelProvider.getPresentationName((NamedElement)treeNode, IssuesView.this.m_presentationMode);
            }

            public Image getImage(Object element) {
                if (!$assertionsDisabled && !(element instanceof IssueNamedElement)) {
                    throw new AssertionError((Object)("Wrong class: " + element.getClass().getCanonicalName()));
                }
                return UiResourceManager.getInstance().getImage((Element)((IssueNamedElement)element));
            }
        }, null);
        this.createTreeViewerColumn("Affected Elements", 125, 131072, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!$assertionsDisabled && !(element instanceof IssueNamedElement)) {
                    throw new AssertionError((Object)("Wrong class: " + element.getClass().getCanonicalName()));
                }
                IssueCountInfo issueInfo = ((IssueNamedElement)element).getIssueInfo();
                return Integer.toString(issueInfo.getAffectedElementCount());
            }
        }, null);
        this.createTreeViewerColumn("Error", 100, 131072, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!$assertionsDisabled && !(element instanceof IssueNamedElement)) {
                    throw new AssertionError((Object)("Wrong class: " + element.getClass().getCanonicalName()));
                }
                IssueCountInfo issueInfo = ((IssueNamedElement)element).getIssueInfo();
                return Integer.toString(issueInfo.getErrors());
            }
        }, UiResourceManager.getInstance().getImage("ErrorAnnotation"));
        this.createTreeViewerColumn("Warning", 100, 131072, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!$assertionsDisabled && !(element instanceof IssueNamedElement)) {
                    throw new AssertionError((Object)("Wrong class: " + element.getClass().getCanonicalName()));
                }
                IssueCountInfo issueInfo = ((IssueNamedElement)element).getIssueInfo();
                return Integer.toString(issueInfo.getWarnings());
            }
        }, UiResourceManager.getInstance().getImage("WarningAnnotation"));
        this.createTreeViewerColumn("Info", 100, 131072, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!$assertionsDisabled && !(element instanceof IssueNamedElement)) {
                    throw new AssertionError((Object)("Wrong class: " + element.getClass().getCanonicalName()));
                }
                IssueCountInfo issueInfo = ((IssueNamedElement)element).getIssueInfo();
                return Integer.toString(issueInfo.getInfos());
            }
        }, UiResourceManager.getInstance().getImage("InfoAnnotation"));
        this.m_treeViewer.setContentProvider((IContentProvider)this.m_treeViewerContentProvider);
        this.m_treeViewer.setUseHashlookup(true);
        NamedElementViewComparator comparator = new NamedElementViewComparator();
        this.m_treeViewer.setComparator((ViewerComparator)comparator);
        comparator.setCategoryProvider(new CategoryProvider(WorkbenchRegistry.getInstance().getViewCategoryProviders((IViewId)ViewId.NAVIGATION_VIEW)));
        this.m_treeViewer.getTree().setHeaderVisible(true);
        this.m_treeViewer.getTree().setLinesVisible(false);
        this.m_treeViewer.addTreeListener((ITreeViewerListener)this);
        this.m_issuesViewer = new PagingPropertyTableViewer((Composite)sashForm, (BeanPropertyReader.BeanAdapter)this.m_issueBeanAdapter, null, true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE, 1000);
        this.m_issuesViewer.addColumn("Issue", "issueName", "issueName", "issueImage", 300, PropertyTableViewer.ColumnType.TEXT);
        this.m_issuesViewer.addColumn("Description", "description", "description", null, 300, PropertyTableViewer.ColumnType.TEXT);
        this.m_issuesViewer.addColumn("Severity", "severity", "severitySort", "severityImage", 120, PropertyTableViewer.ColumnType.TEXT);
        this.m_issuesViewer.addColumn("Category", "categoryName", "categoryName", null, 200, PropertyTableViewer.ColumnType.TEXT);
        this.m_issuesViewer.addColumn("Element", "elementOrFrom", "elementOrFrom", "elementOrFromImage", 350, PropertyTableViewer.ColumnType.TEXT);
        this.m_issuesViewer.addColumn("To Element", "to", "to", "toImage", 350, PropertyTableViewer.ColumnType.TEXT);
        this.m_issuesViewer.addColumn("Provider", "issueProviderName", "issueProviderName", null, 200, PropertyTableViewer.ColumnType.TEXT);
        this.m_textSearchProvider = new TreeBasedTextSearchHandler(this.m_treeViewer, this.getViewId().getPresentationName());
        sashForm.setWeights(new int[]{40, 60});
    }

    public List<Control> getControlsForInteraction() {
        return Arrays.asList(this.m_treeViewer.getTree(), this.m_issuesViewer.getTable());
    }

    public List<Control> getViewComponents() {
        return Arrays.asList(this.m_treeViewer.getTree(), this.m_issuesViewer.getTable());
    }

    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        List elementsToSelect;
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'finishShowInView' must not be empty";
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        if (softwareSystem == null) {
            return;
        }
        this.removeListeners();
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (Element next : elements) {
            assert (next != null) : "Must not be null";
            assert (next instanceof Issue) : "Unexpected element " + next.getClass().getCanonicalName() + ": " + String.valueOf(next);
            issues.add((Issue)next);
        }
        IHierarchicalIssueProvider hierarchialIssueProvider = (IHierarchicalIssueProvider)this.getSoftwareSystemProvider().getInstallation().getExtension(IHierarchicalIssueProvider.class);
        IssueFilter currentFilter = hierarchialIssueProvider.computeMatchingFilter(this.m_filter, issues);
        if (this.m_filter != currentFilter) {
            if (UserInterfaceAdapter.getInstance().question("Do you want to replace the current issue filter?\nOtherwise the issues will not be visible when changing the selection in the tree.", true) == UserInterfaceAdapter.Feedback.CONFIRMED) {
                this.m_filter = currentFilter;
            }
            this.computeAndApplyIssueTree(this.getSoftwareSystem());
        }
        if ((elementsToSelect = hierarchialIssueProvider.getElementsForIssues(issues)).size() > 0) {
            TreePath[] treePathArray = this.computeTreePaths(elementsToSelect);
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath treePath = treePathArray[n2];
                this.m_treeViewer.setExpandedState((Object)treePath, true);
                ++n2;
            }
            this.m_treeViewer.setSelection((ISelection)new StructuredSelection(elementsToSelect), true);
            this.showIssues();
            this.m_issuesViewer.select(issues);
        }
        this.addListeners();
    }

    private TreePath[] computeTreePaths(List<IssueNamedElement> elementsToSelect) {
        ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
        for (IssueNamedElement next : elementsToSelect) {
            List parents = next.getParents(NamedElement.class, new Class[0]);
            Collections.reverse(parents);
            parents.add(next);
            treePaths.add(new TreePath(parents.toArray()));
        }
        return treePaths.toArray(new TreePath[0]);
    }

    protected void componentSelected(Control component) {
        assert (component != null) : "Parameter 'component' of method 'componentSelected' must not be null";
        if (component == this.m_treeViewer.getTree()) {
            this.m_selectedViewComponent = ViewComponent.TREE;
        } else if (component == this.m_issuesViewer.getTable()) {
            this.m_selectedViewComponent = ViewComponent.TABLE;
        } else assert (false) : "Unhandled component: " + String.valueOf(component);
    }

    private void addListeners() {
        this.m_treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_treeViewer.addTreeListener((ITreeViewerListener)this);
        this.m_issuesViewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void removeListeners() {
        this.m_treeViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_treeViewer.removeTreeListener((ITreeViewerListener)this);
        this.m_issuesViewer.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void showIssues() {
        Object input;
        ArrayList<IssueNamedElement> selectedTreeNodes = new ArrayList<IssueNamedElement>();
        selectedTreeNodes.addAll(this.getSelectedTreeNodes());
        if (selectedTreeNodes.isEmpty() && (input = this.m_treeViewer.getInput()) != null) {
            assert (input instanceof NamedElementIssueTree) : "Unexpected class in method 'showIssues': " + String.valueOf(input);
            selectedTreeNodes.addAll(((NamedElementIssueTree)input).getChildren(IssueRootElement.class));
        }
        List issuesOfSelectedElements = selectedTreeNodes.isEmpty() ? Collections.emptyList() : IssueNamedElement.getIssuesRecursively(selectedTreeNodes);
        this.m_issuesViewer.showData((Collection)issuesOfSelectedElements);
    }

    private void show(SoftwareSystem softwareSystem) {
        assert (this.m_filter != null) : "'m_filter' of method 'show' must not be null";
        assert (this.m_issuesViewer != null) : "'m_propertyTableViewer' of method 'show' must not be null";
        this.getContentArea().setRedraw(false);
        this.removeListeners();
        this.computeAndApplyIssueTree(softwareSystem);
        if (this.m_filter.getHasFiltered()) {
            this.m_treeViewer.getTree().setBackground(UiResourceManager.getInstance().getViewHasFilteredElementsColor());
        } else {
            this.m_treeViewer.getTree().setBackground(UiResourceManager.getInstance().getBackgroundColor());
        }
        NavigationState state = ViewNavigationManager.getInstance().getCurrentViewNavigationState(this.getViewId(), this.getSecondaryId());
        if (state != null) {
            this.restoreState(state);
        } else {
            this.showIssues();
        }
        this.addListeners();
        this.getContentArea().setRedraw(true);
    }

    private void computeAndApplyIssueTree(SoftwareSystem softwareSystem) {
        IHierarchicalIssueProvider hierarchialIssueProvider = (IHierarchicalIssueProvider)this.getSoftwareSystemProvider().getInstallation().getExtension(IHierarchicalIssueProvider.class);
        NamedElementIssueTree tree = hierarchialIssueProvider.computeIssueTree(this.m_filter, this.m_presentationMode, softwareSystem);
        this.m_treeViewer.setInput((Object)tree);
        this.m_treeViewer.expandToLevel(3);
    }

    private void refresh() {
        Set currentIds = this.getSoftwareSystemProvider().getInstallation().getAvailableIssueIds();
        Set currentProviderIds = this.getSoftwareSystemProvider().getInstallation().getAvailableIssueProviderIds();
        boolean elementsForFilterChanged = !this.m_availableIds.equals(currentIds) || !this.m_availableProviderIds.equals(currentProviderIds);
        this.m_filter.resetHasFiltered();
        if (elementsForFilterChanged) {
            IEclipsePreferences settings = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone", (IDialogId)this.getViewId());
            for (IProviderId nextId : currentProviderIds) {
                if (this.m_filter.containsFilter((IStandardEnumeration)nextId) || !nextId.isDynamic() || !settings.getBoolean(nextId.getStandardName(), true)) continue;
                this.m_filter.add((IStandardEnumeration)nextId);
            }
            for (IProviderId nextId : currentIds) {
                if (this.m_filter.containsFilter((IStandardEnumeration)nextId) || !nextId.isDynamic() || !settings.getBoolean(nextId.getStandardName(), true)) continue;
                this.m_filter.add((IStandardEnumeration)nextId);
            }
        }
        if (elementsForFilterChanged) {
            this.m_availableIds.clear();
            this.m_availableProviderIds.clear();
            this.m_availableIds.addAll(currentIds);
            this.m_availableProviderIds.addAll(currentProviderIds);
        }
        this.show(this.getSoftwareSystem());
        this.m_textSearchProvider.requestNewFindInfo();
    }

    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        assert (modification != null) : "Parameter 'modification' of method 'softwareSystemModified' must not be null";
        if (modification.contains(Modification.VIRTUAL_MODEL_CHANGED) || modification.contains(Modification.VIRTUAL_MODEL_MODIFIED)) {
            this.refresh();
        }
        super.softwareSystemModified(modification, restoredFromHistory);
    }

    protected void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        assert (modification != null) : "Parameter 'modification' of method 'analyzerModification' must not be null";
        if (modification.contains(AnalyzerModificationEvent.AnalyzerModification.ISSUE_MODIFIED)) {
            this.refresh();
        }
        super.analyzerModification(modification, analyzerId);
    }

    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.m_filter.resetHasFiltered();
        this.show(null);
    }

    protected void softwareSystemShow(WorkbenchView.ShowMode mode) {
        this.m_availableIds.addAll(this.getSoftwareSystemProvider().getInstallation().getAvailableIssueIds());
        this.m_availableProviderIds.addAll(this.getSoftwareSystemProvider().getInstallation().getAvailableIssueProviderIds());
        this.show(this.getSoftwareSystem());
        super.softwareSystemShow(mode);
    }

    protected void installationModified() {
        super.installationModified();
        this.show(this.getSoftwareSystem());
    }

    public Control getSelectedViewComponent() {
        switch (this.m_selectedViewComponent) {
            case TABLE: {
                return this.m_issuesViewer.getTable();
            }
            case TREE: {
                return this.m_treeViewer.getTree();
            }
        }
        assert (false) : "Unhandled view component: " + String.valueOf((Object)this.m_selectedViewComponent);
        return null;
    }

    public List<Element> getSelectedElements() {
        assert (this.m_selectedViewComponent != null) : "selected component must be set!";
        ArrayList<Element> selected = new ArrayList<Element>();
        switch (this.m_selectedViewComponent) {
            case TABLE: {
                assert (this.m_issuesViewer != null) : "'m_propertyTableViewer' of method 'getSelected' must not be null";
                IStructuredSelection selection = this.m_issuesViewer.getSelection();
                if (selection.isEmpty()) {
                    return selected;
                }
                for (Object next : selection.toList()) {
                    if (!(next instanceof Element)) continue;
                    selected.add((Element)next);
                }
                break;
            }
            case TREE: {
                List<IssueNamedElement> selectedTreeNodes = this.getSelectedTreeNodes();
                for (IssueNamedElement next : selectedTreeNodes) {
                    selected.add((Element)next.getElement());
                }
                break;
            }
            default: {
                assert (false) : "Unhandled view component: " + String.valueOf((Object)this.m_selectedViewComponent);
                break;
            }
        }
        return selected;
    }

    private void addStateInfo(NavigationState state, TreeExpansionEvent event, TreeBasedViewNavigationStateUtility.TreeOperation operation) {
        assert (state != null) : "Parameter 'state' of method 'addStateInfo' must not be null";
        THashMap stateData = new THashMap(1);
        stateData.put(StateData.TREE_PRESENTATION_MODE, this.getPresentationMode());
        TreeBasedViewNavigationStateUtility.createViewState((NavigationState)state, (IElementResolver)this.getElementResolver(), (TreeViewer)this.m_treeViewer, (TreeExpansionEvent)event, (TreeBasedViewNavigationStateUtility.TreeOperation)operation, (Map)stateData);
        List tableSelection = this.getSelectedElements().stream().filter(e -> e instanceof Issue).map(e -> (Issue)e).collect(Collectors.toList());
        state.addElementsInformation((IElementGroup)ElementGroups.TABLE_SELECTION, NavigationState.getDescriptors(tableSelection, (IElementResolver)this.getElementResolver()));
        state.addConstant((IStateData)StateData.SELECTED_VIEW_COMPONENT, (Enum)this.m_selectedViewComponent);
    }

    private void restoreState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'restoreState' must not be null";
        PresentationMode presentationModeInState = (PresentationMode)state.getConstant((IStateData)StateData.TREE_PRESENTATION_MODE);
        if (this.m_presentationMode != presentationModeInState) {
            boolean recomputationOfIssueTreeRequired = this.m_presentationMode == PresentationMode.FLAT || presentationModeInState == PresentationMode.FLAT;
            this.m_presentationMode = presentationModeInState;
            this.saveSettings();
            if (recomputationOfIssueTreeRequired) {
                this.computeAndApplyIssueTree(this.getSoftwareSystem());
            }
            this.m_treeViewerContentProvider.setPresentationMode(this.m_presentationMode);
            this.m_treeViewer.refresh();
        }
        TreeBasedViewNavigationStateUtility.restoreViewState((TreeViewer)this.m_treeViewer, (NavigationState)state, (IElementResolver)this.getElementResolver());
        this.showIssues();
        this.m_selectedViewComponent = (ViewComponent)state.getConstant((IStateData)StateData.SELECTED_VIEW_COMPONENT);
        assert (this.m_selectedViewComponent != null) : "'m_selectedViewComponent' of method 'restoreNavigationState' must not be null";
        StructuredSelection selection = new StructuredSelection(state.getElements((IElementGroup)ElementGroups.TABLE_SELECTION, Issue.class, this.getElementResolver()).toArray());
        this.m_issuesViewer.getTableViewer().setSelection((ISelection)selection, true);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        this.removeListeners();
        Object source = event.getSource();
        assert (source != null) : "Parameter 'source' of method 'selectionChanged' must not be null";
        if (source == this.m_issuesViewer.getTableViewer()) {
            this.m_selectedViewComponent = ViewComponent.TABLE;
            this.m_textSearchProvider = new PropertyTableViewerBasedTextSearchHandler(this.m_issuesViewer, this.getViewId().getPresentationName());
        } else if (source == this.m_treeViewer) {
            this.m_selectedViewComponent = ViewComponent.TREE;
            this.m_textSearchProvider = new TreeBasedTextSearchHandler(this.m_treeViewer, this.getViewId().getPresentationName());
            this.showIssues();
        } else assert (false) : "Unhandled source: " + source.getClass().getName();
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
        this.addStateInfo(state, null, null);
        ViewNavigationManager.getInstance().addNavigationState(state);
        this.getSelectionProviderAdapter().handleSelectionChanged((IStructuredSelection)event.getSelection());
        this.addListeners();
    }

    public void clearSelection(Control control) {
        assert (control != null) : "Parameter 'control' of method 'clearSelection' must not be null";
        if (this.m_selectedViewComponent == ViewComponent.TREE) {
            if (this.m_treeViewer.getTree() == control) {
                this.m_treeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        } else if (this.m_issuesViewer.getTable() == control) {
            this.m_issuesViewer.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    public NamedElement getLinkNamedElement(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getLinkNamedElement' must not be null";
        if (element instanceof Issue) {
            Dependency dependency;
            NamedElement linkNamedElement = null;
            Issue nextIssue = (Issue)element;
            if (nextIssue instanceof NamedElementIssue) {
                linkNamedElement = (NamedElement)nextIssue.getAffectedElement();
            } else if (nextIssue instanceof DependencyIssue && (dependency = (Dependency)nextIssue.getAffectedElement()).getFrom() instanceof NamedElement) {
                linkNamedElement = (NamedElement)dependency.getFrom();
            }
            if (linkNamedElement != null) {
                FilePath definingFile;
                if (linkNamedElement instanceof IDefinedInSystemDefinitionFile && (definingFile = ((IDefinedInSystemDefinitionFile)linkNamedElement).getDefiningFile()) != null) {
                    linkNamedElement = definingFile;
                }
                return linkNamedElement.getRepresentative();
            }
        } else if (element instanceof IssueNamedElement) {
            return ((IssueNamedElement)element).getElement();
        }
        return null;
    }

    public void showFilterRequested() {
        IssueFilter newFilter = new IssueFilter(this.m_filter);
        IssuesFilterDialog issuesFilterDialog = new IssuesFilterDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), "Issues Filter", newFilter, this.getSoftwareSystemProvider());
        if (issuesFilterDialog.open() == 0) {
            this.m_filter = issuesFilterDialog.getNewIssueFilter();
            this.show(this.getSoftwareSystem());
            this.saveSettings();
            this.m_textSearchProvider.requestNewFindInfo();
        }
    }

    private void setFilterInitalState() {
        this.m_filter = new IssueFilter(new IStandardEnumeration[0]);
        this.m_filter.addIgnore(IGNORE_RESOLUTIONS_CONDITION);
        for (Severity severity : IssuesFilterDialog.getSeveritiesForFilter()) {
            if (severity != Severity.ERROR && severity != Severity.WARNING) continue;
            this.m_filter.add((IStandardEnumeration)severity);
        }
        for (IssueCategory issueCategory : IssuesFilterDialog.getCategoriesForFilter()) {
            this.m_filter.add((IStandardEnumeration)issueCategory);
        }
        for (IProviderId iProviderId : IssuesFilterDialog.getProviderIdsForFilter(this.getSoftwareSystemProvider())) {
            this.m_filter.add((IStandardEnumeration)iProviderId);
        }
        for (IIssueId iIssueId : IssuesFilterDialog.getIssueIdsForFilter(this.getSoftwareSystemProvider())) {
            this.m_filter.add((IStandardEnumeration)iIssueId);
        }
        for (IIssueAffectedElementType iIssueAffectedElementType : IssuesFilterDialog.getAffectedElementTypesForFilter()) {
            this.m_filter.add((IStandardEnumeration)iIssueAffectedElementType);
        }
    }

    protected void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'restoreState' must not be null";
        this.getContentArea().setRedraw(false);
        this.removeListeners();
        this.restoreState(state);
        this.addListeners();
        this.getContentArea().setRedraw(true);
    }

    public void clearIssueFilter() {
        this.setFilterInitalState();
        this.show(this.getSoftwareSystem());
        this.saveSettings();
        this.m_textSearchProvider.requestNewFindInfo();
    }

    public void completeViewNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'createNavigationStateForFocusGained' must not be null";
        this.addStateInfo(state, null, null);
    }

    public boolean supportsExcelExport() {
        return this.getSoftwareSystemProvider().hasSoftwareSystem() && !this.m_issuesViewer.isDisposed() && !this.m_issuesViewer.getFilteredInputData().isEmpty();
    }

    public List<ExportData> getExportData(IWorkerContext workerContext) {
        return ((IExportProvider)this.getSoftwareSystemProvider().getInstallation().getExtension(IExportProvider.class)).getIssues(this.m_issuesViewer.getFilteredInputData());
    }

    public Search supportsSearch() {
        return Search.FIND_TEXT;
    }

    protected ITextSearchHandler getTextSearchHandler() {
        return this.m_textSearchProvider;
    }

    public boolean supportsCopy() {
        return this.m_selectedViewComponent == ViewComponent.TABLE && !this.getSelectedElements().isEmpty();
    }

    public String copy() {
        return this.m_issuesViewer.getCopyToClipboardData();
    }

    private List<IssueNamedElement> getSelectedTreeNodes() {
        ITreeSelection selection = this.m_treeViewer.getStructuredSelection();
        ArrayList<IssueNamedElement> selectedElements = new ArrayList<IssueNamedElement>();
        for (Object next : selection.toList()) {
            assert (next instanceof IssueNamedElement) : "Wrong class: " + next.getClass().getCanonicalName();
            selectedElements.add((IssueNamedElement)next);
        }
        return selectedElements;
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        assert (this.m_treeViewer != null) : "'m_issueTreeViewer' of method 'treeCollapsed' must not be null";
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_COLLAPSED);
        this.addStateInfo(state, event, TreeBasedViewNavigationStateUtility.TreeOperation.COLLAPSE);
        ViewNavigationManager.getInstance().addNavigationState(state);
    }

    public void treeExpanded(TreeExpansionEvent event) {
        assert (this.m_treeViewer != null) : "'m_issueTreeViewer' of method 'treeExpanded' must not be null";
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_EXPANDED);
        this.addStateInfo(state, event, TreeBasedViewNavigationStateUtility.TreeOperation.EXPAND);
        ViewNavigationManager.getInstance().addNavigationState(state);
    }

    public void collapseAll() {
        assert (this.m_treeViewer != null) : "'m_treeViewer' of method 'collapseAll' must not be null";
        this.m_treeViewer.collapseAll();
        this.m_treeViewer.expandToLevel(1);
        this.treeCollapsed(null);
    }

    public void expandAll() {
        assert (this.m_treeViewer != null) : "'m_treeViewer' of method 'expandAll' must not be null";
        this.m_treeViewer.expandToLevel(3);
        this.treeExpanded(null);
    }

    public PresentationMode getPresentationMode() {
        return this.m_presentationMode;
    }

    public void setPresentationMode(PresentationMode presentationMode) {
        if (this.m_presentationMode != presentationMode) {
            boolean recomputationOfIssueTreeRequired = this.m_presentationMode == PresentationMode.FLAT || presentationMode == PresentationMode.FLAT;
            this.m_presentationMode = presentationMode;
            this.saveSettings();
            this.getContentArea().setRedraw(false);
            this.removeListeners();
            if (recomputationOfIssueTreeRequired) {
                this.computeAndApplyIssueTree(this.getSoftwareSystem());
            }
            this.m_treeViewerContentProvider.setPresentationMode(presentationMode);
            this.m_treeViewer.refresh(true);
            this.addListeners();
            this.getContentArea().setRedraw(true);
            NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.VIEW_OPTIONS_CHANGED);
            this.addStateInfo(state, null, null);
            ViewNavigationManager.getInstance().addNavigationState(state);
        }
    }

    private static enum ElementGroups implements IElementGroup
    {
        TABLE_SELECTION;

    }

    private static enum Settings implements IStandardEnumeration
    {
        PRESENTATION_MODE;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }

    private static enum StateData implements IStateData
    {
        TREE_PRESENTATION_MODE,
        SELECTED_VIEW_COMPONENT;

    }

    private static enum ViewComponent implements IStandardEnumeration
    {
        TREE,
        TABLE;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

