/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.model.resolution.TaskDefinition;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.ResolutionsDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.TaskDefinitionDiff;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.integration.access.model.ITaskDefinition;
import com.hello2morrow.sonargraph.ui.standalone.diffview.AbstractTableViewerBasedDiffTab;
import com.hello2morrow.sonargraph.ui.standalone.diffview.TaskDefinitionDiffBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.custom.CTabFolder;

final class TaskDiffTab
extends AbstractTableViewerBasedDiffTab<TaskDefinitionDiff<? extends ITaskDefinition, ? extends TaskDefinition>> {
    TaskDiffTab(CTabFolder parent) {
        super(parent, "Task", "ResolutionsView", "change");
        PropertyTableViewer tableViewer = this.getPropertyTableViewer();
        tableViewer.addColumn("Change", "change", "change", "changeImage", 150, PropertyTableViewer.ColumnType.TEXT);
        tableViewer.addColumn("Details", "changeDetails", "changeDetails", null, 300, PropertyTableViewer.ColumnType.TEXT);
        tableViewer.addColumn("Definition", "definition", "definition", "definitionImage", 200, PropertyTableViewer.ColumnType.TEXT);
        tableViewer.addColumn("Description", "description", "description", null, 300, PropertyTableViewer.ColumnType.TEXT);
        tableViewer.addColumn("Priority", "priority", "priorityForSort", "priorityImage", 100, PropertyTableViewer.ColumnType.TEXT);
        tableViewer.addColumn("Assignee", "assignee", "assignee", null, 150, PropertyTableViewer.ColumnType.TEXT);
        tableViewer.addColumn("Created", "created", "created", null, 100, PropertyTableViewer.ColumnType.TEXT);
        tableViewer.addColumn("Matched", "matched", "matched", null, 50, PropertyTableViewer.ColumnType.NUMBER);
    }

    @Override
    protected BeanPropertyReader.BeanAdapter<TaskDefinitionDiff<? extends ITaskDefinition, ? extends TaskDefinition>> createBeanAdapter() {
        return new TaskDefinitionDiffBeanAdapter();
    }

    @Override
    void show(SoftwareSystemDiff systemDiff) {
        assert (systemDiff != null) : "Parameter 'systemDiff' of method 'show' must not be null";
        ResolutionsDiff resolutionsDiff = (ResolutionsDiff)systemDiff.getUniqueExistingChild(ResolutionsDiff.class);
        List taskDiffs = resolutionsDiff.getChildren(TaskDefinitionDiff.class).stream().filter(t -> t.getChange() != IDiffElement.Change.UNMODIFIED).collect(Collectors.toList());
        this.getPropertyTableViewer().showData(taskDiffs);
        this.setExclamationMarkInTabTitle(taskDiffs.size() > 0);
    }
}

