/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionWithResult;
import com.hello2morrow.sonargraph.core.command.system.diff.ComputeAndSetBaselineCommand;
import com.hello2morrow.sonargraph.core.command.system.diff.CreateSystemDiffReportCommand;
import com.hello2morrow.sonargraph.core.command.system.diff.DeactivateBaselineCommand;
import com.hello2morrow.sonargraph.core.command.system.diff.SetBaselineCommand;
import com.hello2morrow.sonargraph.core.model.dashboard.Dashboard;
import com.hello2morrow.sonargraph.core.model.dashboard.IDashboardProvider;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.ui.standalone.diffview.CreateBaselineWizard;
import com.hello2morrow.sonargraph.ui.standalone.diffview.DownloadBaselineWizard;
import com.hello2morrow.sonargraph.ui.standalone.diffview.OpenBaselineWizard;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.BaselineAction;
import com.hello2morrow.sonargraph.ui.swt.base.HorizontalSeparator;
import com.hello2morrow.sonargraph.ui.swt.base.LinkWithImage;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.systemdiff.ExportDiffReportDialog;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

final class SystemDiffViewHeader
extends Composite {
    private final LinkWithImage m_createLink;
    private final LinkWithImage m_setLink;
    private final LinkWithImage m_openRemoteLink;
    private final LinkWithImage m_exportLink;
    private final LinkWithImage m_deactivateLink;
    private final HorizontalSeparator m_separator;

    SystemDiffViewHeader(final Composite parent) {
        super(parent, 0);
        assert (parent != null) : "Parameter 'parent' of method 'SystemDiffViewHeader' must not be null";
        this.setLayout((Layout)new GridLayout(5, false));
        final ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        this.m_createLink = new LinkWithImage((Composite)this, "New Baseline", "NewBaselineReport");
        this.m_createLink.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_createLink.setEnabled(false);
        this.m_createLink.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (!$assertionsDisabled && !provider.hasSoftwareSystem()) {
                    throw new AssertionError((Object)"No system available");
                }
                CreateBaselineWizard wizard = new CreateBaselineWizard(WorkbenchRegistry.getInstance().getProvider());
                WizardDialog wizardDialog = SonargraphWizardAdapter.createWizardDialog((Shell)WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), (SonargraphWizard)wizard);
                if (wizardDialog.open() == 0) {
                    SystemDiffViewHeader.this.computeAndSetBaseline(provider, wizard.getFileName(), wizard.getBaselineReportDirectory(), wizard.getReportDescription(), wizard.getBaselineType());
                }
            }
        });
        this.m_setLink = new LinkWithImage((Composite)this, "Set Baseline", "OpenBaselineReport");
        this.m_setLink.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_setLink.setEnabled(false);
        this.m_setLink.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (!$assertionsDisabled && !provider.hasSoftwareSystem()) {
                    throw new AssertionError((Object)"No system available");
                }
                OpenBaselineWizard wizard = new OpenBaselineWizard(provider);
                WizardDialog wizardDialog = SonargraphWizardAdapter.createWizardDialog((Shell)WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), (SonargraphWizard)wizard);
                if (wizardDialog.open() == 0) {
                    SystemDiffViewHeader.setBaseline(provider, wizard.getBaseline(), wizard.getBaselineType());
                }
            }
        });
        this.m_openRemoteLink = new LinkWithImage((Composite)this, "Download Baseline", "DownloadBaselineReport");
        this.m_openRemoteLink.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_openRemoteLink.setEnabled(false);
        this.m_openRemoteLink.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (!$assertionsDisabled && !provider.hasSoftwareSystem()) {
                    throw new AssertionError((Object)"No system available");
                }
                DownloadBaselineWizard wizard = new DownloadBaselineWizard(provider);
                WizardDialog wizardDialog = SonargraphWizardAdapter.createWizardDialog((Shell)WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), (SonargraphWizard)wizard);
                wizardDialog.addPageChangingListener((IPageChangingListener)wizard);
                wizardDialog.addPageChangedListener((IPageChangedListener)wizard);
                if (wizardDialog.open() == 0 && wizard.getSelectedAction() == BaselineAction.USE_AS_BASELINE) {
                    SystemDiffViewHeader.setBaseline(provider, wizard.getBaselineReport(), wizard.getBaselineType());
                }
            }
        });
        this.m_exportLink = new LinkWithImage((Composite)this, "Export System Diff Report", "ExportDiffReport");
        this.m_exportLink.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_exportLink.setEnabled(false);
        this.m_exportLink.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (!$assertionsDisabled && !provider.hasSoftwareSystem()) {
                    throw new AssertionError((Object)"No system available");
                }
                ExportDiffReportDialog dialog = new ExportDiffReportDialog(parent.getShell());
                if (dialog.open() == 0) {
                    SystemDiffViewHeader.this.createReport(provider, dialog.getOutputDirectory(), IReport.Format.HTML);
                }
            }
        });
        this.m_deactivateLink = new LinkWithImage((Composite)this, "Deactivate", "DeactivateBaseline");
        this.m_deactivateLink.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_deactivateLink.setEnabled(false);
        this.m_deactivateLink.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (!$assertionsDisabled && !provider.hasSoftwareSystem()) {
                    throw new AssertionError((Object)"No system available");
                }
                DeactivateBaselineCommand deactivateCommand = new DeactivateBaselineCommand(provider, new ICommandInteractionWithResult(){

                    public void processResult(OperationResult result) {
                        UserInterfaceAdapter.getInstance().process(result);
                    }
                });
                UserInterfaceAdapter.getInstance().run((Command)deactivateCommand);
            }
        });
        this.m_separator = new HorizontalSeparator((Composite)this, " No System Opened ");
        this.m_separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 5, 1));
    }

    private void computeAndSetBaseline(ISoftwareSystemProvider provider, final String fileName, final TFile baselineReportDirectory, final String reportDescription, final BaselineType baselineType) {
        assert (fileName != null && fileName.length() > 0) : "Parameter 'fileName' of method 'computeAndSetBaseline' must not be empty";
        assert (provider != null) : "Parameter 'provider' of method 'computeAndSetBaseline' must not be null";
        assert (baselineReportDirectory != null) : "Parameter 'baselineReportDirectory' of method 'computeAndSetBaseline' must not be null";
        assert (baselineType != null) : "Parameter 'baselineType' of method 'computeAndSetBaseline' must not be null";
        ComputeAndSetBaselineCommand computeAndSetBaseline = new ComputeAndSetBaselineCommand(provider, new ComputeAndSetBaselineCommand.ComputeBaselineCommandInteraction(){

            public boolean collect(ComputeAndSetBaselineCommand.BaselineInteractionData data) {
                data.setBaselineFileName(fileName);
                data.setBaselineReportDirectory(baselineReportDirectory);
                if (reportDescription != null) {
                    data.setReportDescription(reportDescription);
                }
                data.setBaselineType(baselineType);
                return true;
            }

            public void processResult(OperationResultWithOutcome<TFile> result) {
                if (result.isFailure()) {
                    UserInterfaceAdapter.getInstance().process(result);
                }
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)computeAndSetBaseline);
    }

    static void setBaseline(ISoftwareSystemProvider provider, final TFile baselineReport, final BaselineType baselineType) {
        assert (provider != null) : "Parameter 'provider' of method 'setBaseline' must not be null";
        assert (baselineReport != null) : "Parameter 'baselineReport' of method 'computeDiff' must not be null";
        assert (baselineType != null) : "Parameter 'baselineType' of method 'setBaseline' must not be null";
        SetBaselineCommand setBaseline = new SetBaselineCommand(provider, new SetBaselineCommand.SetBaselineCommandInteraction(){

            public boolean collect(SetBaselineCommand.SetBaselineInteractionData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setData(baselineType, baselineReport);
                return true;
            }

            public void processResult(OperationResult result) {
                if (result.isFailure()) {
                    UserInterfaceAdapter.getInstance().process(result);
                }
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)setBaseline);
    }

    private void createReport(ISoftwareSystemProvider provider, final TFile outputDirectory, final IReport.Format reportFormat) {
        assert (provider != null) : "Parameter 'provider' of method 'createReport' must not be null";
        assert (outputDirectory != null) : "Parameter 'outputDirectory' of method 'createReport' must not be null";
        assert (reportFormat != null) : "Parameter 'reportFormat' of method 'createReport' must not be null";
        CreateSystemDiffReportCommand reportCommand = new CreateSystemDiffReportCommand(provider, new CreateSystemDiffReportCommand.ICreateSystemDiffReportInteraction(){

            public void handleSystemDiffReportResult(OperationResultWithOutcome<Map<IReport.Format, TFile>> createReportResult) {
                if (createReportResult.isSuccess()) {
                    Map formatToFileMap = (Map)createReportResult.getOutcome();
                    if (!$assertionsDisabled && formatToFileMap == null) {
                        throw new AssertionError((Object)"'createReportResult' of method 'handleResult' must not be null");
                    }
                    final TFile targetFile = (TFile)formatToFileMap.get(reportFormat);
                    if (UserInterfaceAdapter.Feedback.CONFIRMED == UserInterfaceAdapter.getInstance().question("Report has been saved to: \n\n" + targetFile.getNormalizedAbsolutePath() + "\n\nDo you want to open it?", false)) {
                        UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                            @Override
                            public void run() {
                                Program.launch((String)targetFile.getNormalizedAbsolutePath());
                            }
                        });
                    }
                } else {
                    UserInterfaceAdapter.getInstance().process(createReportResult);
                }
            }

            public boolean collect(CreateSystemDiffReportCommand.CreateSystemDiffReportCommandInteractionData data) {
                data.setOutputDirectory(outputDirectory);
                THashSet reportFormats = new THashSet();
                reportFormats.add(reportFormat);
                data.setReportFormats((Set)reportFormats);
                return true;
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)reportCommand);
    }

    void show(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'show' must not be null";
        ISystemDiffProvider diffProvider = (ISystemDiffProvider)softwareSystem.getExtension(ISystemDiffProvider.class);
        this.m_createLink.setEnabled(diffProvider.isComputeAndSetBaslinePossible());
        this.m_setLink.setEnabled(true);
        this.m_openRemoteLink.setEnabled(true);
        this.m_exportLink.setEnabled(diffProvider.getSoftwareSystemDiff() != null);
        this.m_deactivateLink.setEnabled(diffProvider.getActiveBaselineFile() != null);
        Dashboard currentDashboard = ((IDashboardProvider)softwareSystem.getExtension(IDashboardProvider.class)).getDashboard();
        assert (currentDashboard != null) : "'currentDashboard' of method 'show' must not be null";
        this.m_separator.set(" " + FileUtility.getFileNameWithoutExtension((TFile)currentDashboard.getFile()) + " ", UiResourceManager.getInstance().getImage("icon_16x16"));
    }

    void clear() {
        this.m_createLink.setEnabled(false);
        this.m_setLink.setEnabled(false);
        this.m_openRemoteLink.setEnabled(false);
        this.m_exportLink.setEnabled(false);
        this.m_deactivateLink.setEnabled(false);
        this.m_separator.reset();
    }
}

