/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.dependenciesview;

import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.representation.BalancedDependency;
import com.hello2morrow.sonargraph.core.model.workspace.ComponentContainer;
import com.hello2morrow.sonargraph.ui.standalone.dependenciesview.DependencyColumnId;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public final class DependenciesViewSorter
extends ViewerComparator {
    private static final int DESCENDING = 1;
    private int m_direction = 1;
    private DependencyColumnId m_column = DependencyColumnId.FROM;

    public void setColumn(DependencyColumnId column) {
        if (column == this.m_column) {
            this.m_direction = 1 - this.m_direction;
        } else {
            this.m_column = column;
            this.m_direction = 1;
        }
    }

    public int getDirection() {
        return this.m_direction == 1 ? 1024 : 128;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        BalancedDependency d1 = (BalancedDependency)e1;
        BalancedDependency d2 = (BalancedDependency)e2;
        int result = 0;
        switch (this.m_column) {
            case TO: {
                result = d2.getToPresentationName(!(d2.getToEndPoint() instanceof IRecursiveElement)).compareTo(d1.getToPresentationName(!(d1.getToEndPoint() instanceof IRecursiveElement)));
                break;
            }
            case ICON: {
                result = d2.getArchitectureViolationMode().compareTo((Enum)d1.getArchitectureViolationMode());
                break;
            }
            case DEPENDENCY_TYPE: {
                result = d2.getDependencyInfo().compareTo(d1.getDependencyInfo());
                break;
            }
            case FROM: {
                result = d2.getFromPresentationName(!(d2.getFromEndPoint() instanceof IRecursiveElement)).compareTo(d1.getFromPresentationName(!(d1.getFromEndPoint() instanceof IRecursiveElement)));
                break;
            }
            case FROM_SCOPE: {
                result = this.compareComponentContainers(d1, d2, true);
                break;
            }
            case TO_SCOPE: {
                result = this.compareComponentContainers(d1, d2, false);
                break;
            }
            case NUMBER_OF_DEPENDENCIES: {
                result = Integer.compare(d1.getNumberOfParserDependencies(), d2.getNumberOfParserDependencies());
                break;
            }
            default: {
                assert (false) : "Unexpected value for 'm_column' " + String.valueOf((Object)this.m_column);
                break;
            }
        }
        if (this.m_direction == 1) {
            result = -result;
        }
        return result;
    }

    private int compareComponentContainers(BalancedDependency d1, BalancedDependency d2, boolean compareScopeOfFrom) {
        ComponentContainer c2;
        ComponentContainer c1;
        assert (d1 != null) : "Parameter 'd1' of method 'compareComponentContainers' must not be null";
        assert (d2 != null) : "Parameter 'd2' of method 'compareComponentContainers' must not be null";
        if (compareScopeOfFrom) {
            c1 = this.getComponentContainer(d1.getFromEndPoint());
            c2 = this.getComponentContainer(d2.getFromEndPoint());
        } else {
            c1 = this.getComponentContainer(d1.getToEndPoint());
            c2 = this.getComponentContainer(d2.getToEndPoint());
        }
        if (c1 != null && c2 != null) {
            return c1.getName().compareTo(c2.getName());
        }
        return 0;
    }

    private ComponentContainer getComponentContainer(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'getComponentContainer' must not be null";
        return (ComponentContainer)element.getParent(ComponentContainer.class, ParentMode.SELF_OR_FIRST_PARENT);
    }
}

