/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.commandhandler;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.SendFeedbackCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.StandaloneProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.swt.base.IProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.dialog.feedback.FeedbackDialog;
import com.hello2morrow.sonargraph.ui.swt.dialog.feedback.StandardFeedbackInteraction;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.e4.core.di.annotations.Execute;

public final class SendFeedbackHandler
extends CommandHandlerWithCorrespondingCommand {
    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.SEND_FEEDBACK;
    }

    @Execute
    public void execute() {
        TFile logFile = SendFeedbackCommand.getLogFile();
        FeedbackDialog dialog = new FeedbackDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), logFile, "com.hello2morrow.sonargraph.standalone", (IProxySettingsProvider)new StandaloneProxySettingsProvider());
        if (dialog.open() == 0) {
            FeedbackInteraction interaction = new FeedbackInteraction(dialog, logFile);
            SendFeedbackCommand.sendUserFeedback((ProxySettings)new StandaloneProxySettingsProvider().getProxySettings(false), (SendFeedbackCommand.IInteraction)interaction);
        }
    }

    public static class FeedbackInteraction
    extends StandardFeedbackInteraction {
        public FeedbackInteraction(FeedbackDialog dialog, TFile logFile) {
            super(dialog, logFile, RcpUtility.getRcpWorkspaceMetaDataDirectory());
        }

        public void handleResult(OperationResult result) {
            assert (result != null) : "Parameter 'result' of method 'handleResult' must not be null";
            if (result.isSuccess()) {
                UserInterfaceAdapter.getInstance().information("Feedback successfully sent.", "Thank you for providing feedback! " + StringUtility.LINE_SEPARATOR + "It is forwarded to support@hello2morrow.com." + StringUtility.LINE_SEPARATOR);
            } else {
                UserInterfaceAdapter.getInstance().process(result);
            }
        }
    }
}

