/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.commandhandler;

import com.hello2morrow.sonargraph.core.command.system.RestoreCommand;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.history.IUndoRedoEntry;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;

public abstract class RestoreHandler
extends CommandHandlerWithCorrespondingCommand {
    protected abstract String getInitialLabel();

    protected abstract String getMenuItem();

    protected abstract String getToolItem();

    protected abstract IUndoRedoEntry getEntry(MPart var1);

    @CanExecute
    public final boolean canExecute(IEclipseContext eclipseContext, MPart part, @Optional MMenuItem menuItem, @Optional MToolItem toolItem) {
        IUndoRedoEntry entry;
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'canExecute' must not be null";
        assert (part != null) : "Parameter 'part' of method 'canExecute' must not be null";
        if (menuItem == null) {
            menuItem = (MMenuItem)RcpUtility.findUniqueModelElement((IEclipseContext)eclipseContext, (MUIElement)WorkbenchRegistry.getInstance().getMainApplicationWindow().getMainMenu(), (String)this.getMenuItem(), MMenuItem.class);
            assert (menuItem != null) : "'menuItem' of method 'canExecute' must not be null";
        }
        menuItem.setLabel(this.getInitialLabel());
        if (toolItem != null) {
            toolItem.setTooltip(this.getInitialLabel());
        }
        if (this.isAvailable(menuItem) && WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED}) && (entry = this.getEntry(part)) != null) {
            StringBuilder label = new StringBuilder(this.getInitialLabel());
            label.append(": ");
            label.append(entry.getCommandName());
            label.append(" [File: ");
            label.append(entry.getIdentifyingPath());
            label.append("]");
            menuItem.setLabel(label.toString());
            if (toolItem != null) {
                toolItem.setTooltip(label.toString());
            }
            return true;
        }
        return false;
    }

    protected abstract void performExecute(MPart var1);

    @Execute
    public final void execute(MPart part) {
        assert (part != null) : "Parameter 'part' of method 'execute' must not be null";
        this.performExecute(part);
    }

    static final class Interaction
    implements RestoreCommand.IRestoreInteraction {
        Interaction() {
        }

        public void processRestoreResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }

        public INavigationState getNavigationState() {
            return null;
        }

        public boolean confirm(String message) {
            return UserInterfaceAdapter.getInstance().question(message, false) == UserInterfaceAdapter.Feedback.CONFIRMED;
        }
    }
}

