/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.commandhandler;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.system.CloseSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.StandaloneProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.CloseCommandInteraction;
import com.hello2morrow.sonargraph.ui.swt.base.IProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.license.ConnectionDialog;
import com.hello2morrow.sonargraph.ui.swt.license.ConnectionMode;
import com.hello2morrow.sonargraph.ui.swt.license.LicenseDialog;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.swt.widgets.Shell;

public final class ManageLicenseHandler
extends CommandHandler {
    @Execute
    public void execute(Shell shell, IWorkbench workbench) {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider != null) : "'provider' must not be null";
        StandaloneProxySettingsProvider proxySettingsProvider = new StandaloneProxySettingsProvider();
        ConnectionMode connectionMode = ConnectionDialog.getConnectionMode((IProxySettingsProvider)proxySettingsProvider);
        LicenseDialog dialog = new LicenseDialog(shell, CommandRegistry.getInstance().getLicenseHandler(), provider, connectionMode, (IDialogId)CoreDialogId.INSTALL_LICENSE_DIALOG, (IProxySettingsProvider)proxySettingsProvider);
        int result = dialog.open();
        if (result == 0) {
            if (provider.hasSoftwareSystem()) {
                CloseSoftwareSystemCommand command = new CloseSoftwareSystemCommand(provider, (CloseSoftwareSystemCommand.ICloseInteraction)new CloseCommandInteraction(false){

                    @Override
                    public boolean closeSoftwareSystem() {
                        return true;
                    }
                });
                UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)command);
            }
            workbench.restart();
        }
    }
}

