/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.workbench;

import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ISonargraphUIContribution;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public final class MemoryWidget
implements ISonargraphUIContribution {
    private static final int UPDATE_INTERVAL_SECONDS = 20000;
    private Timer m_timer;
    private Label m_label;

    private void update(boolean forceGC) {
        if (this.m_label != null && !this.m_label.isDisposed()) {
            Runtime runtime = Runtime.getRuntime();
            if (forceGC) {
                runtime.gc();
            }
            long totalMemory = runtime.totalMemory();
            long usedMemory = totalMemory - runtime.freeMemory();
            this.m_label.setText(NumberUtility.bytesToMegabytes((long)usedMemory) + "/" + NumberUtility.bytesToMegabytes((long)totalMemory));
        }
    }

    @PostConstruct
    public void createWidget(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createWidget' must not be null";
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.horizontalSpacing = 2;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.m_label = new Label(composite, 131072);
        GridData labelGridData = new GridData(131072, 0x1000000, true, true);
        this.m_label.setToolTipText("Memory used/allocated in MB [max: " + NumberUtility.bytesToMegabytes((long)Runtime.getRuntime().maxMemory()) + " MB]");
        this.m_label.setText("99.999/99.999");
        Point preferredSize = this.m_label.computeSize(-1, -1);
        labelGridData.widthHint = preferredSize.x;
        this.m_label.setLayoutData((Object)labelGridData);
        this.update(true);
        ToolBar toolBar = new ToolBar(composite, 0x800000);
        toolBar.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        ToolItem button = new ToolItem(toolBar, 8);
        button.setImage(UiResourceManager.getInstance().getImage("Clear"));
        button.setToolTipText("Run Garbage Collector");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemoryWidget.this.update(true);
            }
        });
        Label separator = new Label(composite, 514);
        separator.setLayoutData((Object)new GridData(0, 4, false, true));
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                    @Override
                    public void run() {
                        MemoryWidget.this.update(false);
                    }
                });
            }
        };
        this.m_timer = new Timer(false);
        this.m_timer.scheduleAtFixedRate(timerTask, 20000L, 20000L);
    }

    @PreDestroy
    public void dispose() {
        if (this.m_timer != null) {
            this.m_timer.cancel();
            this.m_timer = null;
        }
        this.m_label = null;
    }
}

