/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.swt;

import com.hello2morrow.sonargraph.ui.standalone.base.swt.UiTreeNode;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public final class SimpleCheckBoxTreeViewer<T extends UiTreeNode>
implements ICheckStateListener {
    private final CheckboxTreeViewer m_checkBoxTreeViewer;
    private IStateChangedListener<T> m_stateChangedListener;
    private final Map<T, Boolean> m_disabledElements = new THashMap();
    private TreeViewerFilter m_treeViewerFilter;
    private final ICheckStateProvider m_checkStateProvider;

    public SimpleCheckBoxTreeViewer(Composite parent, ICheckStateProvider checkStateProvider) {
        assert (parent != null) : "Parameter 'parent' of method 'SimpleCheckBoxTreeViewer' must not be null";
        assert (checkStateProvider != null) : "Parameter 'checkStateProvider' of method 'SimpleCheckBoxTreeViewer' must not be null";
        this.m_checkBoxTreeViewer = new CheckboxTreeViewer(parent);
        this.m_checkBoxTreeViewer.setUseHashlookup(true);
        this.m_checkBoxTreeViewer.addCheckStateListener((ICheckStateListener)this);
        this.m_checkStateProvider = checkStateProvider;
        this.m_checkBoxTreeViewer.setCheckStateProvider(this.m_checkStateProvider);
    }

    public void setAllChecked(boolean checked) {
        this.m_checkBoxTreeViewer.getTree().setRedraw(false);
        IStateChangedListener<T> stateChangedListener = this.m_stateChangedListener;
        this.m_stateChangedListener = null;
        for (UiTreeNode next : this.getInput()) {
            this.updateCheckedState(checked, next);
        }
        this.m_stateChangedListener = stateChangedListener;
        this.m_stateChangedListener.handleAllStatesChanged();
        this.m_checkBoxTreeViewer.getTree().setRedraw(true);
    }

    private void updateCheckedState(boolean checked, T node) {
        if (this.m_disabledElements.containsKey(node)) {
            return;
        }
        if (((UiTreeNode)((Object)node)).isChecked() != checked) {
            ((UiTreeNode)((Object)node)).setChecked(checked);
            this.m_checkBoxTreeViewer.setChecked(node, checked);
            if (this.m_stateChangedListener != null) {
                this.m_stateChangedListener.handleStateChanged(node);
            }
        }
        this.setSubtreeChecked(node, checked);
        this.m_checkBoxTreeViewer.setGrayed(node, this.m_checkStateProvider.isGrayed(node));
    }

    public void setAllVisibleChecked(boolean checked, int filterMask) {
        IStateChangedListener<T> stateChangedListener = this.m_stateChangedListener;
        this.m_stateChangedListener = null;
        TreeItem[] items = this.m_checkBoxTreeViewer.getTree().getItems();
        this.updateCheckedStateForLevel(checked, null, items, filterMask, 1);
        this.m_stateChangedListener = stateChangedListener;
        this.m_stateChangedListener.handleAllStatesChanged();
    }

    private void updateCheckedStateForLevel(boolean checked, TreeItem parent, TreeItem[] items, int filterMask, int level) {
        if (level > filterMask) {
            return;
        }
        boolean parentNeedsUpdate = false;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem next = treeItemArray[n2];
            if ((filterMask & level) != 0) {
                if (next.getChecked() != checked || next.getGrayed()) {
                    UiTreeNode node = (UiTreeNode)((Object)next.getData());
                    this.updateCheckedState(checked, node);
                    parentNeedsUpdate = true;
                }
            } else {
                this.updateCheckedStateForLevel(checked, next, next.getItems(), filterMask, level + 1);
            }
            ++n2;
        }
        if (parent != null && parentNeedsUpdate) {
            this.processParentCheckState((UiTreeNode)((Object)parent.getData()));
        }
    }

    public List<T> getCheckedElements() {
        Object[] checkedElements = this.m_checkBoxTreeViewer.getCheckedElements();
        ArrayList<UiTreeNode> checkedNodes = new ArrayList<UiTreeNode>(checkedElements.length);
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            assert (object != null && object instanceof UiTreeNode) : "Unexpected class in method 'getCheckedElements': " + String.valueOf(object);
            checkedNodes.add((UiTreeNode)((Object)object));
            ++n2;
        }
        return checkedNodes;
    }

    public void setInput(Collection<? extends T> input) {
        this.m_checkBoxTreeViewer.setInput(input == null ? Collections.emptyList() : input);
    }

    public Collection<T> getInput() {
        Object input = this.m_checkBoxTreeViewer.getInput();
        assert (input != null) : "Parameter 'input' of method 'getInput' must not be null";
        if (input instanceof UiTreeNode) {
            return ((UiTreeNode)((Object)input)).getChildren();
        }
        assert (input instanceof Collection) : "Unexpected class in method 'getInput': " + String.valueOf(input);
        return (Collection)input;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'checkStateChanged' must not be null";
        Object object = event.getElement();
        assert (object != null && object instanceof UiTreeNode) : "Unexpected class in method 'checkStateChanged': " + String.valueOf(object);
        UiTreeNode node = (UiTreeNode)((Object)object);
        boolean isChecked = event.getChecked();
        boolean hasChanged = node.isChecked() ^ isChecked;
        Boolean disabledCheckState = this.m_disabledElements.get((Object)node);
        if (disabledCheckState != null) {
            boolean checked = disabledCheckState;
            if (checked) {
                this.setSubtreeChecked(node, isChecked);
                this.m_checkBoxTreeViewer.setGrayed((Object)node, this.m_checkStateProvider.isGrayed((Object)node));
            } else {
                node.setChecked(checked);
                this.setSubtreeChecked(node, checked);
                this.m_checkBoxTreeViewer.setChecked((Object)node, checked);
            }
            return;
        }
        if (this.m_treeViewerFilter == null) {
            node.setChecked(isChecked);
        } else if (isChecked) {
            node.setChecked(true);
        } else {
            boolean anyChildNodeSelected = this.isAnyHiddenChildNodeSelected(node);
            if (!anyChildNodeSelected) {
                node.setChecked(false);
            }
        }
        this.setSubtreeChecked(node, isChecked);
        if (node.getParent() != null) {
            this.processParentCheckState((UiTreeNode)node.getParent());
        }
        if (this.m_stateChangedListener != null && hasChanged) {
            this.m_stateChangedListener.handleStateChanged(node);
        }
        this.m_checkBoxTreeViewer.setGrayed((Object)node, this.m_checkStateProvider.isGrayed((Object)node));
    }

    private boolean isAnyHiddenChildNodeSelected(UiTreeNode node) {
        if (this.m_treeViewerFilter == null) {
            return false;
        }
        Set<UiTreeNode> hiddenElements = this.m_treeViewerFilter.getHiddenElements();
        for (UiTreeNode child : node.getChildren()) {
            if (child.isChecked() && hiddenElements.contains((Object)child)) {
                return true;
            }
            boolean anyHiddenChildSelected = this.isAnyHiddenChildNodeSelected(child);
            if (!anyHiddenChildSelected) continue;
            return true;
        }
        return false;
    }

    public void setCheckStateProvider(ICheckStateProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'setCheckStateProvider' must not be null";
        this.m_checkBoxTreeViewer.setCheckStateProvider(provider);
    }

    public void processParentCheckState(T parent) {
        assert (parent != null) : "Parameter 'parent' of method 'processParentCheckState' must not be null";
        Boolean disabledCheckState = this.m_disabledElements.get(parent);
        if (disabledCheckState != null) {
            boolean state = disabledCheckState;
            ((UiTreeNode)((Object)parent)).setChecked(state);
            this.m_checkBoxTreeViewer.setChecked(parent, state);
            this.m_checkBoxTreeViewer.setGrayed(parent, this.m_checkStateProvider.isGrayed(parent));
            return;
        }
        List children = parent.getChildren();
        if (!children.isEmpty()) {
            boolean previousChecked = ((UiTreeNode)((Object)parent)).isChecked();
            long checkedChildren = parent.getChildren().stream().filter(child -> child.isChecked()).count();
            if (checkedChildren == (long)children.size()) {
                ((UiTreeNode)((Object)parent)).setChecked(true);
                if (this.m_stateChangedListener != null && !previousChecked) {
                    this.m_stateChangedListener.handleStateChanged(parent);
                }
                this.m_checkBoxTreeViewer.setGrayed(parent, false);
            } else if (checkedChildren > 0L && checkedChildren < (long)children.size()) {
                ((UiTreeNode)((Object)parent)).setChecked(true);
                this.m_checkBoxTreeViewer.setGrayed(parent, true);
                if (this.m_stateChangedListener != null && !previousChecked) {
                    this.m_stateChangedListener.handleStateChanged(parent);
                }
            } else if (checkedChildren == 0L) {
                ((UiTreeNode)((Object)parent)).setChecked(false);
                this.m_checkBoxTreeViewer.setGrayed(parent, false);
                if (this.m_stateChangedListener != null && previousChecked) {
                    this.m_stateChangedListener.handleStateChanged(parent);
                }
            }
            this.m_checkBoxTreeViewer.setChecked(parent, ((UiTreeNode)((Object)parent)).isChecked());
        }
        if (parent.getParent() != null) {
            this.processParentCheckState((UiTreeNode)parent.getParent());
        }
    }

    public Tree getTree() {
        return this.m_checkBoxTreeViewer.getTree();
    }

    public void setStateChangedListener(IStateChangedListener<T> listener) {
        this.m_stateChangedListener = listener;
    }

    public void setComparator(Comparator<String> comparator) {
        assert (comparator != null) : "Parameter 'comparator' of method 'setComparator' must not be null";
        this.m_checkBoxTreeViewer.setComparator(new ViewerComparator(comparator));
    }

    public void setExpandedElements(Object[] expandedElements) {
        assert (expandedElements != null) : "Parameter 'expandedElements' of method 'setExpandedElements' must not be null";
        this.m_checkBoxTreeViewer.setExpandedElements(expandedElements);
    }

    public void collapseAll() {
        this.m_checkBoxTreeViewer.collapseAll();
    }

    public void expandAll() {
        this.m_checkBoxTreeViewer.expandAll();
    }

    public void setContentProvider(IContentProvider contentProvider) {
        assert (contentProvider != null) : "Parameter 'contentProvider' of method 'setContentProvider' must not be null";
        this.m_checkBoxTreeViewer.setContentProvider(contentProvider);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        assert (labelProvider != null) : "Parameter 'labelProvider' of method 'setLabelProvider' must not be null";
        this.m_checkBoxTreeViewer.setLabelProvider(labelProvider);
    }

    public void enableTooltipSupport() {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.m_checkBoxTreeViewer);
    }

    public void setDisabled(T element, boolean disabledCheckState) {
        assert (element != null) : "Parameter 'element' of method 'setDisabled' must not be null";
        this.m_disabledElements.put(element, disabledCheckState);
    }

    private void setSubtreeChecked(T element, boolean isChecked) {
        assert (element != null) : "Parameter 'element' of method 'setSubtreeChecked' must not be null";
        for (UiTreeNode child : element.getChildren()) {
            Boolean disabledCheckState = this.m_disabledElements.get((Object)child);
            if (disabledCheckState != null || this.m_treeViewerFilter != null && this.m_treeViewerFilter.getHiddenElements().contains((Object)child)) continue;
            this.setSubtreeChecked(child, isChecked);
            if (child.isChecked() != isChecked) {
                if (!this.isAnyHiddenChildNodeSelected(child)) {
                    this.m_checkBoxTreeViewer.setChecked((Object)child, isChecked);
                    child.setChecked(isChecked);
                }
                if (this.m_stateChangedListener != null) {
                    this.m_stateChangedListener.handleStateChanged(child);
                }
            }
            this.m_checkBoxTreeViewer.setGrayed((Object)child, this.m_checkStateProvider.isGrayed((Object)child));
        }
    }

    public void removeStateChangedListener() {
        this.m_stateChangedListener = null;
    }

    public void setFilter(String text, int filterMask) {
        try {
            this.m_checkBoxTreeViewer.getTree().setRedraw(false);
            this.m_treeViewerFilter = null;
            this.m_checkBoxTreeViewer.resetFilters();
            if (text == null || text.trim().isEmpty()) {
                return;
            }
            this.m_treeViewerFilter = new TreeViewerFilter(filterMask, text);
            this.m_checkBoxTreeViewer.setFilters(new ViewerFilter[]{this.m_treeViewerFilter});
        }
        finally {
            this.m_checkBoxTreeViewer.expandAll();
            this.m_checkBoxTreeViewer.getTree().setRedraw(true);
        }
    }

    public static interface IStateChangedListener<T> {
        public void handleStateChanged(T var1);

        public void handleAllStatesChanged();
    }

    public static final class TreeViewerFilter
    extends ViewerFilter {
        private final int m_filterMask;
        private final String m_filterText;
        private final Set<UiTreeNode> m_hiddenElements;

        private TreeViewerFilter(int filterMask, String filterText) {
            this.m_filterMask = filterMask;
            this.m_filterText = filterText.toLowerCase();
            this.m_hiddenElements = new THashSet();
        }

        public static int determineFilterMask(int ... levels) {
            assert (levels != null && levels.length > 0) : "Parameter 'levels' of method 'determineFilterMask' must not be empty";
            int filterMask = 0;
            int i = 0;
            while (i < levels.length) {
                int currentLevel = levels[i];
                filterMask |= 1 << currentLevel;
                ++i;
            }
            return filterMask;
        }

        public Set<UiTreeNode> getHiddenElements() {
            return this.m_hiddenElements;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            int childLevel;
            assert (parentElement != null) : "Parameter 'parentElement' of method 'select' must not be null";
            assert (element != null && element instanceof UiTreeNode) : "Unexpected class in method 'select': " + String.valueOf(element);
            UiTreeNode elementNode = (UiTreeNode)((Object)element);
            boolean level = true;
            boolean show = false;
            show = elementNode.getParent() == null ? ((this.m_filterMask & 1) != 0 ? this.matchesFilter(elementNode) : (this.m_filterMask < 1 ? true : this.isAnyChildSelected(elementNode.getChildren(), 2))) : ((this.m_filterMask & (childLevel = elementNode.getNumberOfParents() + 1)) != 0 ? this.matchesFilter(elementNode) : (this.m_filterMask < childLevel ? true : this.isAnyChildSelected(elementNode.getChildren(), childLevel + 1)));
            if (!show) {
                this.m_hiddenElements.add(elementNode);
                this.m_hiddenElements.addAll(elementNode.getChildrenRecursively());
            }
            return show;
        }

        private boolean matchesFilter(UiTreeNode elementNode) {
            return elementNode.getName().toLowerCase().contains(this.m_filterText);
        }

        private boolean isAnyChildSelected(List<UiTreeNode> children, int level) {
            for (UiTreeNode nextChild : children) {
                if ((this.m_filterMask & level) != 0 && this.matchesFilter(nextChild)) {
                    return true;
                }
                if (this.m_filterMask > level) {
                    return true;
                }
                if (!this.isAnyChildSelected(nextChild.getChildren(), level + 1)) continue;
                return true;
            }
            return false;
        }
    }

    public static class UiTreeNodeCheckStateProvider
    implements ICheckStateProvider {
        public boolean isChecked(Object element) {
            assert (element != null && element instanceof UiTreeNode) : "Unexpected class in method 'isChecked': " + String.valueOf(element);
            return ((UiTreeNode)((Object)element)).isChecked();
        }

        public boolean isGrayed(Object element) {
            assert (element != null && element instanceof UiTreeNode) : "Unexpected class in method 'isChecked': " + String.valueOf(element);
            return ((UiTreeNode)((Object)element)).isGrayed();
        }
    }
}

