/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.swt;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.utilities.CategoryProvider;
import java.util.Comparator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class NamedElementViewComparator
extends ViewerComparator
implements Comparator<NamedElement> {
    private CategoryProvider m_categoryProvider;

    public NamedElementViewComparator(CategoryProvider categoryProvider) {
        assert (categoryProvider != null) : "Parameter 'categoryProvider' of method 'NamedElementViewComparator' must not be null";
        this.m_categoryProvider = categoryProvider;
    }

    public NamedElementViewComparator() {
        this.m_categoryProvider = null;
    }

    public final void setCategoryProvider(CategoryProvider categoryProvider) {
        this.m_categoryProvider = categoryProvider;
    }

    protected int preCompare(NamedElement element1, NamedElement element2) {
        assert (element1 != null) : "Parameter 'element1' of method 'preCompare' must not be null";
        assert (element2 != null) : "Parameter 'element2' of method 'preCompare' must not be null";
        assert (element1 != element2) : "Same instances";
        return 0;
    }

    @Override
    public final int compare(NamedElement element1, NamedElement element2) {
        assert (element1 != null) : "Parameter 'element1' of method 'compare' must not be null";
        assert (element2 != null) : "Parameter 'element2' of method 'compare' must not be null";
        int compare = 0;
        if (element1 != element2) {
            compare = this.preCompare(element1, element2);
            if (compare == 0 && this.m_categoryProvider != null) {
                compare = this.m_categoryProvider.getCategory((Object)element1.getElement()) - this.m_categoryProvider.getCategory((Object)element2.getElement());
            }
            if (compare == 0) {
                compare = element1.getPresentationName(false).toLowerCase().compareTo(element2.getPresentationName(false).toLowerCase());
            }
            if (compare == 0) {
                compare = element1.getFullyQualifiedName().toLowerCase().compareTo(element2.getFullyQualifiedName().toLowerCase());
            }
        }
        return compare;
    }

    public final int compare(Viewer viewer, Object element1, Object element2) {
        assert (element1 != null) : "Parameter 'element1' of method 'compare' must not be null";
        assert (element2 != null) : "Parameter 'element2' of method 'compare' must not be null";
        assert (element1 instanceof NamedElement) : "Not a named element: " + String.valueOf(element1);
        assert (element2 instanceof NamedElement) : "Not a named element: " + String.valueOf(element2);
        return this.compare(((NamedElement)element1).getElement(), ((NamedElement)element2).getElement());
    }
}

