/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.sourceview;

import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;

public final class MultilineInformation {
    private final int m_firstLine;
    private final int m_lastLine;
    private final int m_firstOffsetOfFirstLine;
    private final int m_lastOffsetOfLastLine;
    private final boolean m_isSingleEmptyLine;
    private final int m_firstOffsetOfPreviousLine;
    private final int m_linefeedOffsetOfPreviousLine;
    private final boolean m_containsEndLine;
    private final boolean m_containsPenultimateLine;
    private final boolean m_isSelectionInSingleLine;

    public static MultilineInformation createMultilineInformation(StyledText styledText, int firstLine, int lastLine) {
        boolean isSelectionInSingleLine;
        assert (styledText != null) : "Parameter 'styledText' of method 'createMultilineInformation' must not be null";
        assert (firstLine >= 0) : "First line should be positive";
        int charCount = styledText.getCharCount();
        if (charCount == 0) {
            return new MultilineInformation(0, 0, 0, 0, true, 0, 0, true, false, false);
        }
        boolean isSingleEmptyLine = styledText.getLine(firstLine).isEmpty() && firstLine == lastLine;
        boolean containsEndLine = lastLine == styledText.getLineCount() - 1;
        boolean containsPenultimateLine = lastLine == styledText.getLineCount() - 2;
        int firstOffsetOfFirstLine = styledText.getOffsetAtLine(firstLine);
        int lastOffsetOfLastLine = containsEndLine && isSingleEmptyLine ? charCount : (containsEndLine ? charCount - 1 : SwtUtility.getLastOffset((StyledText)styledText, (int)lastLine));
        int firstOffsetOfPreviousLine = firstLine >= 1 ? styledText.getOffsetAtLine(firstLine - 1) : firstOffsetOfFirstLine;
        int linefeedOffsetOfPreviousLine = firstLine == 0 ? firstOffsetOfFirstLine : firstOffsetOfFirstLine - MultilineInformation.getLineEndingLengthBefore(styledText, firstOffsetOfFirstLine);
        boolean bl = isSelectionInSingleLine = firstLine == lastLine && styledText.getSelectionCount() <= styledText.getLine(firstLine).length();
        assert (firstOffsetOfFirstLine <= lastOffsetOfLastLine) : "'lastOffsetOfLastLine' should be equal or greater than 'firstOffsetOfFirstLine'";
        return new MultilineInformation(firstLine, lastLine, firstOffsetOfFirstLine, lastOffsetOfLastLine, isSingleEmptyLine, firstOffsetOfPreviousLine, linefeedOffsetOfPreviousLine, containsEndLine, containsPenultimateLine, isSelectionInSingleLine);
    }

    private static int getLineEndingLengthBefore(StyledText styledText, int offset) {
        if (offset <= 1) {
            return 1;
        }
        String text = styledText.getText(offset - 2, offset - 1);
        assert (text.length() == 2) : "Length must be 2";
        if (text.equals("\r\n")) {
            return 2;
        }
        assert (text.endsWith("\n") || text.endsWith("\r")) : "Newline char expected";
        return 1;
    }

    public static MultilineInformation createMultiLineInformation(StyledText styledText, Point range) {
        assert (styledText != null) : "Parameter 'styledText' of method 'createMultiLineInformation' must not be null";
        assert (range != null) : "Parameter 'range' of method 'createMultiLineInformation' must not be null";
        int firstLine = styledText.getLineAtOffset(range.x);
        int lastLine = styledText.getLineAtOffset(range.x + range.y);
        if (lastLine > firstLine && range.x + range.y == styledText.getOffsetAtLine(lastLine)) {
            --lastLine;
        }
        return MultilineInformation.createMultilineInformation(styledText, firstLine, lastLine);
    }

    private MultilineInformation(int firstLine, int lastLine, int firstOffsetOfFirstLine, int lastOffsetOfLastLine, boolean isSingleEmptyLine, int firstOffsetOfPreviousLine, int linefeedOffsetOfPreviousLine, boolean containsEndLine, boolean containsPenultimateLine, boolean isSelectionInSingleLine) {
        this.m_firstLine = firstLine;
        this.m_lastLine = lastLine;
        this.m_firstOffsetOfFirstLine = firstOffsetOfFirstLine;
        this.m_lastOffsetOfLastLine = lastOffsetOfLastLine;
        this.m_isSingleEmptyLine = isSingleEmptyLine;
        this.m_firstOffsetOfPreviousLine = firstOffsetOfPreviousLine;
        this.m_linefeedOffsetOfPreviousLine = linefeedOffsetOfPreviousLine;
        this.m_containsEndLine = containsEndLine;
        this.m_containsPenultimateLine = containsPenultimateLine;
        this.m_isSelectionInSingleLine = isSelectionInSingleLine;
    }

    public final int getFirstLine() {
        return this.m_firstLine;
    }

    public final int getLastLine() {
        return this.m_lastLine;
    }

    public final int getFirstOffsetOfFirstLine() {
        return this.m_firstOffsetOfFirstLine;
    }

    public final int getLastOffsetOfLastLine() {
        return this.m_lastOffsetOfLastLine;
    }

    public boolean isSelectionInSingleLine() {
        return this.m_isSelectionInSingleLine;
    }

    public boolean isSingleEmptyLine() {
        return this.m_isSingleEmptyLine;
    }

    public boolean isEmptyEndLine() {
        return this.isSingleEmptyLine() && this.containsEndLine();
    }

    public int getFirstOffsetOfPreviousLine() {
        return this.m_firstOffsetOfPreviousLine;
    }

    public int getLinefeedOffsetOfPreviousLine() {
        return this.m_linefeedOffsetOfPreviousLine;
    }

    public boolean containsEndLine() {
        return this.m_containsEndLine;
    }

    public boolean containsPenultimateLine() {
        return this.m_containsPenultimateLine;
    }

    public int getSelectionLength() {
        int result = this.m_lastOffsetOfLastLine - this.m_firstOffsetOfFirstLine;
        if (this.m_containsEndLine && !this.m_isSingleEmptyLine) {
            ++result;
        }
        assert (result >= 0) : "length of selection must be 0 or greater";
        return result;
    }
}

