/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.preferencepage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class PageDescriptor {
    private final String m_bundleId;
    private final String m_id;
    private final String m_label;
    private final String m_image;
    private final String m_classUri;
    private final boolean m_isSoftwareSystemBased;
    private List<PageDescriptor> m_children;

    public PageDescriptor(String bundleId, String id, String label, String image, String clazz, boolean isSoftwareSystemBased) {
        assert (bundleId != null && bundleId.length() > 0) : "Parameter 'bundleId' of method 'PageDescriptor' must not be empty";
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'LazyPreferenceNode' must not be empty";
        assert (label != null && label.length() > 0) : "Parameter 'label' of method 'LazyPreferenceNode' must not be empty";
        assert (image == null || !image.isEmpty()) : "Parameter 'image' of method 'PageDescriptor' must not be empty if not null";
        assert (clazz != null && clazz.length() > 0) : "Parameter 'clazz' of method 'PageDescriptor' must not be empty";
        this.m_bundleId = bundleId;
        this.m_id = id;
        this.m_label = label;
        this.m_image = image;
        this.m_classUri = "bundleclass://" + bundleId + "/" + clazz;
        this.m_isSoftwareSystemBased = isSoftwareSystemBased;
    }

    String getBundleId() {
        return this.m_bundleId;
    }

    String getId() {
        return this.m_id;
    }

    String getLabel() {
        return this.m_label;
    }

    String getImage() {
        return this.m_image;
    }

    String getClassUri() {
        return this.m_classUri;
    }

    boolean isSoftwareSystemBased() {
        return this.m_isSoftwareSystemBased;
    }

    void addChild(PageDescriptor child) {
        assert (child != null) : "Parameter 'child' of method 'addChild' must not be null";
        assert (this != child) : "Same instances";
        assert (this.isSoftwareSystemBased() == child.isSoftwareSystemBased()) : "Not of same type";
        if (this.m_children == null) {
            this.m_children = new ArrayList<PageDescriptor>(5);
        }
        assert (!this.m_children.contains(child)) : "Child already added";
        this.m_children.add(child);
    }

    void sortChildren(Comparator<PageDescriptor> comparator) {
        assert (comparator != null) : "Parameter 'comparator' of method 'sortChildren' must not be null";
        if (this.m_children != null) {
            this.m_children.sort(comparator);
            for (PageDescriptor nextChild : this.m_children) {
                nextChild.sortChildren(comparator);
            }
        }
    }

    List<PageDescriptor> getChildren() {
        return this.m_children != null ? Collections.unmodifiableList(this.m_children) : Collections.emptyList();
    }
}

