/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingWidget;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public abstract class ValidatingTabItemWidget<T>
extends ValidatingWidget {
    private final TabItem m_tabItem;
    private final IValidator<T> m_validator;
    private final IConsumer m_consumer;
    private final TabFolder m_tabFolder;

    public ValidatingTabItemWidget(TabFolder parent, String title, IValidator<T> validator, IConsumer consumer) {
        super((Composite)parent);
        assert (title != null && title.length() > 0) : "Parameter 'title' of method 'DefinitionTabItem' must not be empty";
        assert (parent != null) : "Parameter 'parent' of method 'DefinitionTabItem' must not be null";
        this.m_tabFolder = parent;
        this.m_tabItem = new TabItem(this.m_tabFolder, 0);
        this.m_tabItem.setText(title);
        this.m_validator = validator;
        this.m_consumer = consumer;
    }

    public void createWidgets() {
        this.m_tabItem.setControl(this.createTabItemContent(this.m_tabFolder));
    }

    protected abstract Control createTabItemContent(TabFolder var1);

    protected final TabItem getTabItem() {
        return this.m_tabItem;
    }

    protected final ValidationResult validate(T newObject) {
        ValidationResult result = this.m_validator.validate(newObject);
        this.updateDecoration(this.m_tabItem.getControl(), result);
        if (this.m_consumer != null) {
            this.m_consumer.notify(result);
        }
        return result;
    }

    protected void updateDecoration(Control control, ValidationResult result) {
        String decorationDescriptionText = this.getDecorationDescriptionText(result);
        if (this.m_tabItem.isDisposed() || this.m_tabItem.getParent().isDisposed()) {
            return;
        }
        if (decorationDescriptionText != null) {
            if (control != null) {
                if (result.isSuccess()) {
                    this.m_tabItem.setImage(UiResourceManager.getInstance().getImage("WarningMarker"));
                } else {
                    this.m_tabItem.setImage(UiResourceManager.getInstance().getImage("ErrorMarker"));
                }
                this.m_tabItem.setToolTipText(decorationDescriptionText);
            }
        } else if (control != null) {
            this.m_tabItem.setImage(null);
            this.m_tabItem.setToolTipText(null);
        }
        this.m_tabItem.getParent().redraw();
        this.finishUpdateDecoration();
    }

    protected Composite createContainer(TabFolder folder, int columns) {
        Composite container = new Composite((Composite)folder, 0);
        container.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithMargin((int)columns, (boolean)false));
        container.setBackground(folder.getBackground());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        return container;
    }

    public static interface IConsumer {
        public void notify(ValidationResult var1);
    }

    public static interface IValidator<T> {
        public ValidationResult validate(T var1);
    }
}

