/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.command.system.CreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.LoadQualityModelCommand;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.path.ResolvedQualityModelDescriptorFile;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.IDirectoryProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.ImportQualityModelSelector;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDescriptionWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.ValidatingPathComboWidget;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public final class SystemDirectoryWizardPage
extends NameAndDescriptionWizardPage
implements ISelectionChangedListener,
SelectionListener,
ValidatingPathComboWidget.IConsumer,
IDirectoryProvider {
    private static final String SETTINGS = "com.hello2morrow.sonargraph.standalone.qmImportHistory";
    private static final String RECENT_QMS = "recentQms";
    private static final int RECENT_QMS_LIMIT = 5;
    private final IPathValidator m_baseDirectoryPathValidator;
    private final IPathValidator m_qualityModelPathValidator;
    private final String m_directoryLabel;
    private final String m_qualityModelLabel;
    private final List<ResolvedQualityModelDescriptorFile> m_resolvedQMFileDescriptors;
    private TFile m_currentDirectory;
    private Button m_useQualityModelCheckbox;
    private TFile m_currentlySelectedQualityModelSymbolicFile;
    private ImportQualityModelSelector m_qualityModelSelector;
    private ImportQualityModel m_qualityModel;
    private ValidatingPathComboWidget m_validatingPathWidgetQualityModel;
    private List<String> m_recentQMS = new ArrayList<String>();
    private final int m_defaultQualityModelIndex;
    private boolean m_useQualityModel;

    public SystemDirectoryWizardPage(String pageName, String title, String nameFieldLabel, String directoryLabel, String qualityModelLabel, ITextValidator nameValidator, IPathValidator baseDirectoryPathValidator, IPathValidator qualityModelPathValidator, List<ResolvedQualityModelDescriptorFile> resolvedQMFileDescriptors, int defaultQualityModelIndex, String name, String description) {
        super(pageName, title, nameFieldLabel, nameValidator, name, description);
        assert (baseDirectoryPathValidator != null) : "Parameter 'baseDirectoryPathValidator' of method 'BaseDirectoryWizardPage' must not be null";
        assert (qualityModelPathValidator != null) : "Parameter 'qualityModelPathValidator' of method 'BaseDirectoryWizardPage' must not be null";
        assert (directoryLabel != null) : "Parameter 'm_directoryLabel' of method 'BaseDirectoryWizardPage' must not be null";
        assert (qualityModelLabel != null) : "Parameter 'qualityModelLabel' of method 'BaseDirectoryWizardPage' must not be null";
        assert (resolvedQMFileDescriptors != null && !resolvedQMFileDescriptors.isEmpty()) : "Parameter 'm_availableQualityModels' of method 'SystemDirectoryWizardPage' must not be empty";
        this.m_directoryLabel = directoryLabel;
        this.m_qualityModelLabel = qualityModelLabel;
        this.m_baseDirectoryPathValidator = baseDirectoryPathValidator;
        this.m_qualityModelPathValidator = qualityModelPathValidator;
        this.m_qualityModel = new ImportQualityModel();
        this.m_resolvedQMFileDescriptors = resolvedQMFileDescriptors;
        this.m_defaultQualityModelIndex = defaultQualityModelIndex;
        this.m_currentlySelectedQualityModelSymbolicFile = resolvedQMFileDescriptors.get(this.m_defaultQualityModelIndex).getQualityModelFileDescriptor().getSymbolicFile();
        IEclipsePreferences settings = PreferencesUtility.getPreferences((String)SETTINGS);
        this.m_recentQMS = PreferencesUtility.get((String)RECENT_QMS, (IEclipsePreferences)settings);
        for (ResolvedQualityModelDescriptorFile nextResolvedDescriptor : this.m_resolvedQMFileDescriptors) {
            String symbolicFilePath = nextResolvedDescriptor.getQualityModelFileDescriptor().getSymbolicFile().getPath();
            if (this.m_recentQMS.contains(symbolicFilePath)) continue;
            this.m_recentQMS.add(symbolicFilePath);
        }
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.SOFTWARE_SYSTEM_CREATION_WIZARD_PAGE;
    }

    @Override
    protected void addWidgetsToDialogAreaAfter(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'addWidgetsToDialogAreaAfter' must not be null";
        Label directoryLabel = new Label(composite, 0);
        directoryLabel.setText(this.m_directoryLabel);
        ValidatingPathWidget validatingPathWidgetDirectory = new ValidatingPathWidget(composite, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                SystemDirectoryWizardPage.this.m_currentDirectory = input;
                SystemDirectoryWizardPage.this.validate();
            }
        }, this.m_baseDirectoryPathValidator, 2, null, false);
        validatingPathWidgetDirectory.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.m_useQualityModelCheckbox = new Button(composite, 32);
        this.m_useQualityModelCheckbox.setText(this.m_qualityModelLabel);
        this.m_useQualityModelCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.m_useQualityModelCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemDirectoryWizardPage.this.m_useQualityModel = SystemDirectoryWizardPage.this.m_useQualityModelCheckbox.getSelection();
                SystemDirectoryWizardPage.this.m_validatingPathWidgetQualityModel.setVisible(SystemDirectoryWizardPage.this.m_useQualityModel);
                SystemDirectoryWizardPage.this.m_validatingPathWidgetQualityModel.setEnabled(SystemDirectoryWizardPage.this.m_useQualityModel);
                if (!SystemDirectoryWizardPage.this.m_useQualityModel) {
                    SystemDirectoryWizardPage.this.m_qualityModelSelector.setVisible(false);
                    SystemDirectoryWizardPage.this.m_qualityModelSelector.clear();
                } else {
                    SystemDirectoryWizardPage.this.setPath(SystemDirectoryWizardPage.this.m_currentlySelectedQualityModelSymbolicFile, true);
                }
            }
        });
        this.m_validatingPathWidgetQualityModel = new ValidatingPathComboWidget(composite, this, this.m_qualityModelPathValidator, 2, this.m_resolvedQMFileDescriptors.get(this.m_defaultQualityModelIndex).getQualityModelFileDescriptor().getSymbolicFile(), true, null);
        this.m_validatingPathWidgetQualityModel.setFilterExtensions(new String[]{"*" + CoreFileType.QUALITY_MODEL.getDefaultExtension()});
        this.m_validatingPathWidgetQualityModel.setLayoutData(new GridData(4, 0, true, false, 2, 1));
        this.m_validatingPathWidgetQualityModel.setVisible(false);
        this.m_validatingPathWidgetQualityModel.setEnabled(false);
        this.m_validatingPathWidgetQualityModel.setModifiable(false);
        this.m_qualityModelSelector = new ImportQualityModelSelector(composite, this.m_qualityModel, this, this);
        this.m_qualityModelSelector.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.m_qualityModelSelector.setVisible(false);
    }

    private void loadCandidates() {
        TFile realFile = this.m_currentlySelectedQualityModelSymbolicFile;
        for (ResolvedQualityModelDescriptorFile nextResolvedDescriptor : this.m_resolvedQMFileDescriptors) {
            if (!this.m_currentlySelectedQualityModelSymbolicFile.getPath().equals(nextResolvedDescriptor.getQualityModelFileDescriptor().getSymbolicFile().getPath())) continue;
            realFile = nextResolvedDescriptor.getResolvedFile();
            break;
        }
        assert (realFile != null) : "Parameter 'realFile' of method 'loadCandidates' must not be null";
        LoadQualityModelCommand command = new LoadQualityModelCommand(WorkbenchRegistry.getInstance().getProvider(), realFile, true);
        command.runSynchronously();
        ImportQualityModel qualityModel = command.getImportQualityModel();
        this.m_qualityModel = qualityModel != null ? qualityModel : new ImportQualityModel();
        this.m_qualityModelSelector.setInput(this.m_qualityModel);
        this.m_qualityModelSelector.setVisible(!this.m_qualityModel.getCandidates().isEmpty());
    }

    @Override
    public TFile getDirectory() {
        assert (this.isPageComplete()) : "Not valid";
        return this.m_currentDirectory;
    }

    public ImportQualityModel getImportQualityModel() {
        assert (this.isPageComplete()) : "Not valid";
        return this.m_useQualityModel ? this.m_qualityModel : null;
    }

    @Override
    protected void updatePageCompletion(boolean hasValidData) {
        if (!this.m_useQualityModelCheckbox.isDisposed()) {
            boolean validQualityModelData;
            boolean bl = this.m_useQualityModelCheckbox.getSelection() ? this.m_qualityModel != null : (validQualityModelData = true);
            if (this.m_useQualityModelCheckbox.getSelection() && validQualityModelData) {
                boolean atLeastOneIncluded = false;
                for (ImportQualityModel.ImportQualityModelCandidate nextCandidate : this.m_qualityModel.getCandidates()) {
                    if (!nextCandidate.isIncluded()) continue;
                    atLeastOneIncluded = true;
                    break;
                }
                boolean bl2 = validQualityModelData = validQualityModelData && atLeastOneIncluded;
            }
            if (validQualityModelData && this.m_currentDirectory != null && hasValidData) {
                this.setPageComplete(true);
                if (CreateSoftwareSystemCommand.validateSystemOverwrite((ISoftwareSystemProvider)WorkbenchRegistry.getInstance().getProvider(), (TFile)this.m_currentDirectory, (String)this.getElementName()) != null) {
                    this.setMessage("Project already exists in specified location", 2);
                } else {
                    this.setMessage("");
                }
            } else {
                this.setPageComplete(false);
                this.setMessage("There are input fields with errors, please check.", 3);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.validate();
    }

    @Override
    public void setPath(TFile input, boolean inputModified) {
        this.m_qualityModel = null;
        this.m_qualityModelSelector.setVisible(false);
        this.m_currentlySelectedQualityModelSymbolicFile = input;
        if (this.m_qualityModelPathValidator.isValid(null, this.m_currentlySelectedQualityModelSymbolicFile).isSuccess()) {
            this.loadCandidates();
            this.m_qualityModelSelector.setVisible(this.m_useQualityModelCheckbox.getSelection());
            this.addToHistory(this.m_currentlySelectedQualityModelSymbolicFile.getPath());
            IEclipsePreferences settings = PreferencesUtility.getPreferences((String)SETTINGS);
            PreferencesUtility.put((String)RECENT_QMS, this.m_recentQMS, (IEclipsePreferences)settings);
            PreferencesUtility.save((IEclipsePreferences)settings);
            this.m_validatingPathWidgetQualityModel.setItems(this.m_recentQMS.toArray(new String[this.m_recentQMS.size()]));
            this.m_validatingPathWidgetQualityModel.setSelectedItem(this.m_recentQMS.size() - 1);
        }
        this.validate();
    }

    private void addToHistory(String newEntry) {
        ArrayList<String> historyList = new ArrayList<String>(this.m_recentQMS);
        historyList.remove(newEntry);
        historyList.add(historyList.size(), newEntry);
        if (historyList.size() > 5) {
            historyList.remove(1);
        }
        this.m_recentQMS = historyList;
    }

    public void widgetSelected(SelectionEvent e) {
        this.validate();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }
}

