/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDescriptionDialog;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public final class SoftwareSystemDialog
extends NameAndDescriptionDialog {
    private final IPathValidator m_pathValidator;
    private final boolean m_creationMode;
    private boolean m_currentDirectoryModified;
    private TFile m_currentDirectory;

    public SoftwareSystemDialog(Shell parentShell, String title, ITextValidator nameValidator, IPathValidator pathValidator) {
        super(parentShell, title, nameValidator);
        assert (pathValidator != null) : "Parameter 'pathValidator' of method 'SoftwareSystemDialog' must not be null";
        this.m_pathValidator = pathValidator;
        this.m_creationMode = true;
    }

    public SoftwareSystemDialog(Shell parentShell, String title, ITextValidator nameValidator, IPathValidator pathValidator, TFile basePath, String name) {
        super(parentShell, title, nameValidator, name, null);
        assert (pathValidator != null) : "Parameter 'pathValidator' of method 'SoftwareSystemDialog' must not be null";
        assert (basePath != null) : "Parameter 'basePath' of method 'SoftwareSystemDialog' must not be null";
        this.m_pathValidator = pathValidator;
        this.m_currentDirectory = basePath;
        this.m_creationMode = false;
    }

    protected Point getPreferredSize() {
        return this.m_creationMode ? new Point(500, 80) : null;
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.SOFTWARE_SYSTEM_DIALOG;
    }

    @Override
    protected void addWidgetsToDialogAreaAfter(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'addWidgetsToDialogArea' must not be null";
        Label directoryLabel = new Label(composite, 0);
        directoryLabel.setText("Directory:");
        ValidatingPathWidget validatingPathWidget = new ValidatingPathWidget(composite, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                SoftwareSystemDialog.this.m_currentDirectory = input;
                SoftwareSystemDialog.this.m_currentDirectoryModified = inputModified;
                SoftwareSystemDialog.this.validate();
            }
        }, this.m_pathValidator, 2, this.m_creationMode ? null : this.m_currentDirectory, false);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        validatingPathWidget.setLayoutData((Object)layoutData);
    }

    @Override
    protected boolean validateAdditionalWidgets() {
        return this.m_currentDirectory != null;
    }

    @Override
    protected boolean additionalWidgetsModified() {
        return this.m_currentDirectoryModified;
    }

    public TFile getDirectory() {
        assert (this.hasValidData()) : "Not valid";
        return this.m_currentDirectory;
    }
}

