/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.foundation.utilities.HttpConnectionCheck;
import com.hello2morrow.sonargraph.foundation.utilities.HttpConnectionResult;
import com.hello2morrow.sonargraph.foundation.utilities.IConnectionConsumer;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class HttpConnectionCheckComposite
extends Composite
implements IConnectionConsumer {
    private final IInfoProvider m_infoProvider;
    private final Display m_display;
    private final Text m_testConnectionMessages;
    private final Button m_testConnection;
    private boolean m_checking;
    private boolean m_canceled;
    private int m_numberOfMessages;

    public HttpConnectionCheckComposite(Composite parent, final IInfoProvider infoProvider) {
        super(parent, 0);
        assert (parent != null) : "Parameter 'container' of method 'HttpConnectionCheckConsumer' must not be null";
        assert (infoProvider != null) : "Parameter 'urlProvider' of method 'HttpConnectionCheckConsumer' must not be null";
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.m_infoProvider = infoProvider;
        this.m_display = parent.getDisplay();
        this.m_testConnection = new Button((Composite)this, 8);
        this.m_testConnection.setText(this.m_infoProvider.getTestConnectionButtonLabel());
        this.m_testConnection.setLayoutData((Object)new GridData(4, 0, true, false));
        this.m_testConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!HttpConnectionCheckComposite.this.m_checking) {
                    HttpConnectionCheckComposite.this.m_checking = true;
                    HttpConnectionCheckComposite.this.m_infoProvider.setChecking(HttpConnectionCheckComposite.this.m_checking);
                    HttpConnectionCheckComposite.this.m_numberOfMessages = 0;
                    HttpConnectionCheckComposite.this.m_testConnectionMessages.setText("");
                    HttpConnectionCheckComposite.this.m_testConnection.setText("Cancel " + HttpConnectionCheckComposite.this.m_infoProvider.getTestConnectionButtonLabel());
                    SwtUtility.consumeUiEvents((Control)HttpConnectionCheckComposite.this.m_testConnection);
                    HttpConnectionCheck.canConnect((IConnectionConsumer)HttpConnectionCheckComposite.this, infoProvider.getUrls(), infoProvider.getHeaders(), (String)infoProvider.getExpectedResonse(), (ProxySettings)infoProvider.getProxy());
                } else {
                    HttpConnectionCheckComposite.this.m_canceled = true;
                    SwtUtility.consumeUiEvents((Control)HttpConnectionCheckComposite.this.m_testConnection);
                }
            }
        });
        this.m_testConnectionMessages = new Text((Composite)this, 2626);
        this.m_testConnectionMessages.setEditable(false);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = SwtUtility.calculatePreferredHeight((Text)this.m_testConnectionMessages, (int)6);
        this.m_testConnectionMessages.setLayoutData((Object)layoutData);
    }

    private boolean canUpdate() {
        if (!(this.m_display == null || this.m_display.isDisposed() || this.m_testConnection.isDisposed() || this.m_testConnectionMessages.isDisposed())) {
            return this.m_infoProvider.isActive();
        }
        return false;
    }

    public boolean hasBeenCanceled() {
        if (this.canUpdate()) {
            this.m_display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (HttpConnectionCheckComposite.this.canUpdate()) {
                        SwtUtility.consumeUiEvents((Control)HttpConnectionCheckComposite.this.m_testConnection);
                    }
                }
            });
        }
        return this.m_canceled || !this.canUpdate();
    }

    public void working(final String message) {
        if (message != null && !message.isEmpty() && this.canUpdate()) {
            this.m_display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (HttpConnectionCheckComposite.this.canUpdate()) {
                        HttpConnectionCheckComposite.this.appendToMessages(message, true);
                    }
                }
            });
        }
    }

    public void consumeResult(final HttpConnectionResult result, String uri, String content) {
        assert (result != null) : "Parameter 'result' of method 'consumeResult' must not be null";
        this.m_canceled = false;
        this.m_checking = false;
        if (this.canUpdate()) {
            this.m_display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (HttpConnectionCheckComposite.this.canUpdate()) {
                        switch (result) {
                            case SUCCESS: {
                                HttpConnectionCheckComposite.this.m_testConnection.setText(HttpConnectionCheckComposite.this.m_infoProvider.getTestConnectionButtonLabel() + " (Success)");
                                HttpConnectionCheckComposite.this.appendToMessages("\n=> Test connection successful.", false);
                                break;
                            }
                            case TIMEOUT: {
                                HttpConnectionCheckComposite.this.m_testConnection.setText(HttpConnectionCheckComposite.this.m_infoProvider.getTestConnectionButtonLabel() + " (Timeout)");
                                HttpConnectionCheckComposite.this.appendToMessages("\n=> Test connection timeout.", false);
                                break;
                            }
                            case FAILURE: {
                                HttpConnectionCheckComposite.this.m_testConnection.setText(HttpConnectionCheckComposite.this.m_infoProvider.getTestConnectionButtonLabel() + " (Failure)");
                                HttpConnectionCheckComposite.this.appendToMessages("\n=> Test connection failed.", false);
                                break;
                            }
                            case CANCELED: {
                                HttpConnectionCheckComposite.this.m_testConnection.setText(HttpConnectionCheckComposite.this.m_infoProvider.getTestConnectionButtonLabel() + " (Canceled)");
                                HttpConnectionCheckComposite.this.appendToMessages("\n=> Test connection canceled.", false);
                                break;
                            }
                            default: {
                                if (!$assertionsDisabled) {
                                    throw new AssertionError((Object)("Unhandled result: " + String.valueOf(result)));
                                }
                                break;
                            }
                        }
                    }
                    HttpConnectionCheckComposite.this.m_infoProvider.setChecking(HttpConnectionCheckComposite.this.m_checking);
                }
            });
        }
    }

    private void appendToMessages(String message, boolean incNumber) {
        assert (message != null && message.length() > 0) : "Parameter 'message' of method 'appendToMessages' must not be empty";
        ++this.m_numberOfMessages;
        String previousText = this.m_testConnectionMessages.getText();
        if (previousText != null && !previousText.isEmpty()) {
            this.m_testConnectionMessages.append("\n");
        }
        if (incNumber) {
            this.m_testConnectionMessages.append("(" + this.m_numberOfMessages + ") ");
        }
        this.m_testConnectionMessages.append(message);
        SwtUtility.consumeUiEvents((Control)this.m_testConnectionMessages);
    }

    public boolean isChecking() {
        return this.m_checking;
    }

    public void enableTestConnectionButton(boolean enable) {
        this.m_testConnection.setEnabled(enable && !this.m_checking);
        this.m_testConnection.setText(this.m_infoProvider.getTestConnectionButtonLabel());
    }

    public void setDefaultButton(Shell shell) {
        assert (shell != null) : "Parameter 'shell' of method 'setDefaultButton' must not be null";
        shell.setDefaultButton(this.m_testConnection);
    }

    public void reset() {
        assert (!this.m_checking) : "Is checking";
        this.m_numberOfMessages = 0;
        this.m_testConnectionMessages.setText("");
    }

    public String getLastMessage() {
        return null;
    }

    public HttpConnectionResult getResult() {
        return null;
    }

    public String getURI() {
        return null;
    }

    public String getContent() {
        return null;
    }

    public static interface IInfoProvider {
        public List<String> getUrls();

        public String getExpectedResonse();

        public ProxySettings getProxy();

        public boolean isActive();

        public void setChecking(boolean var1);

        public String getTestConnectionButtonLabel();

        default public Map<String, String> getHeaders() {
            return Collections.emptyMap();
        }
    }
}

