/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base;

import com.hello2morrow.sonargraph.core.model.common.FormatterOptions;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public final class EditorPreferences {
    public static int SAME_LINE = 0;
    public static int NEXT_LINE = 1;
    private static final String ID = "com.hello2morrow.sonargraph.standalone.editorPreferences";
    private static final String PREFIX = "editor.";
    public static final String AUTOFORMAT = "editor.autoformat";
    public static final String SHOWWHITESPACE = "editor.showwhitespace";
    public static final String USETABS = "editor.usetabs";
    public static final String INDENTEMPTYLINES = "editor.indentemptylines";
    public static final String INDENTSIZE = "editor.indentsize";
    public static final String BRACESSTART = "editor.bracesstart";
    public static final String BRACESEND = "editor.bracesend";
    public static final String MAXLINELENGTH = "editor.maxlinelength";
    public static final String LINEBREAK = "editor.linebreak";
    public static final boolean AUTOFORMAT_DEFAULT = true;
    public static final boolean SHOWWHITESPACE_DEFAULT = false;
    public static final boolean USETABS_DEFAULT = false;
    public static final boolean INDENTEMPTYLINES_DEFAULT = true;
    public static final int INDENTSIZE_DEFAULT = 4;
    public static final int BRACESSTART_DEFAULT = 1;
    public static final int BRACESEND_DEFAULT = 1;
    private boolean m_useTabs;
    private int m_indentSize;
    private int m_bracesStart;
    private int m_bracesEnd;
    private boolean m_indentEmptyLines;
    private boolean m_autoFormat;
    private boolean m_showWhiteSpace;

    public EditorPreferences() {
        this.refresh();
    }

    public static String getId() {
        return ID;
    }

    public static boolean isKey(String key) {
        return key != null && key.startsWith(PREFIX);
    }

    private EditorPreferences(EditorPreferences copy) {
        this.m_useTabs = copy.m_useTabs;
        this.m_indentSize = copy.m_indentSize;
        this.m_bracesStart = copy.m_bracesStart;
        this.m_bracesEnd = copy.m_bracesEnd;
        this.m_indentEmptyLines = copy.m_indentEmptyLines;
        this.m_autoFormat = copy.m_autoFormat;
        this.m_showWhiteSpace = copy.m_showWhiteSpace;
    }

    public void refresh() {
        IEclipsePreferences preferences = PreferencesUtility.getPreferences((String)ID);
        this.m_indentEmptyLines = preferences.getBoolean(INDENTEMPTYLINES, true);
        this.m_bracesStart = preferences.getInt(BRACESSTART, 1);
        this.m_bracesEnd = preferences.getInt(BRACESEND, 1);
        this.m_indentSize = preferences.getInt(INDENTSIZE, 4);
        this.m_useTabs = preferences.getBoolean(USETABS, false);
        this.m_autoFormat = preferences.getBoolean(AUTOFORMAT, true);
        this.m_showWhiteSpace = preferences.getBoolean(SHOWWHITESPACE, false);
    }

    public void setToDefaults() {
        this.m_indentEmptyLines = true;
        this.m_bracesStart = 1;
        this.m_bracesEnd = 1;
        this.m_indentSize = 4;
        this.m_useTabs = false;
        this.m_autoFormat = true;
        this.m_showWhiteSpace = false;
    }

    public FormatterOptions getFormatterOptions() {
        FormatterOptions.BracesPlacement bracesStart = this.getBracesStart() == NEXT_LINE ? FormatterOptions.BracesPlacement.NEXT_LINE : FormatterOptions.BracesPlacement.SAME_LINE;
        FormatterOptions.BracesPlacement bracesEnd = this.getBracesEnd() == NEXT_LINE ? FormatterOptions.BracesPlacement.NEXT_LINE : FormatterOptions.BracesPlacement.SAME_LINE;
        return new FormatterOptions(bracesEnd, bracesStart, this.isIndentEmptyLines(), this.useTabs(), this.getTabSize());
    }

    public void setUseTabs(boolean useTabs) {
        this.m_useTabs = useTabs;
    }

    public void setIndentSize(int indentSize) {
        this.m_indentSize = indentSize;
    }

    public void setBracesStart(int bracesStart) {
        this.m_bracesStart = bracesStart;
    }

    public void setBracesEnd(int bracesEnd) {
        this.m_bracesEnd = bracesEnd;
    }

    public void setIndentEmptyLines(boolean indentEmptyLines) {
        this.m_indentEmptyLines = indentEmptyLines;
    }

    public void setAutoFormat(boolean autoFormat) {
        this.m_autoFormat = autoFormat;
    }

    public void setShowWhiteSpace(boolean showWhiteSpace) {
        this.m_showWhiteSpace = showWhiteSpace;
    }

    public int getBracesStart() {
        return this.m_bracesStart;
    }

    public boolean useTabs() {
        return this.m_useTabs;
    }

    public int getBracesEnd() {
        return this.m_bracesEnd;
    }

    public boolean isIndentEmptyLines() {
        return this.m_indentEmptyLines;
    }

    public boolean isAutoFormat() {
        return this.m_autoFormat;
    }

    public int getTabSize() {
        return this.m_indentSize;
    }

    public boolean isShowWhiteSpace() {
        return this.m_showWhiteSpace;
    }

    public EditorPreferences copy() {
        return new EditorPreferences(this);
    }

    public void store() throws BackingStoreException {
        IEclipsePreferences preferences = PreferencesUtility.getPreferences((String)ID);
        preferences.putBoolean(USETABS, this.m_useTabs);
        preferences.putInt(INDENTSIZE, this.m_indentSize);
        preferences.putInt(BRACESSTART, this.m_bracesStart);
        preferences.putInt(BRACESEND, this.m_bracesEnd);
        preferences.putBoolean(INDENTEMPTYLINES, this.m_indentEmptyLines);
        preferences.putBoolean(AUTOFORMAT, this.m_autoFormat);
        preferences.putBoolean(SHOWWHITESPACE, this.m_showWhiteSpace);
        preferences.flush();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_autoFormat ? 1231 : 1237);
        result = 31 * result + this.m_bracesEnd;
        result = 31 * result + this.m_bracesStart;
        result = 31 * result + (this.m_indentEmptyLines ? 1231 : 1237);
        result = 31 * result + this.m_indentSize;
        result = 31 * result + (this.m_showWhiteSpace ? 1231 : 1237);
        result = 31 * result + (this.m_useTabs ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EditorPreferences other = (EditorPreferences)obj;
        if (this.m_autoFormat != other.m_autoFormat) {
            return false;
        }
        if (this.m_bracesEnd != other.m_bracesEnd) {
            return false;
        }
        if (this.m_bracesStart != other.m_bracesStart) {
            return false;
        }
        if (this.m_indentEmptyLines != other.m_indentEmptyLines) {
            return false;
        }
        if (this.m_indentSize != other.m_indentSize) {
            return false;
        }
        if (this.m_showWhiteSpace != other.m_showWhiteSpace) {
            return false;
        }
        return this.m_useTabs == other.m_useTabs;
    }
}

