/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architectureview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerState;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureProvider;
import com.hello2morrow.sonargraph.core.model.common.AutoCompletionProposal;
import com.hello2morrow.sonargraph.core.model.common.IOriginator;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultStateChangedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableFileDeletedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.MultipleModifiableFileModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.history.IUndoRedoEntry;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.ui.standalone.architectureview.ArchitectureFileSourceViewWidget;
import com.hello2morrow.sonargraph.ui.standalone.architectureview.ArchitectureFileViewIssueVisitor;
import com.hello2morrow.sonargraph.ui.standalone.architectureview.ArchitectureView;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.AutoCompletionProposalViewer;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.EditableSourceViewWidget;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.IViewWithAutoCompletion;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.IViewWithSourceOperations;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.IViewWithUndoRedo;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.SourceViewWidgetBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.Gesture;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewWithZoom;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ArchitectureFileViewShowInViewSupport;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchAuxiliaryView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArchitectureFileView
extends WorkbenchSlaveView
implements IOriginator,
IViewWithSourceOperations,
IViewWithZoom,
IViewWithAutoCompletion,
IViewWithUndoRedo {
    private static Logger LOGGER = LoggerFactory.getLogger(ArchitectureFileView.class);
    private ArchitectureFileSourceViewWidget m_sourceViewWidget;
    private ArchitectureFile m_architectureFile;
    private SourceViewWidgetBasedTextSearchHandler m_textSearchProvider;

    public IViewId getViewId() {
        return ViewId.ARCHITECTURE_FILE_VIEW;
    }

    protected final EnumSet<WorkbenchView.EventCategory> getDisabledEventCategories() {
        return EnumSet.of(WorkbenchView.EventCategory.INSTALLATION);
    }

    protected boolean supportsSleep() {
        return false;
    }

    @Override
    public boolean isAutoCompletionPossible() {
        SoftwareSystem system = this.getSoftwareSystem();
        return system != null && this.m_architectureFile != null && !this.m_sourceViewWidget.isDisposed() && SonargraphCommand.isAvailable((ICommandId)CoreCommandId.MODIFY_ARCHITECTURE_FILE_SOURCE, (SoftwareSystem)system);
    }

    @Override
    public void autoCompletionRequested() {
        if (this.isAutoCompletionPossible()) {
            AutoCompletionProposal proposal;
            Display display;
            IArchitectureProvider provider = (IArchitectureProvider)this.getSoftwareSystem().getExtension(IArchitectureProvider.class);
            StyledText sourceWidget = this.m_sourceViewWidget.getSourceWidget();
            int caretOffset = sourceWidget.getCaretOffset();
            int line = sourceWidget.getLineAtOffset(caretOffset);
            String text = sourceWidget.getText();
            List proposals = provider.getAutoCompletionProposals(this.m_architectureFile, text, caretOffset, line + 1);
            if (!proposals.isEmpty() && (display = WorkbenchRegistry.getInstance().getDisplay()) != null && !display.isDisposed() && (proposal = AutoCompletionProposalViewer.getProposal(this.getShell(), display.map((Control)sourceWidget, null, sourceWidget.getLocationAtOffset(caretOffset)), proposals)) != null) {
                sourceWidget.replaceTextRange(proposal.getReplacementOffset(), proposal.getReplacementLength(), proposal.getProposal());
                sourceWidget.setCaretOffset(proposal.getReplacementOffset() + proposal.getProposal().length() + proposal.getOffsetIncrement());
            }
        }
    }

    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        SashForm sashForm = new SashForm(viewContentArea, 512);
        SwtUtility.applySashSeparatorStyle((SashForm)sashForm);
        boolean isReadOnly = !SonargraphCommand.isAvailable((ICommandId)CoreCommandId.MODIFY_ARCHITECTURE_FILE_SOURCE, (SoftwareSystem)this.getSoftwareSystem());
        this.m_sourceViewWidget = new ArchitectureFileSourceViewWidget((Composite)sashForm, isReadOnly, this);
        if (!isReadOnly && LOGGER.isTraceEnabled()) {
            this.m_sourceViewWidget.getMainControl().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if (!$assertionsDisabled && event == null) {
                        throw new AssertionError((Object)"Parameter 'event' of method 'keyPressed' must not be null");
                    }
                    if (event.keyCode == 32 && (event.stateMask & 0x40000) != 0) {
                        ArchitectureFileView.this.autoCompletionRequested();
                    }
                }
            });
        }
        this.m_textSearchProvider = new SourceViewWidgetBasedTextSearchHandler(this.m_sourceViewWidget, !isReadOnly, this.getViewId().getPresentationName());
        EventManager.getInstance().attach((EventHandler)new EventHandler<MultipleModifiableFileModifiedEvent>(MultipleModifiableFileModifiedEvent.class, (Object)this){

            public void handleEvent(MultipleModifiableFileModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (ArchitectureFileView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getModifiableFiles().contains(ArchitectureFileView.this.m_architectureFile)) {
                    for (IModifiableFile next : event.getModifiableFiles()) {
                        ArchitectureFileView.this.handleModifiableFileModifiedEvent(next, event.getModificationTrigger(next), event.getAspects(next));
                    }
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableFileDeletedEvent>(ModifiableFileDeletedEvent.class, (Object)this){

            public void handleEvent(ModifiableFileDeletedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (ArchitectureFileView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getModifiableFiles().contains(ArchitectureFileView.this.m_architectureFile)) {
                    ArchitectureFileView.this.clearAndCloseView();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultStateChangedEvent>(AnalyzerResultStateChangedEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultStateChangedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (ArchitectureFileView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getResult().getId() == CoreAnalyzerId.ARCHITECTURE_CHECK) {
                    AnalyzerState state = event.getState();
                    if (state == AnalyzerState.FINISHED) {
                        ArchitectureFileView.this.updateMarkers();
                    } else if (state == AnalyzerState.CANCELLED || state == AnalyzerState.HAS_NOT_BEEN_RUN) {
                        ArchitectureFileView.this.m_sourceViewWidget.clearMarkers();
                    }
                }
            }
        });
    }

    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        assert (modification != null) : "Parameter 'modification' of method 'softwareSystemModified' must not be null";
        if (modification.contains(Modification.WORKSPACE_CLEARED) || modification.contains(Modification.VIRTUAL_MODEL_CHANGED) || modification.contains(Modification.VIRTUAL_MODEL_MODIFIED)) {
            this.updateMarkers();
        }
        super.softwareSystemModified(modification, restoredFromHistory);
    }

    protected void destroyViewContent() {
        EventManager.getInstance().detach(MultipleModifiableFileModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(ModifiableFileDeletedEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzerResultStateChangedEvent.class, (Object)this);
        this.m_architectureFile = null;
        if (this.m_sourceViewWidget != null) {
            if (!this.m_sourceViewWidget.isDisposed()) {
                this.m_sourceViewWidget.clear();
                this.m_sourceViewWidget.dispose();
            }
            this.m_sourceViewWidget = null;
        }
        super.destroyViewContent();
    }

    public IModifiableFile getModifiableFile() {
        return this.m_architectureFile;
    }

    private void handleModifiableFileModifiedEvent(IModifiableFile modifiableFile, IOriginator modificationTrigger, EnumSet<MultipleModifiableFileModifiedEvent.Aspect> aspects) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'handleModifiableFileModifiedEvent' must not be null";
        assert (aspects != null) : "Parameter 'aspects' of method 'handleModifiableFileModifiedEvent' must not be null";
        if (this.m_architectureFile == null) {
            return;
        }
        if (this.m_architectureFile == modifiableFile) {
            if (!this.m_architectureFile.isValid()) {
                this.clearAndCloseView();
                return;
            }
            if (modificationTrigger != this) {
                this.m_sourceViewWidget.showSource((FilePath)this.m_architectureFile, -1, false, true, this.m_architectureFile.getContent());
                this.m_sourceViewWidget.clearUndoRedo();
            }
            WorkbenchRegistry.getInstance().updatePartNameForModifiableFileState(this.getPart(), this.m_architectureFile.getShortName());
        }
    }

    private void updateMarkers() {
        if (this.m_sourceViewWidget != null && !this.m_sourceViewWidget.isDisposed()) {
            this.m_sourceViewWidget.clearMarkers();
        }
        if (this.m_architectureFile != null && this.m_architectureFile.isValid()) {
            this.m_architectureFile.accept((NamedElement.INamedElementVisitor)new ArchitectureFileViewIssueVisitor(this.m_sourceViewWidget));
        }
    }

    public void showInView(IContext context, List<Element> elements, List<IStandardEnumeration> options, boolean secondaryIdReused) {
        assert (elements != null) : "Parameter 'elements' of method 'showInView' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'showInView' must not be empty";
        assert (options != null) : "Parameter 'options' of method 'showInView' must not be null";
        ArchitectureFileViewShowInViewSupport.FileTarget fileTarget = ArchitectureFileViewShowInViewSupport.getArchitectureFileTarget(elements, options);
        assert (fileTarget != null) : "Parameter 'fileTarget' of method 'showInView' must not be null";
        this.m_architectureFile = fileTarget.getFilePath();
        assert (this.m_architectureFile != null) : "Parameter 'm_architectureFile' of method 'updateViewContent' must not be null";
        int lineNumber = fileTarget.getLineNumber();
        WorkbenchRegistry.getInstance().updatePartNameForModifiableFileState(this.getPart(), this.m_architectureFile.getShortName());
        this.m_sourceViewWidget.setRedraw(false);
        this.m_sourceViewWidget.showSource((FilePath)this.m_architectureFile, lineNumber, true, false, this.m_architectureFile.getContent());
        this.m_sourceViewWidget.setRedraw(true);
        this.updateMarkers();
        this.getSelectionProviderAdapter().handleSelectionChanged((Element)this.m_architectureFile);
    }

    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        assert (elements != null) : "Parameter 'elements' of method 'finishShowInView' must not be null";
        WorkbenchRegistry.getInstance().selectView((IWorkbenchView)this);
    }

    public List<Control> getControlsForInteraction() {
        assert (this.m_sourceViewWidget != null) : "'m_sourceViewWidget' of method 'getControlsForInteraction' must not be null";
        return Collections.singletonList(this.m_sourceViewWidget.getMainControl());
    }

    protected EnumSet<Gesture> getDisabledGestures() {
        return EnumSet.of(Gesture.DOUBLE_CLICK);
    }

    private void clearAndCloseView() {
        if (this.m_sourceViewWidget != null && !this.m_sourceViewWidget.isDisposed()) {
            this.m_sourceViewWidget.clear();
        }
        this.resetPartName();
        this.hideView();
    }

    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.clearAndCloseView();
    }

    public List<Element> getSelectedElements() {
        return this.getSelectionProviderAdapter().getElementList((Element)this.m_sourceViewWidget.getSourceFile());
    }

    public String getPresentationName() {
        return super.getPresentationName() + (String)(this.m_architectureFile != null ? " [" + this.m_architectureFile.getIdentifyingPath() + "]" : "");
    }

    public Search supportsSearch() {
        if (this.m_sourceViewWidget.isReadOnly()) {
            return Search.FIND_TEXT;
        }
        return Search.FIND_REPLACE_TEXT;
    }

    protected ITextSearchHandler getTextSearchHandler() {
        return this.m_textSearchProvider;
    }

    public boolean supportsCopy() {
        return !this.m_sourceViewWidget.getSelectedTextInfo().isEmpty();
    }

    public String copy() {
        String selection = this.m_sourceViewWidget.getSelectedTextInfo().getSelectedText();
        assert (selection != null && selection.length() > 0) : "'selection' of method 'getCopyToClipBoardData' must not be empty";
        return selection;
    }

    public boolean supportsPaste() {
        return !this.m_sourceViewWidget.isReadOnly() && this.m_sourceViewWidget.isFocusControl();
    }

    public void paste() {
        this.m_sourceViewWidget.setInPasteOperation(true);
        this.m_sourceViewWidget.getSourceWidget().paste();
        this.m_sourceViewWidget.setInPasteOperation(false);
    }

    public boolean supportsCut() {
        return !this.m_sourceViewWidget.getSelectedTextInfo().isEmpty() && !this.m_sourceViewWidget.isReadOnly() && this.m_sourceViewWidget.isFocusControl();
    }

    public void cut() {
        this.m_sourceViewWidget.getSourceWidget().cut();
    }

    protected void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'restoreState' must not be null";
        this.m_sourceViewWidget.getSourceWidget().forceFocus();
    }

    protected void performViewSelectionChanged(IWorkbenchView view, List<Element> elements) {
        IViewId viewId;
        assert (elements != null) : "Parameter 'elements' of method 'selectionChanged' must not be null";
        if (view != null && view instanceof WorkbenchAuxiliaryView && !elements.isEmpty() && (viewId = view.getViewId()) == ViewId.MARKERS_VIEW && ((WorkbenchAuxiliaryView)view).getConnectedView() == this) {
            assert (this.m_sourceViewWidget != null) : "'m_sourceViewWidget' of method 'selectionChanged' must not be null";
            Element first = elements.get(0);
            int lineNumber = first.getLineNumber();
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            this.m_sourceViewWidget.gotoLine(lineNumber, true);
        }
    }

    @Override
    public void handleOperation(EditableSourceViewWidget.Operation blockOperation) {
        assert (blockOperation != null) : "Parameter 'blockOperation' of method 'handleBlockOperation' must not be null";
        this.m_sourceViewWidget.handleOperation(blockOperation);
    }

    @Override
    public boolean canExecuteOperation() {
        return !this.m_sourceViewWidget.isReadOnly();
    }

    public List<IStandardEnumeration> getAdditionalShowInViewOptions() {
        Object object;
        ArrayList<IStandardEnumeration> options = new ArrayList<IStandardEnumeration>(1);
        MPart part = RcpUtility.findPart((IEclipseContext)this.getEclipseContext(), (IViewId)ViewId.ARCHITECTURE_VIEW, null);
        PresentationMode mode = PresentationMode.MIXED;
        if (part != null && (object = part.getObject()) != null && object instanceof ArchitectureView) {
            mode = ((ArchitectureView)object).getPresentationMode();
        }
        options.add((IStandardEnumeration)mode);
        return options;
    }

    public void zoomIn(Point location) {
        this.m_sourceViewWidget.zoomIn();
    }

    public void zoomOut(Point location) {
        this.m_sourceViewWidget.zoomOut();
    }

    @Override
    public IUndoRedoEntry isUndoPossible() {
        if (this.m_sourceViewWidget != null && !this.m_sourceViewWidget.isDisposed()) {
            return this.m_sourceViewWidget.isUndoPossible();
        }
        return null;
    }

    @Override
    public IUndoRedoEntry isRedoPossible() {
        if (this.m_sourceViewWidget != null && !this.m_sourceViewWidget.isDisposed()) {
            return this.m_sourceViewWidget.isRedoPossible();
        }
        return null;
    }

    @Override
    public void undo() {
        if (this.m_sourceViewWidget != null && !this.m_sourceViewWidget.isDisposed()) {
            this.m_sourceViewWidget.undo();
        }
    }

    @Override
    public void redo() {
        if (this.m_sourceViewWidget != null && !this.m_sourceViewWidget.isDisposed()) {
            this.m_sourceViewWidget.redo();
        }
    }
}

